-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
local session_collection = require 'session.domain.session_collection'
local class = require 'mc.class'
local log = require 'mc.logging'
local IamService = require 'iam.service'
local session_service = require 'session.service.session_service'
local session_service_mdb = require 'session.interface.mdb.session_service_mdb'
local session_mdb = require 'session.interface.mdb.session_mdb'
local IamApp = class(IamService)

function IamApp:ctor()
    self.m_session_service = session_service.new()
    self.m_session_service_mdb = session_service_mdb.new(self.m_session_service.collections)
    self.m_session_service_mdb:regist_session_signals()
    self.m_session_service:create_service_to_mdb()

    self.m_session_mdb = session_mdb.new(self.m_session_service)
    self.m_session_mdb:regist_session_signals()
end

function IamApp:init()
    IamApp.super.init(self)
    self:register_init_rpc()
    self:mock_init_rpc()
    self.m_session_service:session_timeout_monitor_start()
end

function IamApp:register_init_rpc()
    self:ImplSessionSessionSessionDelete(function(obj, ctx, ...)
        return self.m_session_service:delete_session(obj.values.SessionId, ...)
    end)
    self:ImplSessionsSessionsNewSession(function(obj, ctx, ...)
        return self.m_session_service:new_session(ctx, ...)
    end)
    self:ImplSessionsSessionsValidateSession(function(obj, ctx, ...)
        return self.m_session_service:validate_session(ctx, ...)
    end)
    self:ImplSessionsSessionsValidateSessionWithCsrf(function(obj, ctx, ...)
        return self.m_session_service:validate_session(ctx, ...)
    end)
    self:ImplAuthenticationAuthenticationAuthenticate(function(obj, ctx, ...)
        return self.m_session_service:authenticate(ctx, ...)
    end)
end

function IamApp:mock_init_rpc()
    self:ImplSessionsSessionsNewRemoteConsoleSession(function(obj, ctx, ...)
        return self.m_session_service:new_console_session(ctx, ...)
    end)

    self:ImplSessionsSessionsNewVNCSession(function(obj, ctx, ...)
        return ' '
    end)

    self:ImplSessionsSessionsGetSessionLogoutType(function(obj, ctx, ...)
        return 1
    end)

    self:ImplSessionsSessionsSessionHeartBeat(function(obj, ctx, ...)
        self.m_session_service:handle_heart_beat(...)
    end)

    self:ImplSessionsSessionsGetCLISessionList(function(obj, ctx, ...)
        return {}
    end)

    self:ImplSessionsSessionsNewSessionBySSO(function(obj, ctx, ...)
        return ' ', ' ', ' '
    end)

    self:ImplSessionsSessionsSetKvmKey(function(obj, ctx, ...)
        return self.m_session_service:set_kvm_key(ctx, ...)
    end)

    self:ImplSessionsSessionsDeleteAllSessions(function(obj, ctx, ...)
        return self.m_session_service:delete_all_sessions(...)
    end)

    self:ImplSessionsSessionsNewSessionByCert(function(obj, ctx, ...)
        return ' ', ' ', ' '
    end)

    self:ImplLDAPControllerLDAPControllerSetBindDnPassword(function(obj, ctx, ...)
        return
    end)

    self:ImplKerberosKerberosImportKeyTable(function(obj, ctx, ...)
        return
    end)

    self:ImplRemoteGroupsRemoteGroupsNew(function(obj, ctx, ...)
        return ' '
    end)

    self:ImplRemoteGroupRemoteGroupDelete(function(obj, ctx, ...)
        return
    end)
end

return IamApp
