-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
local M = {}

M.t_authentication = { { Id = 1, AccountLockoutDuration = 300, AccountLockoutThreshold = 5 } }
M.t_certificate_authentication = { { Id = 1, Enable = false, OCSPEnabled = false } }
M.t_session_service = {
    {
        SessionType = [=[SessionType_GUI]=],
        SessionTimeout = 300,
        SessionModeDB = [=[OccupationMode_Exclusive]=],
        SessionMaxCount = 4
    }, {
    SessionType = [=[SessionType_Redfish]=],
    SessionTimeout = 300,
    SessionModeDB = [=[OccupationMode_Shared]=],
    SessionMaxCount = 10
    }, {
    SessionType = [=[SessionType_CLI]=],
    SessionTimeout = 900,
    SessionModeDB = [=[OccupationMode_Shared]=],
    SessionMaxCount = 10
    }   , {
    SessionType = [=[SessionType_SSO]=],
    SessionTimeout = 60,
    SessionModeDB = [=[OccupationMode_Exclusive]=],
    SessionMaxCount = 1
    }, {
    SessionType = [=[SessionType_KVM]=],
    SessionTimeout = 3600,
    SessionModeDB = [=[OccupationMode_Shared]=],
    SessionMaxCount = 2
    }, {
    SessionType = [=[SessionType_VNC]=],
    SessionTimeout = 3600,
    SessionModeDB = [=[OccupationMode_Shared]=],
    SessionMaxCount = 5
    }, {
    SessionType = [=[SessionType_VEDIO]=],
    SessionTimeout = 600,
    SessionModeDB = [=[OccupationMode_Exclusive]=],
    SessionMaxCount = 1
    }
}
M.t_ldap = { { Id = 1, Enable = false } }
M.t_ldap_controller = {
    {
        Id = 1,
        Enabled = true,
        HostAddr = [=[]=],
        Port = 636,
        UserDomain = [=[]=],
        LdapVer = 3,
        Folder = [=[]=],
        BaseDN = [=[]=],
        BindDN = [=[]=],
        BindDNPsw = [=[]=],
        Scope = [=[sub]=],
        TimeLimit = 2,
        BindTimeLimit = 2,
        CertVerifyEnabled = false,
        CertVerifyLevel = 2,
        CRLVerificationEnable = false
    }, {
    Id = 2,
    Enabled = true,
    HostAddr = [=[]=],
    Port = 636,
    UserDomain = [=[]=],
    LdapVer = 3,
    Folder = [=[]=],
    BaseDN = [=[]=],
    BindDN = [=[]=],
    BindDNPsw = [=[]=],
    Scope = [=[sub]=],
    TimeLimit = 2,
    BindTimeLimit = 2,
    CertVerifyEnabled = false,
    CertVerifyLevel = 2,
    CRLVerificationEnable = false
    }, {
    Id = 3,
    Enabled = true,
    HostAddr = [=[]=],
    Port = 636,
    UserDomain = [=[]=],
    LdapVer = 3,
    Folder = [=[]=],
    BaseDN = [=[]=],
    BindDN = [=[]=],
    BindDNPsw = [=[]=],
    Scope = [=[sub]=],
    TimeLimit = 2,
    BindTimeLimit = 2,
    CertVerifyEnabled = false,
    CertVerifyLevel = 2,
    CRLVerificationEnable = false
    }, {
    Id = 4,
    Enabled = true,
    HostAddr = [=[]=],
    Port = 636,
    UserDomain = [=[]=],
    LdapVer = 3,
    Folder = [=[]=],
    BaseDN = [=[]=],
    BindDN = [=[]=],
    BindDNPsw = [=[]=],
    Scope = [=[sub]=],
    TimeLimit = 2,
    BindTimeLimit = 2,
    CertVerifyEnabled = false,
    CertVerifyLevel = 2,
    CRLVerificationEnable = false
    }, {
    Id = 5,
    Enabled = true,
    HostAddr = [=[]=],
    Port = 636,
    UserDomain = [=[]=],
    LdapVer = 3,
    Folder = [=[]=],
    BaseDN = [=[]=],
    BindDN = [=[]=],
    BindDNPsw = [=[]=],
    Scope = [=[sub]=],
    TimeLimit = 2,
    BindTimeLimit = 2,
    CertVerifyEnabled = false,
    CertVerifyLevel = 2,
    CRLVerificationEnable = false
    }, {
    Id = 6,
    Enabled = true,
    HostAddr = [=[]=],
    Port = 636,
    UserDomain = [=[]=],
    LdapVer = 3,
    Folder = [=[]=],
    BaseDN = [=[]=],
    BindDN = [=[]=],
    BindDNPsw = [=[]=],
    Scope = [=[sub]=],
    TimeLimit = 2,
    BindTimeLimit = 2,
    CertVerifyEnabled = false,
    CertVerifyLevel = 2,
    CRLVerificationEnable = false
    }
}
M.t_kerberos = { { Id = 1, Enabled = false, Address = [=[]=], Port = 88, Realm = [=[]=] } }
M.t_usb_authentication = { { Id = 1, USBUncompressPassword = [=[]=] } }
M.t_sessions = { { Id = 0, ValidateSsoClient = false } }
return {}
