-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
local validate = require 'mc.validate'
local utils = require 'mc.utils'
local mdb = require 'mc.mdb'

local SessionService = {}

---@class SessionService.SessionMaxCount
---@field SessionMaxCount integer
local TSessionMaxCount = {}
TSessionMaxCount.__index = TSessionMaxCount
TSessionMaxCount.group = {}

local function TSessionMaxCount_from_obj(obj)
    return setmetatable(obj, TSessionMaxCount)
end

function TSessionMaxCount.new(SessionMaxCount)
    return TSessionMaxCount_from_obj({SessionMaxCount = SessionMaxCount})
end
---@param obj SessionService.SessionMaxCount
function TSessionMaxCount:init_from_obj(obj)
    self.SessionMaxCount = obj.SessionMaxCount
end

function TSessionMaxCount:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSessionMaxCount.group)
end

TSessionMaxCount.from_obj = TSessionMaxCount_from_obj

TSessionMaxCount.proto_property = {'SessionMaxCount'}

TSessionMaxCount.default = {0}

TSessionMaxCount.struct = {{name = 'SessionMaxCount', is_array = false, struct = nil}}

function TSessionMaxCount:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'SessionMaxCount', self.SessionMaxCount, 'uint32', true, errs, need_convert)

    TSessionMaxCount:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSessionMaxCount.proto_property, errs, need_convert)
    return self
end

function TSessionMaxCount:unpack(_)
    return self.SessionMaxCount
end

SessionService.SessionMaxCount = TSessionMaxCount

---@class SessionService.SessionMode
---@field SessionMode integer
local TSessionMode = {}
TSessionMode.__index = TSessionMode
TSessionMode.group = {}

local function TSessionMode_from_obj(obj)
    return setmetatable(obj, TSessionMode)
end

function TSessionMode.new(SessionMode)
    return TSessionMode_from_obj({SessionMode = SessionMode or 1})
end
---@param obj SessionService.SessionMode
function TSessionMode:init_from_obj(obj)
    self.SessionMode = obj.SessionMode or 1
end

function TSessionMode:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSessionMode.group)
end

TSessionMode.from_obj = TSessionMode_from_obj

TSessionMode.proto_property = {'SessionMode'}

TSessionMode.default = {0}

TSessionMode.struct = {{name = 'SessionMode', is_array = false, struct = nil}}

function TSessionMode:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'SessionMode', self.SessionMode, 'uint32', false, errs, need_convert)

    TSessionMode:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSessionMode.proto_property, errs, need_convert)
    return self
end

function TSessionMode:unpack(_)
    return self.SessionMode
end

SessionService.SessionMode = TSessionMode

---@class SessionService.SessionTimeout
---@field SessionTimeout integer
local TSessionTimeout = {}
TSessionTimeout.__index = TSessionTimeout
TSessionTimeout.group = {}

local function TSessionTimeout_from_obj(obj)
    return setmetatable(obj, TSessionTimeout)
end

function TSessionTimeout.new(SessionTimeout)
    return TSessionTimeout_from_obj({SessionTimeout = SessionTimeout})
end
---@param obj SessionService.SessionTimeout
function TSessionTimeout:init_from_obj(obj)
    self.SessionTimeout = obj.SessionTimeout
end

function TSessionTimeout:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSessionTimeout.group)
end

TSessionTimeout.from_obj = TSessionTimeout_from_obj

TSessionTimeout.proto_property = {'SessionTimeout'}

TSessionTimeout.default = {0}

TSessionTimeout.struct = {{name = 'SessionTimeout', is_array = false, struct = nil}}

function TSessionTimeout:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'SessionTimeout', self.SessionTimeout, 'uint32', false, errs, need_convert)

    TSessionTimeout:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSessionTimeout.proto_property, errs, need_convert)
    return self
end

function TSessionTimeout:unpack(_)
    return self.SessionTimeout
end

SessionService.SessionTimeout = TSessionTimeout

SessionService.interface = mdb.register_interface('bmc.kepler.SessionService', {
    SessionTimeout = {'u', {'EMIT_CHANGE'}, false, nil, false},
    SessionMode = {'u', {'EMIT_CHANGE'}, false, 1, false},
    SessionMaxCount = {'u', {'EMIT_CHANGE'}, true, nil, false}
}, {}, {})

return SessionService
