-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
local validate = require 'mc.validate'
local utils = require 'mc.utils'
local mdb = require 'mc.mdb'

local RemoteGroups = {}

---@class RemoteGroups.NewRsp
---@field GroupId string
local TNewRsp = {}
TNewRsp.__index = TNewRsp
TNewRsp.group = {}

local function TNewRsp_from_obj(obj)
    return setmetatable(obj, TNewRsp)
end

function TNewRsp.new(GroupId)
    return TNewRsp_from_obj({GroupId = GroupId})
end
---@param obj RemoteGroups.NewRsp
function TNewRsp:init_from_obj(obj)
    self.GroupId = obj.GroupId
end

function TNewRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TNewRsp.group)
end

TNewRsp.from_obj = TNewRsp_from_obj

TNewRsp.proto_property = {'GroupId'}

TNewRsp.default = {''}

TNewRsp.struct = {{name = 'GroupId', is_array = false, struct = nil}}

function TNewRsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'GroupId', self.GroupId, 'string', false, errs, need_convert)

    TNewRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TNewRsp.proto_property, errs, need_convert)
    return self
end

function TNewRsp:unpack(_)
    return self.GroupId
end

RemoteGroups.NewRsp = TNewRsp

---@class RemoteGroups.NewReq
---@field GroupType integer
---@field ControllerId integer
---@field MemberId integer
---@field Name string
---@field Folder string
---@field SID string
---@field UserRoleId integer
---@field PermitRuleIds string[]
---@field LoginInterface string[]
local TNewReq = {}
TNewReq.__index = TNewReq
TNewReq.group = {}

local function TNewReq_from_obj(obj)
    return setmetatable(obj, TNewReq)
end

function TNewReq.new(GroupType, ControllerId, MemberId, Name, Folder, SID, UserRoleId, PermitRuleIds, LoginInterface)
    return TNewReq_from_obj({
        GroupType = GroupType,
        ControllerId = ControllerId,
        MemberId = MemberId,
        Name = Name,
        Folder = Folder,
        SID = SID,
        UserRoleId = UserRoleId,
        PermitRuleIds = PermitRuleIds,
        LoginInterface = LoginInterface
    })
end
---@param obj RemoteGroups.NewReq
function TNewReq:init_from_obj(obj)
    self.GroupType = obj.GroupType
    self.ControllerId = obj.ControllerId
    self.MemberId = obj.MemberId
    self.Name = obj.Name
    self.Folder = obj.Folder
    self.SID = obj.SID
    self.UserRoleId = obj.UserRoleId
    self.PermitRuleIds = obj.PermitRuleIds
    self.LoginInterface = obj.LoginInterface
end

function TNewReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TNewReq.group)
end

TNewReq.from_obj = TNewReq_from_obj

TNewReq.proto_property = {
    'GroupType', 'ControllerId', 'MemberId', 'Name', 'Folder', 'SID', 'UserRoleId', 'PermitRuleIds', 'LoginInterface'
}

TNewReq.default = {0, 0, 0, '', '', '', 0, {}, {}}

TNewReq.struct = {
    {name = 'GroupType', is_array = false, struct = nil}, {name = 'ControllerId', is_array = false, struct = nil},
    {name = 'MemberId', is_array = false, struct = nil}, {name = 'Name', is_array = false, struct = nil},
    {name = 'Folder', is_array = false, struct = nil}, {name = 'SID', is_array = false, struct = nil},
    {name = 'UserRoleId', is_array = false, struct = nil}, {name = 'PermitRuleIds', is_array = true, struct = nil},
    {name = 'LoginInterface', is_array = true, struct = nil}
}

function TNewReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'GroupType', self.GroupType, 'uint8', true, errs, need_convert)
    validate.Optional(prefix .. 'ControllerId', self.ControllerId, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'MemberId', self.MemberId, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'Name', self.Name, 'string', false, errs, need_convert)
    validate.Optional(prefix .. 'Folder', self.Folder, 'string', false, errs, need_convert)
    validate.Optional(prefix .. 'SID', self.SID, 'string', false, errs, need_convert)
    validate.Optional(prefix .. 'UserRoleId', self.UserRoleId, 'uint8', false, errs, need_convert)
    validate.OptionalArray(prefix .. 'PermitRuleIds', self.PermitRuleIds, 'string', false, errs, need_convert)
    validate.OptionalArray(prefix .. 'LoginInterface', self.LoginInterface, 'string', false, errs, need_convert)

    if self.MemberId ~= nil then
        validate.ranges(prefix .. 'MemberId', self.MemberId, 0, 5, errs, need_convert)
    end

    TNewReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TNewReq.proto_property, errs, need_convert)
    return self
end

function TNewReq:unpack(_)
    return self.GroupType, self.ControllerId, self.MemberId, self.Name, self.Folder, self.SID, self.UserRoleId,
        self.PermitRuleIds, self.LoginInterface
end

RemoteGroups.NewReq = TNewReq

RemoteGroups.interface = mdb.register_interface('bmc.kepler.AccountService.RemoteGroups', {},
    {New = {'a{ss}yyysssyasas', 's', TNewReq, TNewRsp}}, {})

return RemoteGroups
