-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
local validate = require 'mc.validate'
local utils = require 'mc.utils'
local mdb = require 'mc.mdb'

local RemoteGroup = {}

---@class RemoteGroup.LoginInterface
---@field LoginInterface string[]
local TLoginInterface = {}
TLoginInterface.__index = TLoginInterface
TLoginInterface.group = {}

local function TLoginInterface_from_obj(obj)
    return setmetatable(obj, TLoginInterface)
end

function TLoginInterface.new(LoginInterface)
    return TLoginInterface_from_obj({LoginInterface = LoginInterface or {}})
end
---@param obj RemoteGroup.LoginInterface
function TLoginInterface:init_from_obj(obj)
    self.LoginInterface = obj.LoginInterface or {}
end

function TLoginInterface:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TLoginInterface.group)
end

TLoginInterface.from_obj = TLoginInterface_from_obj

TLoginInterface.proto_property = {'LoginInterface'}

TLoginInterface.default = {{}}

TLoginInterface.struct = {{name = 'LoginInterface', is_array = true, struct = nil}}

function TLoginInterface:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.OptionalArray(prefix .. 'LoginInterface', self.LoginInterface, 'string', false, errs, need_convert)

    TLoginInterface:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TLoginInterface.proto_property, errs, need_convert)
    return self
end

function TLoginInterface:unpack(_)
    return self.LoginInterface
end

RemoteGroup.LoginInterface = TLoginInterface

---@class RemoteGroup.PermitRuleIds
---@field PermitRuleIds string[]
local TPermitRuleIds = {}
TPermitRuleIds.__index = TPermitRuleIds
TPermitRuleIds.group = {}

local function TPermitRuleIds_from_obj(obj)
    return setmetatable(obj, TPermitRuleIds)
end

function TPermitRuleIds.new(PermitRuleIds)
    return TPermitRuleIds_from_obj({PermitRuleIds = PermitRuleIds or {}})
end
---@param obj RemoteGroup.PermitRuleIds
function TPermitRuleIds:init_from_obj(obj)
    self.PermitRuleIds = obj.PermitRuleIds or {}
end

function TPermitRuleIds:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TPermitRuleIds.group)
end

TPermitRuleIds.from_obj = TPermitRuleIds_from_obj

TPermitRuleIds.proto_property = {'PermitRuleIds'}

TPermitRuleIds.default = {{}}

TPermitRuleIds.struct = {{name = 'PermitRuleIds', is_array = true, struct = nil}}

function TPermitRuleIds:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.OptionalArray(prefix .. 'PermitRuleIds', self.PermitRuleIds, 'string', false, errs, need_convert)

    TPermitRuleIds:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TPermitRuleIds.proto_property, errs, need_convert)
    return self
end

function TPermitRuleIds:unpack(_)
    return self.PermitRuleIds
end

RemoteGroup.PermitRuleIds = TPermitRuleIds

---@class RemoteGroup.Folder
---@field Folder string
local TFolder = {}
TFolder.__index = TFolder
TFolder.group = {}

local function TFolder_from_obj(obj)
    return setmetatable(obj, TFolder)
end

function TFolder.new(Folder)
    return TFolder_from_obj({Folder = Folder})
end
---@param obj RemoteGroup.Folder
function TFolder:init_from_obj(obj)
    self.Folder = obj.Folder
end

function TFolder:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TFolder.group)
end

TFolder.from_obj = TFolder_from_obj

TFolder.proto_property = {'Folder'}

TFolder.default = {''}

TFolder.struct = {{name = 'Folder', is_array = false, struct = nil}}

function TFolder:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'Folder', self.Folder, 'string', false, errs, need_convert)

    TFolder:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TFolder.proto_property, errs, need_convert)
    return self
end

function TFolder:unpack(_)
    return self.Folder
end

RemoteGroup.Folder = TFolder

---@class RemoteGroup.UserRoleId
---@field UserRoleId integer
local TUserRoleId = {}
TUserRoleId.__index = TUserRoleId
TUserRoleId.group = {}

local function TUserRoleId_from_obj(obj)
    return setmetatable(obj, TUserRoleId)
end

function TUserRoleId.new(UserRoleId)
    return TUserRoleId_from_obj({UserRoleId = UserRoleId})
end
---@param obj RemoteGroup.UserRoleId
function TUserRoleId:init_from_obj(obj)
    self.UserRoleId = obj.UserRoleId
end

function TUserRoleId:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TUserRoleId.group)
end

TUserRoleId.from_obj = TUserRoleId_from_obj

TUserRoleId.proto_property = {'UserRoleId'}

TUserRoleId.default = {0}

TUserRoleId.struct = {{name = 'UserRoleId', is_array = false, struct = nil}}

function TUserRoleId:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Required(prefix .. 'UserRoleId', self.UserRoleId, 'uint8', false, errs, need_convert)

    TUserRoleId:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TUserRoleId.proto_property, errs, need_convert)
    return self
end

function TUserRoleId:unpack(_)
    return self.UserRoleId
end

RemoteGroup.UserRoleId = TUserRoleId

---@class RemoteGroup.Name
---@field Name string
local TName = {}
TName.__index = TName
TName.group = {}

local function TName_from_obj(obj)
    return setmetatable(obj, TName)
end

function TName.new(Name)
    return TName_from_obj({Name = Name})
end
---@param obj RemoteGroup.Name
function TName:init_from_obj(obj)
    self.Name = obj.Name
end

function TName:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TName.group)
end

TName.from_obj = TName_from_obj

TName.proto_property = {'Name'}

TName.default = {''}

TName.struct = {{name = 'Name', is_array = false, struct = nil}}

function TName:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Required(prefix .. 'Name', self.Name, 'string', false, errs, need_convert)

    TName:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TName.proto_property, errs, need_convert)
    return self
end

function TName:unpack(_)
    return self.Name
end

RemoteGroup.Name = TName

---@class RemoteGroup.SID
---@field SID string
local TSID = {}
TSID.__index = TSID
TSID.group = {}

local function TSID_from_obj(obj)
    return setmetatable(obj, TSID)
end

function TSID.new(SID)
    return TSID_from_obj({SID = SID})
end
---@param obj RemoteGroup.SID
function TSID:init_from_obj(obj)
    self.SID = obj.SID
end

function TSID:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSID.group)
end

TSID.from_obj = TSID_from_obj

TSID.proto_property = {'SID'}

TSID.default = {''}

TSID.struct = {{name = 'SID', is_array = false, struct = nil}}

function TSID:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Required(prefix .. 'SID', self.SID, 'string', false, errs, need_convert)

    TSID:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSID.proto_property, errs, need_convert)
    return self
end

function TSID:unpack(_)
    return self.SID
end

RemoteGroup.SID = TSID

---@class RemoteGroup.ControllerId
---@field ControllerId integer
local TControllerId = {}
TControllerId.__index = TControllerId
TControllerId.group = {}

local function TControllerId_from_obj(obj)
    return setmetatable(obj, TControllerId)
end

function TControllerId.new(ControllerId)
    return TControllerId_from_obj({ControllerId = ControllerId})
end
---@param obj RemoteGroup.ControllerId
function TControllerId:init_from_obj(obj)
    self.ControllerId = obj.ControllerId
end

function TControllerId:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TControllerId.group)
end

TControllerId.from_obj = TControllerId_from_obj

TControllerId.proto_property = {'ControllerId'}

TControllerId.default = {0}

TControllerId.struct = {{name = 'ControllerId', is_array = false, struct = nil}}

function TControllerId:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'ControllerId', self.ControllerId, 'uint8', true, errs, need_convert)

    TControllerId:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TControllerId.proto_property, errs, need_convert)
    return self
end

function TControllerId:unpack(_)
    return self.ControllerId
end

RemoteGroup.ControllerId = TControllerId

---@class RemoteGroup.GroupType
---@field GroupType integer
local TGroupType = {}
TGroupType.__index = TGroupType
TGroupType.group = {}

local function TGroupType_from_obj(obj)
    return setmetatable(obj, TGroupType)
end

function TGroupType.new(GroupType)
    return TGroupType_from_obj({GroupType = GroupType})
end
---@param obj RemoteGroup.GroupType
function TGroupType:init_from_obj(obj)
    self.GroupType = obj.GroupType
end

function TGroupType:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TGroupType.group)
end

TGroupType.from_obj = TGroupType_from_obj

TGroupType.proto_property = {'GroupType'}

TGroupType.default = {0}

TGroupType.struct = {{name = 'GroupType', is_array = false, struct = nil}}

function TGroupType:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'GroupType', self.GroupType, 'uint8', true, errs, need_convert)

    TGroupType:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TGroupType.proto_property, errs, need_convert)
    return self
end

function TGroupType:unpack(_)
    return self.GroupType
end

RemoteGroup.GroupType = TGroupType

---@class RemoteGroup.DeleteRsp
local TDeleteRsp = {}
TDeleteRsp.__index = TDeleteRsp
TDeleteRsp.group = {}

local function TDeleteRsp_from_obj(obj)
    return setmetatable(obj, TDeleteRsp)
end

function TDeleteRsp.new()
    return TDeleteRsp_from_obj({})
end
---@param obj RemoteGroup.DeleteRsp
function TDeleteRsp:init_from_obj(obj)

end

function TDeleteRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TDeleteRsp.group)
end

TDeleteRsp.from_obj = TDeleteRsp_from_obj

TDeleteRsp.proto_property = {}

TDeleteRsp.default = {}

TDeleteRsp.struct = {}

function TDeleteRsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    TDeleteRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TDeleteRsp.proto_property, errs, need_convert)
    return self
end

function TDeleteRsp:unpack(_)
end

RemoteGroup.DeleteRsp = TDeleteRsp

---@class RemoteGroup.DeleteReq
local TDeleteReq = {}
TDeleteReq.__index = TDeleteReq
TDeleteReq.group = {}

local function TDeleteReq_from_obj(obj)
    return setmetatable(obj, TDeleteReq)
end

function TDeleteReq.new()
    return TDeleteReq_from_obj({})
end
---@param obj RemoteGroup.DeleteReq
function TDeleteReq:init_from_obj(obj)

end

function TDeleteReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TDeleteReq.group)
end

TDeleteReq.from_obj = TDeleteReq_from_obj

TDeleteReq.proto_property = {}

TDeleteReq.default = {}

TDeleteReq.struct = {}

function TDeleteReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    TDeleteReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TDeleteReq.proto_property, errs, need_convert)
    return self
end

function TDeleteReq:unpack(_)
end

RemoteGroup.DeleteReq = TDeleteReq

RemoteGroup.interface = mdb.register_interface('bmc.kepler.AccountService.RemoteGroup', {
    GroupType = {'y', {'CONST'}, true, nil, false},
    ControllerId = {'y', {'CONST'}, true, nil, false},
    SID = {'s', {'EMIT_CHANGE'}, false, nil, false},
    Name = {'s', {'EMIT_CHANGE'}, false, nil, false},
    UserRoleId = {'y', {'EMIT_CHANGE'}, false, nil, false},
    Folder = {'s', {'EMIT_CHANGE'}, false, nil, false},
    PermitRuleIds = {'as', {'EMIT_CHANGE'}, false, {}, false},
    LoginInterface = {'as', {'EMIT_CHANGE'}, false, {}, false}
}, {Delete = {'a{ss}', '', TDeleteReq, TDeleteRsp}}, {})

return RemoteGroup
