-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
local validate = require 'mc.validate'
local utils = require 'mc.utils'
local mdb = require 'mc.mdb'
local create_enum_type = require 'mc.enum'

local ManagerAccount = {}

---@class ManagerAccount.EnumLoginRuleIds: Enum
local EEnumLoginRuleIds = create_enum_type('EnumLoginRuleIds')
EEnumLoginRuleIds.default = EEnumLoginRuleIds.new(2147483647)
EEnumLoginRuleIds.struct = nil
EEnumLoginRuleIds.Rule_Invalid = EEnumLoginRuleIds.new(0)
EEnumLoginRuleIds.Rule1 = EEnumLoginRuleIds.new(1)
EEnumLoginRuleIds.Rule2 = EEnumLoginRuleIds.new(2)
EEnumLoginRuleIds.Rule3 = EEnumLoginRuleIds.new(4)

ManagerAccount.EnumLoginRuleIds = EEnumLoginRuleIds

---@class ManagerAccount.EnumLoginInterface: Enum
local EEnumLoginInterface = create_enum_type('EnumLoginInterface')
EEnumLoginInterface.default = EEnumLoginInterface.new(2147483647)
EEnumLoginInterface.struct = nil
EEnumLoginInterface.Invalid = EEnumLoginInterface.new(0)
EEnumLoginInterface.Web = EEnumLoginInterface.new(1)
EEnumLoginInterface.SNMP = EEnumLoginInterface.new(2)
EEnumLoginInterface.IPMI = EEnumLoginInterface.new(4)
EEnumLoginInterface.SSH = EEnumLoginInterface.new(8)
EEnumLoginInterface.SFTP = EEnumLoginInterface.new(16)
EEnumLoginInterface.Local = EEnumLoginInterface.new(64)
EEnumLoginInterface.Redfish = EEnumLoginInterface.new(128)

ManagerAccount.EnumLoginInterface = EEnumLoginInterface

---@class ManagerAccount.EnumAccountType: Enum
local EEnumAccountType = create_enum_type('EnumAccountType')
EEnumAccountType.default = EEnumAccountType.new(2147483647)
EEnumAccountType.struct = nil
EEnumAccountType.Local = EEnumAccountType.new(0)
EEnumAccountType.LDAP = EEnumAccountType.new(1)
EEnumAccountType.Kerberos = EEnumAccountType.new(2)
EEnumAccountType.VNC = EEnumAccountType.new(3)
EEnumAccountType.KVM = EEnumAccountType.new(4)
EEnumAccountType.KerberosSSO = EEnumAccountType.new(5)
EEnumAccountType.IPMI_INNER = EEnumAccountType.new(6)

ManagerAccount.EnumAccountType = EEnumAccountType

---@class ManagerAccount.RoleType: Enum
local ERoleType = create_enum_type('RoleType')
ERoleType.default = ERoleType.new(2147483647)
ERoleType.struct = nil
ERoleType.NoAccess = ERoleType.new(0)
ERoleType.CommonUser = ERoleType.new(2)
ERoleType.Operator = ERoleType.new(3)
ERoleType.Administrator = ERoleType.new(4)
ERoleType.CustomRole1 = ERoleType.new(5)
ERoleType.CustomRole2 = ERoleType.new(6)
ERoleType.CustomRole3 = ERoleType.new(7)
ERoleType.CustomRole4 = ERoleType.new(8)

ManagerAccount.RoleType = ERoleType

---@class ManagerAccount.EnumLoginPolicy: Enum
local EEnumLoginPolicy = create_enum_type('EnumLoginPolicy')
EEnumLoginPolicy.default = EEnumLoginPolicy.new(2147483647)
EEnumLoginPolicy.struct = nil
EEnumLoginPolicy.LP_Null = EEnumLoginPolicy.new(0)
EEnumLoginPolicy.LP_PromptPasswordReset = EEnumLoginPolicy.new(1)
EEnumLoginPolicy.LP_ForcePasswordReset = EEnumLoginPolicy.new(2)

ManagerAccount.EnumLoginPolicy = EEnumLoginPolicy

---@class ManagerAccount.LoginInterface
---@field LoginInterface string[]
local TLoginInterface = {}
TLoginInterface.__index = TLoginInterface
TLoginInterface.group = {}

local function TLoginInterface_from_obj(obj)
    return setmetatable(obj, TLoginInterface)
end

function TLoginInterface.new(LoginInterface)
    return TLoginInterface_from_obj({LoginInterface = LoginInterface})
end
---@param obj ManagerAccount.LoginInterface
function TLoginInterface:init_from_obj(obj)
    self.LoginInterface = obj.LoginInterface
end

function TLoginInterface:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TLoginInterface.group)
end

TLoginInterface.from_obj = TLoginInterface_from_obj

TLoginInterface.proto_property = {'LoginInterface'}

TLoginInterface.default = {{}}

TLoginInterface.struct = {{name = 'LoginInterface', is_array = true, struct = nil}}

function TLoginInterface:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.OptionalArray(prefix .. 'LoginInterface', self.LoginInterface, 'string', false, errs, need_convert)

    TLoginInterface:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TLoginInterface.proto_property, errs, need_convert)
    return self
end

function TLoginInterface:unpack(_)
    return self.LoginInterface
end

ManagerAccount.LoginInterface = TLoginInterface

---@class ManagerAccount.Privileges
---@field Privileges string[]
local TPrivileges = {}
TPrivileges.__index = TPrivileges
TPrivileges.group = {}

local function TPrivileges_from_obj(obj)
    return setmetatable(obj, TPrivileges)
end

function TPrivileges.new(Privileges)
    return TPrivileges_from_obj({Privileges = Privileges})
end
---@param obj ManagerAccount.Privileges
function TPrivileges:init_from_obj(obj)
    self.Privileges = obj.Privileges
end

function TPrivileges:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TPrivileges.group)
end

TPrivileges.from_obj = TPrivileges_from_obj

TPrivileges.proto_property = {'Privileges'}

TPrivileges.default = {{}}

TPrivileges.struct = {{name = 'Privileges', is_array = true, struct = nil}}

function TPrivileges:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.OptionalArray(prefix .. 'Privileges', self.Privileges, 'string', true, errs, need_convert)

    TPrivileges:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TPrivileges.proto_property, errs, need_convert)
    return self
end

function TPrivileges:unpack(_)
    return self.Privileges
end

ManagerAccount.Privileges = TPrivileges

---@class ManagerAccount.FirstLoginPolicy
---@field FirstLoginPolicy integer
local TFirstLoginPolicy = {}
TFirstLoginPolicy.__index = TFirstLoginPolicy
TFirstLoginPolicy.group = {}

local function TFirstLoginPolicy_from_obj(obj)
    return setmetatable(obj, TFirstLoginPolicy)
end

function TFirstLoginPolicy.new(FirstLoginPolicy)
    return TFirstLoginPolicy_from_obj({FirstLoginPolicy = FirstLoginPolicy or 2})
end
---@param obj ManagerAccount.FirstLoginPolicy
function TFirstLoginPolicy:init_from_obj(obj)
    self.FirstLoginPolicy = obj.FirstLoginPolicy or 2
end

function TFirstLoginPolicy:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TFirstLoginPolicy.group)
end

TFirstLoginPolicy.from_obj = TFirstLoginPolicy_from_obj

TFirstLoginPolicy.proto_property = {'FirstLoginPolicy'}

TFirstLoginPolicy.default = {0}

TFirstLoginPolicy.struct = {{name = 'FirstLoginPolicy', is_array = false, struct = nil}}

function TFirstLoginPolicy:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'FirstLoginPolicy', self.FirstLoginPolicy, 'uint8', false, errs, need_convert)

    TFirstLoginPolicy:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TFirstLoginPolicy.proto_property, errs, need_convert)
    return self
end

function TFirstLoginPolicy:unpack(_)
    return self.FirstLoginPolicy
end

ManagerAccount.FirstLoginPolicy = TFirstLoginPolicy

---@class ManagerAccount.LastLoginInterface
---@field LastLoginInterface string
local TLastLoginInterface = {}
TLastLoginInterface.__index = TLastLoginInterface
TLastLoginInterface.group = {}

local function TLastLoginInterface_from_obj(obj)
    return setmetatable(obj, TLastLoginInterface)
end

function TLastLoginInterface.new(LastLoginInterface)
    return TLastLoginInterface_from_obj({LastLoginInterface = LastLoginInterface})
end
---@param obj ManagerAccount.LastLoginInterface
function TLastLoginInterface:init_from_obj(obj)
    self.LastLoginInterface = obj.LastLoginInterface
end

function TLastLoginInterface:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TLastLoginInterface.group)
end

TLastLoginInterface.from_obj = TLastLoginInterface_from_obj

TLastLoginInterface.proto_property = {'LastLoginInterface'}

TLastLoginInterface.default = {''}

TLastLoginInterface.struct = {{name = 'LastLoginInterface', is_array = false, struct = nil}}

function TLastLoginInterface:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'LastLoginInterface', self.LastLoginInterface, 'string', true, errs, need_convert)

    TLastLoginInterface:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TLastLoginInterface.proto_property, errs, need_convert)
    return self
end

function TLastLoginInterface:unpack(_)
    return self.LastLoginInterface
end

ManagerAccount.LastLoginInterface = TLastLoginInterface

---@class ManagerAccount.LastLoginIP
---@field LastLoginIP string
local TLastLoginIP = {}
TLastLoginIP.__index = TLastLoginIP
TLastLoginIP.group = {}

local function TLastLoginIP_from_obj(obj)
    return setmetatable(obj, TLastLoginIP)
end

function TLastLoginIP.new(LastLoginIP)
    return TLastLoginIP_from_obj({LastLoginIP = LastLoginIP})
end
---@param obj ManagerAccount.LastLoginIP
function TLastLoginIP:init_from_obj(obj)
    self.LastLoginIP = obj.LastLoginIP
end

function TLastLoginIP:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TLastLoginIP.group)
end

TLastLoginIP.from_obj = TLastLoginIP_from_obj

TLastLoginIP.proto_property = {'LastLoginIP'}

TLastLoginIP.default = {''}

TLastLoginIP.struct = {{name = 'LastLoginIP', is_array = false, struct = nil}}

function TLastLoginIP:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'LastLoginIP', self.LastLoginIP, 'string', true, errs, need_convert)

    TLastLoginIP:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TLastLoginIP.proto_property, errs, need_convert)
    return self
end

function TLastLoginIP:unpack(_)
    return self.LastLoginIP
end

ManagerAccount.LastLoginIP = TLastLoginIP

---@class ManagerAccount.LastLoginTime
---@field LastLoginTime integer
local TLastLoginTime = {}
TLastLoginTime.__index = TLastLoginTime
TLastLoginTime.group = {}

local function TLastLoginTime_from_obj(obj)
    return setmetatable(obj, TLastLoginTime)
end

function TLastLoginTime.new(LastLoginTime)
    return TLastLoginTime_from_obj({LastLoginTime = LastLoginTime})
end
---@param obj ManagerAccount.LastLoginTime
function TLastLoginTime:init_from_obj(obj)
    self.LastLoginTime = obj.LastLoginTime
end

function TLastLoginTime:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TLastLoginTime.group)
end

TLastLoginTime.from_obj = TLastLoginTime_from_obj

TLastLoginTime.proto_property = {'LastLoginTime'}

TLastLoginTime.default = {0}

TLastLoginTime.struct = {{name = 'LastLoginTime', is_array = false, struct = nil}}

function TLastLoginTime:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'LastLoginTime', self.LastLoginTime, 'uint32', true, errs, need_convert)

    TLastLoginTime:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TLastLoginTime.proto_property, errs, need_convert)
    return self
end

function TLastLoginTime:unpack(_)
    return self.LastLoginTime
end

ManagerAccount.LastLoginTime = TLastLoginTime

---@class ManagerAccount.LoginRuleIds
---@field LoginRuleIds string[]
local TLoginRuleIds = {}
TLoginRuleIds.__index = TLoginRuleIds
TLoginRuleIds.group = {}

local function TLoginRuleIds_from_obj(obj)
    return setmetatable(obj, TLoginRuleIds)
end

function TLoginRuleIds.new(LoginRuleIds)
    return TLoginRuleIds_from_obj({LoginRuleIds = LoginRuleIds})
end
---@param obj ManagerAccount.LoginRuleIds
function TLoginRuleIds:init_from_obj(obj)
    self.LoginRuleIds = obj.LoginRuleIds
end

function TLoginRuleIds:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TLoginRuleIds.group)
end

TLoginRuleIds.from_obj = TLoginRuleIds_from_obj

TLoginRuleIds.proto_property = {'LoginRuleIds'}

TLoginRuleIds.default = {{}}

TLoginRuleIds.struct = {{name = 'LoginRuleIds', is_array = true, struct = nil}}

function TLoginRuleIds:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.OptionalArray(prefix .. 'LoginRuleIds', self.LoginRuleIds, 'string', false, errs, need_convert)

    TLoginRuleIds:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TLoginRuleIds.proto_property, errs, need_convert)
    return self
end

function TLoginRuleIds:unpack(_)
    return self.LoginRuleIds
end

ManagerAccount.LoginRuleIds = TLoginRuleIds

---@class ManagerAccount.AccountType
---@field AccountType string
local TAccountType = {}
TAccountType.__index = TAccountType
TAccountType.group = {}

local function TAccountType_from_obj(obj)
    return setmetatable(obj, TAccountType)
end

function TAccountType.new(AccountType)
    return TAccountType_from_obj({AccountType = AccountType})
end
---@param obj ManagerAccount.AccountType
function TAccountType:init_from_obj(obj)
    self.AccountType = obj.AccountType
end

function TAccountType:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TAccountType.group)
end

TAccountType.from_obj = TAccountType_from_obj

TAccountType.proto_property = {'AccountType'}

TAccountType.default = {''}

TAccountType.struct = {{name = 'AccountType', is_array = false, struct = nil}}

function TAccountType:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'AccountType', self.AccountType, 'string', true, errs, need_convert)

    TAccountType:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TAccountType.proto_property, errs, need_convert)
    return self
end

function TAccountType:unpack(_)
    return self.AccountType
end

ManagerAccount.AccountType = TAccountType

---@class ManagerAccount.SshPublicKeyHash
---@field SshPublicKeyHash string
local TSshPublicKeyHash = {}
TSshPublicKeyHash.__index = TSshPublicKeyHash
TSshPublicKeyHash.group = {}

local function TSshPublicKeyHash_from_obj(obj)
    return setmetatable(obj, TSshPublicKeyHash)
end

function TSshPublicKeyHash.new(SshPublicKeyHash)
    return TSshPublicKeyHash_from_obj({SshPublicKeyHash = SshPublicKeyHash})
end
---@param obj ManagerAccount.SshPublicKeyHash
function TSshPublicKeyHash:init_from_obj(obj)
    self.SshPublicKeyHash = obj.SshPublicKeyHash
end

function TSshPublicKeyHash:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSshPublicKeyHash.group)
end

TSshPublicKeyHash.from_obj = TSshPublicKeyHash_from_obj

TSshPublicKeyHash.proto_property = {'SshPublicKeyHash'}

TSshPublicKeyHash.default = {''}

TSshPublicKeyHash.struct = {{name = 'SshPublicKeyHash', is_array = false, struct = nil}}

function TSshPublicKeyHash:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'SshPublicKeyHash', self.SshPublicKeyHash, 'string', true, errs, need_convert)

    TSshPublicKeyHash:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSshPublicKeyHash.proto_property, errs, need_convert)
    return self
end

function TSshPublicKeyHash:unpack(_)
    return self.SshPublicKeyHash
end

ManagerAccount.SshPublicKeyHash = TSshPublicKeyHash

---@class ManagerAccount.RoleId
---@field RoleId integer
local TRoleId = {}
TRoleId.__index = TRoleId
TRoleId.group = {}

local function TRoleId_from_obj(obj)
    return setmetatable(obj, TRoleId)
end

function TRoleId.new(RoleId)
    return TRoleId_from_obj({RoleId = RoleId})
end
---@param obj ManagerAccount.RoleId
function TRoleId:init_from_obj(obj)
    self.RoleId = obj.RoleId
end

function TRoleId:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TRoleId.group)
end

TRoleId.from_obj = TRoleId_from_obj

TRoleId.proto_property = {'RoleId'}

TRoleId.default = {0}

TRoleId.struct = {{name = 'RoleId', is_array = false, struct = nil}}

function TRoleId:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'RoleId', self.RoleId, 'uint8', false, errs, need_convert)

    TRoleId:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TRoleId.proto_property, errs, need_convert)
    return self
end

function TRoleId:unpack(_)
    return self.RoleId
end

ManagerAccount.RoleId = TRoleId

---@class ManagerAccount.PasswordExpiration
---@field PasswordExpiration integer
local TPasswordExpiration = {}
TPasswordExpiration.__index = TPasswordExpiration
TPasswordExpiration.group = {}

local function TPasswordExpiration_from_obj(obj)
    return setmetatable(obj, TPasswordExpiration)
end

function TPasswordExpiration.new(PasswordExpiration)
    return TPasswordExpiration_from_obj({PasswordExpiration = PasswordExpiration})
end
---@param obj ManagerAccount.PasswordExpiration
function TPasswordExpiration:init_from_obj(obj)
    self.PasswordExpiration = obj.PasswordExpiration
end

function TPasswordExpiration:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TPasswordExpiration.group)
end

TPasswordExpiration.from_obj = TPasswordExpiration_from_obj

TPasswordExpiration.proto_property = {'PasswordExpiration'}

TPasswordExpiration.default = {0}

TPasswordExpiration.struct = {{name = 'PasswordExpiration', is_array = false, struct = nil}}

function TPasswordExpiration:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'PasswordExpiration', self.PasswordExpiration, 'uint32', true, errs, need_convert)

    TPasswordExpiration:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TPasswordExpiration.proto_property, errs, need_convert)
    return self
end

function TPasswordExpiration:unpack(_)
    return self.PasswordExpiration
end

ManagerAccount.PasswordExpiration = TPasswordExpiration

---@class ManagerAccount.PasswordChangeRequired
---@field PasswordChangeRequired boolean
local TPasswordChangeRequired = {}
TPasswordChangeRequired.__index = TPasswordChangeRequired
TPasswordChangeRequired.group = {}

local function TPasswordChangeRequired_from_obj(obj)
    return setmetatable(obj, TPasswordChangeRequired)
end

function TPasswordChangeRequired.new(PasswordChangeRequired)
    return TPasswordChangeRequired_from_obj({
        PasswordChangeRequired = PasswordChangeRequired == nil and true or PasswordChangeRequired
    })
end
---@param obj ManagerAccount.PasswordChangeRequired
function TPasswordChangeRequired:init_from_obj(obj)
    self.PasswordChangeRequired = obj.PasswordChangeRequired == nil and true or obj.PasswordChangeRequired
end

function TPasswordChangeRequired:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TPasswordChangeRequired.group)
end

TPasswordChangeRequired.from_obj = TPasswordChangeRequired_from_obj

TPasswordChangeRequired.proto_property = {'PasswordChangeRequired'}

TPasswordChangeRequired.default = {false}

TPasswordChangeRequired.struct = {{name = 'PasswordChangeRequired', is_array = false, struct = nil}}

function TPasswordChangeRequired:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'PasswordChangeRequired', self.PasswordChangeRequired, 'bool', false, errs, need_convert)

    TPasswordChangeRequired:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TPasswordChangeRequired.proto_property, errs, need_convert)
    return self
end

function TPasswordChangeRequired:unpack(_)
    return self.PasswordChangeRequired
end

ManagerAccount.PasswordChangeRequired = TPasswordChangeRequired

---@class ManagerAccount.Deletable
---@field Deletable boolean
local TDeletable = {}
TDeletable.__index = TDeletable
TDeletable.group = {}

local function TDeletable_from_obj(obj)
    return setmetatable(obj, TDeletable)
end

function TDeletable.new(Deletable)
    return TDeletable_from_obj({Deletable = Deletable})
end
---@param obj ManagerAccount.Deletable
function TDeletable:init_from_obj(obj)
    self.Deletable = obj.Deletable
end

function TDeletable:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TDeletable.group)
end

TDeletable.from_obj = TDeletable_from_obj

TDeletable.proto_property = {'Deletable'}

TDeletable.default = {false}

TDeletable.struct = {{name = 'Deletable', is_array = false, struct = nil}}

function TDeletable:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'Deletable', self.Deletable, 'bool', true, errs, need_convert)

    TDeletable:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TDeletable.proto_property, errs, need_convert)
    return self
end

function TDeletable:unpack(_)
    return self.Deletable
end

ManagerAccount.Deletable = TDeletable

---@class ManagerAccount.UserName
---@field UserName string
local TUserName = {}
TUserName.__index = TUserName
TUserName.group = {}

local function TUserName_from_obj(obj)
    return setmetatable(obj, TUserName)
end

function TUserName.new(UserName)
    return TUserName_from_obj({UserName = UserName})
end
---@param obj ManagerAccount.UserName
function TUserName:init_from_obj(obj)
    self.UserName = obj.UserName
end

function TUserName:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TUserName.group)
end

TUserName.from_obj = TUserName_from_obj

TUserName.proto_property = {'UserName'}

TUserName.default = {''}

TUserName.struct = {{name = 'UserName', is_array = false, struct = nil}}

function TUserName:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'UserName', self.UserName, 'string', false, errs, need_convert)

    TUserName:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TUserName.proto_property, errs, need_convert)
    return self
end

function TUserName:unpack(_)
    return self.UserName
end

ManagerAccount.UserName = TUserName

---@class ManagerAccount.Locked
---@field Locked boolean
local TLocked = {}
TLocked.__index = TLocked
TLocked.group = {}

local function TLocked_from_obj(obj)
    return setmetatable(obj, TLocked)
end

function TLocked.new(Locked)
    return TLocked_from_obj({Locked = Locked})
end
---@param obj ManagerAccount.Locked
function TLocked:init_from_obj(obj)
    self.Locked = obj.Locked
end

function TLocked:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TLocked.group)
end

TLocked.from_obj = TLocked_from_obj

TLocked.proto_property = {'Locked'}

TLocked.default = {false}

TLocked.struct = {{name = 'Locked', is_array = false, struct = nil}}

function TLocked:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'Locked', self.Locked, 'bool', true, errs, need_convert)

    TLocked:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TLocked.proto_property, errs, need_convert)
    return self
end

function TLocked:unpack(_)
    return self.Locked
end

ManagerAccount.Locked = TLocked

---@class ManagerAccount.Id
---@field Id integer
local TId = {}
TId.__index = TId
TId.group = {}

local function TId_from_obj(obj)
    return setmetatable(obj, TId)
end

function TId.new(Id)
    return TId_from_obj({Id = Id})
end
---@param obj ManagerAccount.Id
function TId:init_from_obj(obj)
    self.Id = obj.Id
end

function TId:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TId.group)
end

TId.from_obj = TId_from_obj

TId.proto_property = {'Id'}

TId.default = {0}

TId.struct = {{name = 'Id', is_array = false, struct = nil}}

function TId:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'Id', self.Id, 'uint8', true, errs, need_convert)

    TId:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TId.proto_property, errs, need_convert)
    return self
end

function TId:unpack(_)
    return self.Id
end

ManagerAccount.Id = TId

---@class ManagerAccount.Enabled
---@field Enabled boolean
local TEnabled = {}
TEnabled.__index = TEnabled
TEnabled.group = {}

local function TEnabled_from_obj(obj)
    return setmetatable(obj, TEnabled)
end

function TEnabled.new(Enabled)
    return TEnabled_from_obj({Enabled = Enabled})
end
---@param obj ManagerAccount.Enabled
function TEnabled:init_from_obj(obj)
    self.Enabled = obj.Enabled
end

function TEnabled:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TEnabled.group)
end

TEnabled.from_obj = TEnabled_from_obj

TEnabled.proto_property = {'Enabled'}

TEnabled.default = {false}

TEnabled.struct = {{name = 'Enabled', is_array = false, struct = nil}}

function TEnabled:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'Enabled', self.Enabled, 'bool', false, errs, need_convert)

    TEnabled:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TEnabled.proto_property, errs, need_convert)
    return self
end

function TEnabled:unpack(_)
    return self.Enabled
end

ManagerAccount.Enabled = TEnabled

---@class ManagerAccount.Certificates
---@field Certificates integer
local TCertificates = {}
TCertificates.__index = TCertificates
TCertificates.group = {}

local function TCertificates_from_obj(obj)
    return setmetatable(obj, TCertificates)
end

function TCertificates.new(Certificates)
    return TCertificates_from_obj({Certificates = Certificates})
end
---@param obj ManagerAccount.Certificates
function TCertificates:init_from_obj(obj)
    self.Certificates = obj.Certificates
end

function TCertificates:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TCertificates.group)
end

TCertificates.from_obj = TCertificates_from_obj

TCertificates.proto_property = {'Certificates'}

TCertificates.default = {0}

TCertificates.struct = {{name = 'Certificates', is_array = false, struct = nil}}

function TCertificates:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'Certificates', self.Certificates, 'uint16', true, errs, need_convert)

    TCertificates:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TCertificates.proto_property, errs, need_convert)
    return self
end

function TCertificates:unpack(_)
    return self.Certificates
end

ManagerAccount.Certificates = TCertificates

---@class ManagerAccount.AccountExpiration
---@field AccountExpiration string
local TAccountExpiration = {}
TAccountExpiration.__index = TAccountExpiration
TAccountExpiration.group = {}

local function TAccountExpiration_from_obj(obj)
    return setmetatable(obj, TAccountExpiration)
end

function TAccountExpiration.new(AccountExpiration)
    return TAccountExpiration_from_obj({AccountExpiration = AccountExpiration})
end
---@param obj ManagerAccount.AccountExpiration
function TAccountExpiration:init_from_obj(obj)
    self.AccountExpiration = obj.AccountExpiration
end

function TAccountExpiration:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TAccountExpiration.group)
end

TAccountExpiration.from_obj = TAccountExpiration_from_obj

TAccountExpiration.proto_property = {'AccountExpiration'}

TAccountExpiration.default = {''}

TAccountExpiration.struct = {{name = 'AccountExpiration', is_array = false, struct = nil}}

function TAccountExpiration:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'AccountExpiration', self.AccountExpiration, 'string', true, errs, need_convert)

    TAccountExpiration:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TAccountExpiration.proto_property, errs, need_convert)
    return self
end

function TAccountExpiration:unpack(_)
    return self.AccountExpiration
end

ManagerAccount.AccountExpiration = TAccountExpiration

---@class ManagerAccount.SetLastLoginRsp
---@field Result integer
local TSetLastLoginRsp = {}
TSetLastLoginRsp.__index = TSetLastLoginRsp
TSetLastLoginRsp.group = {}

local function TSetLastLoginRsp_from_obj(obj)
    return setmetatable(obj, TSetLastLoginRsp)
end

function TSetLastLoginRsp.new(Result)
    return TSetLastLoginRsp_from_obj({Result = Result})
end
---@param obj ManagerAccount.SetLastLoginRsp
function TSetLastLoginRsp:init_from_obj(obj)
    self.Result = obj.Result
end

function TSetLastLoginRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSetLastLoginRsp.group)
end

TSetLastLoginRsp.from_obj = TSetLastLoginRsp_from_obj

TSetLastLoginRsp.proto_property = {'Result'}

TSetLastLoginRsp.default = {0}

TSetLastLoginRsp.struct = {{name = 'Result', is_array = false, struct = nil}}

function TSetLastLoginRsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'Result', self.Result, 'uint8', false, errs, need_convert)

    TSetLastLoginRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSetLastLoginRsp.proto_property, errs, need_convert)
    return self
end

function TSetLastLoginRsp:unpack(_)
    return self.Result
end

ManagerAccount.SetLastLoginRsp = TSetLastLoginRsp

---@class ManagerAccount.SetLastLoginReq
---@field Ip string
---@field Interface string
local TSetLastLoginReq = {}
TSetLastLoginReq.__index = TSetLastLoginReq
TSetLastLoginReq.group = {}

local function TSetLastLoginReq_from_obj(obj)
    return setmetatable(obj, TSetLastLoginReq)
end

function TSetLastLoginReq.new(Ip, Interface)
    return TSetLastLoginReq_from_obj({Ip = Ip, Interface = Interface})
end
---@param obj ManagerAccount.SetLastLoginReq
function TSetLastLoginReq:init_from_obj(obj)
    self.Ip = obj.Ip
    self.Interface = obj.Interface
end

function TSetLastLoginReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSetLastLoginReq.group)
end

TSetLastLoginReq.from_obj = TSetLastLoginReq_from_obj

TSetLastLoginReq.proto_property = {'Ip', 'Interface'}

TSetLastLoginReq.default = {'', ''}

TSetLastLoginReq.struct = {
    {name = 'Ip', is_array = false, struct = nil}, {name = 'Interface', is_array = false, struct = nil}
}

function TSetLastLoginReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'Ip', self.Ip, 'string', false, errs, need_convert)
    validate.Optional(prefix .. 'Interface', self.Interface, 'string', false, errs, need_convert)

    TSetLastLoginReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSetLastLoginReq.proto_property, errs, need_convert)
    return self
end

function TSetLastLoginReq:unpack(_)
    return self.Ip, self.Interface
end

ManagerAccount.SetLastLoginReq = TSetLastLoginReq

---@class ManagerAccount.DeleteSSHPublicKeyRsp
local TDeleteSSHPublicKeyRsp = {}
TDeleteSSHPublicKeyRsp.__index = TDeleteSSHPublicKeyRsp
TDeleteSSHPublicKeyRsp.group = {}

local function TDeleteSSHPublicKeyRsp_from_obj(obj)
    return setmetatable(obj, TDeleteSSHPublicKeyRsp)
end

function TDeleteSSHPublicKeyRsp.new()
    return TDeleteSSHPublicKeyRsp_from_obj({})
end
---@param obj ManagerAccount.DeleteSSHPublicKeyRsp
function TDeleteSSHPublicKeyRsp:init_from_obj(obj)

end

function TDeleteSSHPublicKeyRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TDeleteSSHPublicKeyRsp.group)
end

TDeleteSSHPublicKeyRsp.from_obj = TDeleteSSHPublicKeyRsp_from_obj

TDeleteSSHPublicKeyRsp.proto_property = {}

TDeleteSSHPublicKeyRsp.default = {}

TDeleteSSHPublicKeyRsp.struct = {}

function TDeleteSSHPublicKeyRsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    TDeleteSSHPublicKeyRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TDeleteSSHPublicKeyRsp.proto_property, errs, need_convert)
    return self
end

function TDeleteSSHPublicKeyRsp:unpack(_)
end

ManagerAccount.DeleteSSHPublicKeyRsp = TDeleteSSHPublicKeyRsp

---@class ManagerAccount.DeleteSSHPublicKeyReq
local TDeleteSSHPublicKeyReq = {}
TDeleteSSHPublicKeyReq.__index = TDeleteSSHPublicKeyReq
TDeleteSSHPublicKeyReq.group = {}

local function TDeleteSSHPublicKeyReq_from_obj(obj)
    return setmetatable(obj, TDeleteSSHPublicKeyReq)
end

function TDeleteSSHPublicKeyReq.new()
    return TDeleteSSHPublicKeyReq_from_obj({})
end
---@param obj ManagerAccount.DeleteSSHPublicKeyReq
function TDeleteSSHPublicKeyReq:init_from_obj(obj)

end

function TDeleteSSHPublicKeyReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TDeleteSSHPublicKeyReq.group)
end

TDeleteSSHPublicKeyReq.from_obj = TDeleteSSHPublicKeyReq_from_obj

TDeleteSSHPublicKeyReq.proto_property = {}

TDeleteSSHPublicKeyReq.default = {}

TDeleteSSHPublicKeyReq.struct = {}

function TDeleteSSHPublicKeyReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    TDeleteSSHPublicKeyReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TDeleteSSHPublicKeyReq.proto_property, errs, need_convert)
    return self
end

function TDeleteSSHPublicKeyReq:unpack(_)
end

ManagerAccount.DeleteSSHPublicKeyReq = TDeleteSSHPublicKeyReq

---@class ManagerAccount.ImportSSHPublicKeyRsp
---@field TaskId integer
local TImportSSHPublicKeyRsp = {}
TImportSSHPublicKeyRsp.__index = TImportSSHPublicKeyRsp
TImportSSHPublicKeyRsp.group = {}

local function TImportSSHPublicKeyRsp_from_obj(obj)
    return setmetatable(obj, TImportSSHPublicKeyRsp)
end

function TImportSSHPublicKeyRsp.new(TaskId)
    return TImportSSHPublicKeyRsp_from_obj({TaskId = TaskId})
end
---@param obj ManagerAccount.ImportSSHPublicKeyRsp
function TImportSSHPublicKeyRsp:init_from_obj(obj)
    self.TaskId = obj.TaskId
end

function TImportSSHPublicKeyRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TImportSSHPublicKeyRsp.group)
end

TImportSSHPublicKeyRsp.from_obj = TImportSSHPublicKeyRsp_from_obj

TImportSSHPublicKeyRsp.proto_property = {'TaskId'}

TImportSSHPublicKeyRsp.default = {0}

TImportSSHPublicKeyRsp.struct = {{name = 'TaskId', is_array = false, struct = nil}}

function TImportSSHPublicKeyRsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'TaskId', self.TaskId, 'uint32', false, errs, need_convert)

    TImportSSHPublicKeyRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TImportSSHPublicKeyRsp.proto_property, errs, need_convert)
    return self
end

function TImportSSHPublicKeyRsp:unpack(_)
    return self.TaskId
end

ManagerAccount.ImportSSHPublicKeyRsp = TImportSSHPublicKeyRsp

---@class ManagerAccount.ImportSSHPublicKeyReq
---@field Type string
---@field Content string
local TImportSSHPublicKeyReq = {}
TImportSSHPublicKeyReq.__index = TImportSSHPublicKeyReq
TImportSSHPublicKeyReq.group = {}

local function TImportSSHPublicKeyReq_from_obj(obj)
    return setmetatable(obj, TImportSSHPublicKeyReq)
end

function TImportSSHPublicKeyReq.new(Type, Content)
    return TImportSSHPublicKeyReq_from_obj({Type = Type, Content = Content})
end
---@param obj ManagerAccount.ImportSSHPublicKeyReq
function TImportSSHPublicKeyReq:init_from_obj(obj)
    self.Type = obj.Type
    self.Content = obj.Content
end

function TImportSSHPublicKeyReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TImportSSHPublicKeyReq.group)
end

TImportSSHPublicKeyReq.from_obj = TImportSSHPublicKeyReq_from_obj

TImportSSHPublicKeyReq.proto_property = {'Type', 'Content'}

TImportSSHPublicKeyReq.default = {'', ''}

TImportSSHPublicKeyReq.struct = {
    {name = 'Type', is_array = false, struct = nil}, {name = 'Content', is_array = false, struct = nil}
}

function TImportSSHPublicKeyReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'Type', self.Type, 'string', false, errs, need_convert)
    validate.Optional(prefix .. 'Content', self.Content, 'string', false, errs, need_convert)

    TImportSSHPublicKeyReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TImportSSHPublicKeyReq.proto_property, errs, need_convert)
    return self
end

function TImportSSHPublicKeyReq:unpack(_)
    return self.Type, self.Content
end

ManagerAccount.ImportSSHPublicKeyReq = TImportSSHPublicKeyReq

---@class ManagerAccount.ChangeSnmpPwdRsp
local TChangeSnmpPwdRsp = {}
TChangeSnmpPwdRsp.__index = TChangeSnmpPwdRsp
TChangeSnmpPwdRsp.group = {}

local function TChangeSnmpPwdRsp_from_obj(obj)
    return setmetatable(obj, TChangeSnmpPwdRsp)
end

function TChangeSnmpPwdRsp.new()
    return TChangeSnmpPwdRsp_from_obj({})
end
---@param obj ManagerAccount.ChangeSnmpPwdRsp
function TChangeSnmpPwdRsp:init_from_obj(obj)

end

function TChangeSnmpPwdRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TChangeSnmpPwdRsp.group)
end

TChangeSnmpPwdRsp.from_obj = TChangeSnmpPwdRsp_from_obj

TChangeSnmpPwdRsp.proto_property = {}

TChangeSnmpPwdRsp.default = {}

TChangeSnmpPwdRsp.struct = {}

function TChangeSnmpPwdRsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    TChangeSnmpPwdRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TChangeSnmpPwdRsp.proto_property, errs, need_convert)
    return self
end

function TChangeSnmpPwdRsp:unpack(_)
end

ManagerAccount.ChangeSnmpPwdRsp = TChangeSnmpPwdRsp

---@class ManagerAccount.ChangeSnmpPwdReq
---@field Password integer[]
local TChangeSnmpPwdReq = {}
TChangeSnmpPwdReq.__index = TChangeSnmpPwdReq
TChangeSnmpPwdReq.group = {}

local function TChangeSnmpPwdReq_from_obj(obj)
    return setmetatable(obj, TChangeSnmpPwdReq)
end

function TChangeSnmpPwdReq.new(Password)
    return TChangeSnmpPwdReq_from_obj({Password = Password})
end
---@param obj ManagerAccount.ChangeSnmpPwdReq
function TChangeSnmpPwdReq:init_from_obj(obj)
    self.Password = obj.Password
end

function TChangeSnmpPwdReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TChangeSnmpPwdReq.group)
end

TChangeSnmpPwdReq.from_obj = TChangeSnmpPwdReq_from_obj

TChangeSnmpPwdReq.proto_property = {'Password'}

TChangeSnmpPwdReq.default = {{}}

TChangeSnmpPwdReq.struct = {{name = 'Password', is_array = true, struct = nil}}

function TChangeSnmpPwdReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.OptionalArray(prefix .. 'Password', self.Password, 'uint8', false, errs, need_convert)

    if self.Password ~= nil then
        validate.lens(prefix .. 'Password', self.Password, 1, 32, errs, need_convert)
    end

    TChangeSnmpPwdReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TChangeSnmpPwdReq.proto_property, errs, need_convert)
    return self
end

function TChangeSnmpPwdReq:unpack(_)
    return self.Password
end

ManagerAccount.ChangeSnmpPwdReq = TChangeSnmpPwdReq

---@class ManagerAccount.ChangePwdRsp
local TChangePwdRsp = {}
TChangePwdRsp.__index = TChangePwdRsp
TChangePwdRsp.group = {}

local function TChangePwdRsp_from_obj(obj)
    return setmetatable(obj, TChangePwdRsp)
end

function TChangePwdRsp.new()
    return TChangePwdRsp_from_obj({})
end
---@param obj ManagerAccount.ChangePwdRsp
function TChangePwdRsp:init_from_obj(obj)

end

function TChangePwdRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TChangePwdRsp.group)
end

TChangePwdRsp.from_obj = TChangePwdRsp_from_obj

TChangePwdRsp.proto_property = {}

TChangePwdRsp.default = {}

TChangePwdRsp.struct = {}

function TChangePwdRsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    TChangePwdRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TChangePwdRsp.proto_property, errs, need_convert)
    return self
end

function TChangePwdRsp:unpack(_)
end

ManagerAccount.ChangePwdRsp = TChangePwdRsp

---@class ManagerAccount.ChangePwdReq
---@field Password integer[]
local TChangePwdReq = {}
TChangePwdReq.__index = TChangePwdReq
TChangePwdReq.group = {}

local function TChangePwdReq_from_obj(obj)
    return setmetatable(obj, TChangePwdReq)
end

function TChangePwdReq.new(Password)
    return TChangePwdReq_from_obj({Password = Password})
end
---@param obj ManagerAccount.ChangePwdReq
function TChangePwdReq:init_from_obj(obj)
    self.Password = obj.Password
end

function TChangePwdReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TChangePwdReq.group)
end

TChangePwdReq.from_obj = TChangePwdReq_from_obj

TChangePwdReq.proto_property = {'Password'}

TChangePwdReq.default = {{}}

TChangePwdReq.struct = {{name = 'Password', is_array = true, struct = nil}}

function TChangePwdReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.OptionalArray(prefix .. 'Password', self.Password, 'uint8', false, errs, need_convert)

    if self.Password ~= nil then
        validate.lens(prefix .. 'Password', self.Password, 1, 32, errs, need_convert)
    end

    TChangePwdReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TChangePwdReq.proto_property, errs, need_convert)
    return self
end

function TChangePwdReq:unpack(_)
    return self.Password
end

ManagerAccount.ChangePwdReq = TChangePwdReq

---@class ManagerAccount.DeleteRsp
local TDeleteRsp = {}
TDeleteRsp.__index = TDeleteRsp
TDeleteRsp.group = {}

local function TDeleteRsp_from_obj(obj)
    return setmetatable(obj, TDeleteRsp)
end

function TDeleteRsp.new()
    return TDeleteRsp_from_obj({})
end
---@param obj ManagerAccount.DeleteRsp
function TDeleteRsp:init_from_obj(obj)

end

function TDeleteRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TDeleteRsp.group)
end

TDeleteRsp.from_obj = TDeleteRsp_from_obj

TDeleteRsp.proto_property = {}

TDeleteRsp.default = {}

TDeleteRsp.struct = {}

function TDeleteRsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    TDeleteRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TDeleteRsp.proto_property, errs, need_convert)
    return self
end

function TDeleteRsp:unpack(_)
end

ManagerAccount.DeleteRsp = TDeleteRsp

---@class ManagerAccount.DeleteReq
local TDeleteReq = {}
TDeleteReq.__index = TDeleteReq
TDeleteReq.group = {}

local function TDeleteReq_from_obj(obj)
    return setmetatable(obj, TDeleteReq)
end

function TDeleteReq.new()
    return TDeleteReq_from_obj({})
end
---@param obj ManagerAccount.DeleteReq
function TDeleteReq:init_from_obj(obj)

end

function TDeleteReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TDeleteReq.group)
end

TDeleteReq.from_obj = TDeleteReq_from_obj

TDeleteReq.proto_property = {}

TDeleteReq.default = {}

TDeleteReq.struct = {}

function TDeleteReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    TDeleteReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TDeleteReq.proto_property, errs, need_convert)
    return self
end

function TDeleteReq:unpack(_)
end

ManagerAccount.DeleteReq = TDeleteReq

ManagerAccount.interface = mdb.register_interface('bmc.kepler.AccountService.ManagerAccount', {
    AccountExpiration = {'s', nil, true, nil, false},
    Certificates = {'q', nil, true, nil, false},
    Enabled = {'b', nil, false, nil, false},
    Id = {'y', nil, true, nil, false},
    Locked = {'b', nil, true, nil, false},
    UserName = {'s', nil, false, nil, false},
    Deletable = {'b', nil, true, nil, false},
    PasswordChangeRequired = {'b', nil, false, true, false},
    PasswordExpiration = {'u', nil, true, nil, false},
    RoleId = {'y', nil, false, nil, false},
    SshPublicKeyHash = {'s', nil, true, nil, false},
    AccountType = {'s', nil, true, nil, false},
    LoginRuleIds = {'as', nil, false, nil, false},
    LastLoginTime = {'u', nil, true, nil, false},
    LastLoginIP = {'s', nil, true, nil, false},
    LastLoginInterface = {'s', nil, true, nil, false},
    FirstLoginPolicy = {'y', nil, false, 2, false},
    Privileges = {'as', nil, true, nil, false},
    LoginInterface = {'as', nil, false, nil, false}
}, {
    Delete = {'a{ss}', '', TDeleteReq, TDeleteRsp},
    ChangePwd = {'a{ss}ay', '', TChangePwdReq, TChangePwdRsp},
    ChangeSnmpPwd = {'a{ss}ay', '', TChangeSnmpPwdReq, TChangeSnmpPwdRsp},
    ImportSSHPublicKey = {'a{ss}ss', 'u', TImportSSHPublicKeyReq, TImportSSHPublicKeyRsp},
    DeleteSSHPublicKey = {'a{ss}', '', TDeleteSSHPublicKeyReq, TDeleteSSHPublicKeyRsp},
    SetLastLogin = {'a{ss}ss', 'y', TSetLastLoginReq, TSetLastLoginRsp}
}, {})

return ManagerAccount
