-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
local validate = require 'mc.validate'
local utils = require 'mc.utils'
local mdb = require 'mc.mdb'

local CertificateAuthentication = {}

---@class CertificateAuthentication.OCSPEnabled
---@field OCSPEnabled boolean
local TOCSPEnabled = {}
TOCSPEnabled.__index = TOCSPEnabled
TOCSPEnabled.group = {}

local function TOCSPEnabled_from_obj(obj)
    return setmetatable(obj, TOCSPEnabled)
end

function TOCSPEnabled.new(OCSPEnabled)
    return TOCSPEnabled_from_obj({OCSPEnabled = OCSPEnabled or false})
end
---@param obj CertificateAuthentication.OCSPEnabled
function TOCSPEnabled:init_from_obj(obj)
    self.OCSPEnabled = obj.OCSPEnabled or false
end

function TOCSPEnabled:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TOCSPEnabled.group)
end

TOCSPEnabled.from_obj = TOCSPEnabled_from_obj

TOCSPEnabled.proto_property = {'OCSPEnabled'}

TOCSPEnabled.default = {false}

TOCSPEnabled.struct = {{name = 'OCSPEnabled', is_array = false, struct = nil}}

function TOCSPEnabled:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'OCSPEnabled', self.OCSPEnabled, 'bool', false, errs, need_convert)

    TOCSPEnabled:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TOCSPEnabled.proto_property, errs, need_convert)
    return self
end

function TOCSPEnabled:unpack(_)
    return self.OCSPEnabled
end

CertificateAuthentication.OCSPEnabled = TOCSPEnabled

---@class CertificateAuthentication.Enabled
---@field Enabled boolean
local TEnabled = {}
TEnabled.__index = TEnabled
TEnabled.group = {}

local function TEnabled_from_obj(obj)
    return setmetatable(obj, TEnabled)
end

function TEnabled.new(Enabled)
    return TEnabled_from_obj({Enabled = Enabled or false})
end
---@param obj CertificateAuthentication.Enabled
function TEnabled:init_from_obj(obj)
    self.Enabled = obj.Enabled or false
end

function TEnabled:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TEnabled.group)
end

TEnabled.from_obj = TEnabled_from_obj

TEnabled.proto_property = {'Enabled'}

TEnabled.default = {false}

TEnabled.struct = {{name = 'Enabled', is_array = false, struct = nil}}

function TEnabled:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'Enabled', self.Enabled, 'bool', false, errs, need_convert)

    TEnabled:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TEnabled.proto_property, errs, need_convert)
    return self
end

function TEnabled:unpack(_)
    return self.Enabled
end

CertificateAuthentication.Enabled = TEnabled

CertificateAuthentication.interface = mdb.register_interface('bmc.kepler.AccountService.CertificateAuthentication', {
    Enabled = {'b', nil, false, false, false},
    OCSPEnabled = {'b', nil, false, false, false}
}, {}, {})

return CertificateAuthentication
