-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
local validate = require 'mc.validate'
local utils = require 'mc.utils'
local mdb = require 'mc.mdb'

local CA = {}

---@class CA.Privilege
---@field Privilege integer
local TPrivilege = {}
TPrivilege.__index = TPrivilege
TPrivilege.group = {}

local function TPrivilege_from_obj(obj)
    return setmetatable(obj, TPrivilege)
end

function TPrivilege.new(Privilege)
    return TPrivilege_from_obj({Privilege = Privilege or 1})
end
---@param obj CA.Privilege
function TPrivilege:init_from_obj(obj)
    self.Privilege = obj.Privilege or 1
end

function TPrivilege:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TPrivilege.group)
end

TPrivilege.from_obj = TPrivilege_from_obj

TPrivilege.proto_property = {'Privilege'}

TPrivilege.default = {0}

TPrivilege.struct = {{name = 'Privilege', is_array = false, struct = nil}}

function TPrivilege:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'Privilege', self.Privilege, 'uint32', false, errs, need_convert)

    TPrivilege:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TPrivilege.proto_property, errs, need_convert)
    return self
end

function TPrivilege:unpack(_)
    return self.Privilege
end

CA.Privilege = TPrivilege

CA.interface = mdb.register_interface('bmc.kepler.CertificateService.CA', {Privilege = {'u', nil, false, 1, false}}, {},
    {})

return CA
