--[[-- Copyright (c) Huawei Technologies Co., Ltd. 2024. All rights reserved.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
]] --
local bs = require 'mc.bitstring'
local enums = require 'ipmi.enums'
local ipmi = require 'ipmi'
local types = require 'ipmi.types'
local privilege = require 'mc.privilege'
local msg = require 'iam.ipmi.ipmi_message'

local CT = enums.ChannelType

local iamIpmiCmds = {}

iamIpmiCmds.TestUserPassword = {
    name = 'TestUserPassword',
    prio = types.Priority.Default,
    netfn = 0x06,
    cmd = 0x47,
    role = types.Role.User,
    privilege = privilege.ConfigureSelf,
    sensitive = true,
    restricted_channels = {},
    filters = [=[*,03]=],
    decode = [=[<<UserId:6/unit:1, Reserved1:1/unit:1, PasswordSiz]=] ..
        [=[e:1/unit:1, 0x03:2/unit:1, Reserved2:6/unit:1, Pas]=] .. [=[swordData/string>>]=],
    encode = [=[<<CompletionCode:1/unit:8>>]=],
    req = msg.TestUserPasswordReq,
    rsp = msg.TestUserPasswordRsp,
    manufacturer = {-1, -1},
    sysLockedPolicy = 'Forbidden'
}

iamIpmiCmds.UserAuthentication = {
    name = 'UserAuthentication',
    prio = types.Priority.Default,
    netfn = 0x30,
    cmd = 0x91,
    role = types.Role.Administrator,
    privilege = privilege.UserMgmt,
    sensitive = true,
    restricted_channels = {},
    filters = [=[*,*,*,11]=],
    decode = [=[<<ManufactureId:3/unit:8, 0x11:1/unit:8, LoginType]=] ..
        [=[:7/unit:1, UnlockFlag:1/unit:1, UserName:16/string]=] .. [=[, PasswordData:20/string>>]=],
    encode = [=[<<CompletionCode:1/unit:8, ManufactureId:3/unit:8,]=] ..
        [=[ UserPrivilege:1/unit:8, PrivilegeMaskReserved:4/u]=] .. [=[nit:8>>]=],
    req = msg.UserAuthenticationReq,
    rsp = msg.UserAuthenticationRsp,
    manufacturer = {0, 1},
    sysLockedPolicy = 'Allowed'
}

iamIpmiCmds.SetTwoFactorAuthState = {
    name = 'SetTwoFactorAuthState',
    prio = types.Priority.Default,
    netfn = 0x30,
    cmd = 0x92,
    role = types.Role.Administrator,
    privilege = privilege.SecurityMgmt,
    sensitive = false,
    restricted_channels = {},
    filters = [=[*,*,*,52]=],
    decode = [=[<<ManufactureId:3/unit:8, 0x52:1/unit:8, Enabled:1]=] .. [=[/unit:8, OCSPEnabled:1/unit:8>>]=],
    encode = [=[<<CompletionCode:1/unit:8, ManufactureId:3/unit:8>]=] .. [=[>]=],
    req = msg.SetTwoFactorAuthStateReq,
    rsp = msg.SetTwoFactorAuthStateRsp,
    manufacturer = {0, 1},
    sysLockedPolicy = 'Forbidden'
}

iamIpmiCmds.GetTwoFactorAuthState = {
    name = 'GetTwoFactorAuthState',
    prio = types.Priority.Default,
    netfn = 0x30,
    cmd = 0x92,
    role = types.Role.Administrator,
    privilege = privilege.SecurityMgmt,
    sensitive = false,
    restricted_channels = {},
    filters = [=[*,*,*,51]=],
    decode = [=[<<ManufactureId:3/unit:8, 0x51:1/unit:8>>]=],
    encode = [=[<<CompletionCode:1/unit:8, ManufactureId:3/unit:8,]=] .. [=[ Enabled:1/unit:8, OCSPEnabled:1/unit:8>>]=],
    req = msg.GetTwoFactorAuthStateReq,
    rsp = msg.GetTwoFactorAuthStateRsp,
    manufacturer = {0, 1},
    sysLockedPolicy = 'Allowed'
}

iamIpmiCmds.IpmiGetAuthToken = {
    name = 'IpmiGetAuthToken',
    prio = types.Priority.Default,
    netfn = 0x30,
    cmd = 0x94,
    role = types.Role.User,
    privilege = privilege.ReadOnly,
    sensitive = true,
    restricted_channels = {},
    filters = [=[*,*,*,39]=],
    decode = [=[<<ManufactureId:3/unit:8, 0x39:1/unit:8, RoleId:1/]=] ..
        [=[unit:8, SessionType:1/unit:8, UserType:2/unit:1, R]=] ..
        [=[eserved:6/unit:1, IpMode:1/unit:8, IpAddress:16/st]=] ..
        [=[ring, NotEndFlag:1/unit:1, Reserved1:7/unit:1, Off]=] .. [=[set:1/unit:8, Length:1/unit:8, Data/string>>]=],
    encode = [=[<<CompletionCode:1/unit:8, ManufactureId:3/unit:8,]=] .. [=[ Token:64/string, End:1/unit:8>>]=],
    req = msg.IpmiGetAuthTokenReq,
    rsp = msg.IpmiGetAuthTokenRsp,
    manufacturer = {0, 1},
    sysLockedPolicy = 'Allowed'
}

iamIpmiCmds.GetWebTimeOut = {
    name = 'GetWebTimeOut',
    prio = types.Priority.Default,
    netfn = 0x30,
    cmd = 0x93,
    role = types.Role.Administrator,
    privilege = privilege.UserMgmt,
    sensitive = false,
    restricted_channels = {},
    filters = [=[*,*,*,76,04]=],
    decode = [=[<<ManufactureId:3/unit:8, 0x76:1/unit:8, 0x04:1/un]=] ..
        [=[it:8, UserId:6/unit:1, Reserved1:2/unit:1>>]=],
    encode = [=[<<CompletionCode:1/unit:8, ManufactureId:3/unit:8,]=] .. [=[ Length:1/unit:8, Data/string>>]=],
    req = msg.GetWebTimeOutReq,
    rsp = msg.GetWebTimeOutRsp,
    manufacturer = {0, 1},
    sysLockedPolicy = 'Allowed'
}

iamIpmiCmds.SetWebTimeOut = {
    name = 'SetWebTimeOut',
    prio = types.Priority.Default,
    netfn = 0x30,
    cmd = 0x93,
    role = types.Role.Administrator,
    privilege = privilege.UserMgmt,
    sensitive = false,
    restricted_channels = {},
    filters = [=[*,*,*,77,04]=],
    decode = [=[<<ManufactureId:3/unit:8, 0x77:1/unit:8, 0x04:1/un]=] ..
        [=[it:8, UserId:6/unit:1, Reserved1:2/unit:1, Reserve]=] .. [=[d2:1/unit:8, Length:1/unit:8, Data/string>>]=],
    encode = [=[<<CompletionCode:1/unit:8, ManufactureId:3/unit:8>]=] .. [=[>]=],
    req = msg.SetWebTimeOutReq,
    rsp = msg.SetWebTimeOutRsp,
    manufacturer = {0, 1},
    sysLockedPolicy = 'Forbidden'
}

iamIpmiCmds.SetKvmKey = {
    name = 'SetKvmKey',
    prio = types.Priority.Default,
    netfn = 0x30,
    cmd = 0x94,
    role = types.Role.User,
    privilege = privilege.KVMMgmt,
    sensitive = true,
    restricted_channels = {},
    filters = [=[*,*,*,21,06]=],
    decode = [=[<<ManufactureId:3/unit:8, 0x21:1/unit:8, 0x06:1/un]=] ..
        [=[it:8, Reserved1:1/unit:8, Offset:1/unit:8, Length:]=] ..
        [=[1/unit:8, Reserved2:2/unit:8, KeyId:4/unit:8, Secr]=] ..
        [=[etKey:32/string, UserName:16/string, SessionMode:1]=] .. [=[/unit:8>>]=],
    encode = [=[<<CompletionCode:1/unit:8, ManufactureId:3/unit:8>]=] .. [=[>]=],
    req = msg.SetKvmKeyReq,
    rsp = msg.SetKvmKeyRsp,
    manufacturer = {0, 1},
    sysLockedPolicy = 'Forbidden'
}

iamIpmiCmds.SetLdapHostAddr = {
    name = 'SetLdapHostAddr',
    prio = types.Priority.Default,
    netfn = 0x30,
    cmd = 0x93,
    role = types.Role.Administrator,
    privilege = privilege.UserMgmt,
    sensitive = false,
    restricted_channels = {},
    filters = [=[*,*,*,05,02]=],
    decode = [=[<<ManufactureId:3/unit:8, 0x05:1/unit:8, 0x02:1/un]=] ..
        [=[it:8, Flag:1/unit:1, Reserved:7/unit:1, Offset:1/u]=] .. [=[nit:8, Length:1/unit:8, Data/string>>]=],
    encode = [=[<<CompletionCode:1/unit:8, ManufactureId:3/unit:8>]=] .. [=[>]=],
    req = msg.SetLdapHostAddrReq,
    rsp = msg.SetLdapHostAddrRsp,
    manufacturer = {0, 1},
    sysLockedPolicy = 'Forbidden'
}

iamIpmiCmds.GetLdapHostAddr = {
    name = 'GetLdapHostAddr',
    prio = types.Priority.Default,
    netfn = 0x30,
    cmd = 0x93,
    role = types.Role.User,
    privilege = privilege.ReadOnly,
    sensitive = false,
    restricted_channels = {},
    filters = [=[*,*,*,06,02]=],
    decode = [=[<<ManufactureId:3/unit:8, 0x06:1/unit:8, 0x02:1/un]=] .. [=[it:8, Offset:1/unit:8, Length:1/unit:8>>]=],
    encode = [=[<<CompletionCode:1/unit:8, ManufactureId:3/unit:8,]=] ..
        [=[ EndOfList:1/unit:1, Reserved:7/unit:1, Data/strin]=] .. [=[g>>]=],
    req = msg.GetLdapHostAddrReq,
    rsp = msg.GetLdapHostAddrRsp,
    manufacturer = {0, 1},
    sysLockedPolicy = 'Allowed'
}

iamIpmiCmds.SetLdapDomain = {
    name = 'SetLdapDomain',
    prio = types.Priority.Default,
    netfn = 0x30,
    cmd = 0x93,
    role = types.Role.Administrator,
    privilege = privilege.UserMgmt,
    sensitive = false,
    restricted_channels = {},
    filters = [=[*,*,*,05,05]=],
    decode = [=[<<ManufactureId:3/unit:8, 0x05:1/unit:8, 0x05:1/un]=] ..
        [=[it:8, Flag:1/unit:1, Reserved:7/unit:1, Offset:1/u]=] .. [=[nit:8, Length:1/unit:8, Data/string>>]=],
    encode = [=[<<CompletionCode:1/unit:8, ManufactureId:3/unit:8>]=] .. [=[>]=],
    req = msg.SetLdapDomainReq,
    rsp = msg.SetLdapDomainRsp,
    manufacturer = {0, 1},
    sysLockedPolicy = 'Forbidden'
}

iamIpmiCmds.GetLdapDomain = {
    name = 'GetLdapDomain',
    prio = types.Priority.Default,
    netfn = 0x30,
    cmd = 0x93,
    role = types.Role.User,
    privilege = privilege.ReadOnly,
    sensitive = false,
    restricted_channels = {},
    filters = [=[*,*,*,06,05]=],
    decode = [=[<<ManufactureId:3/unit:8, 0x06:1/unit:8, 0x05:1/un]=] .. [=[it:8, Offset:1/unit:8, Length:1/unit:8>>]=],
    encode = [=[<<CompletionCode:1/unit:8, ManufactureId:3/unit:8,]=] ..
        [=[ EndOfList:1/unit:1, Reserved:7/unit:1, Data/strin]=] .. [=[g>>]=],
    req = msg.GetLdapDomainReq,
    rsp = msg.GetLdapDomainRsp,
    manufacturer = {0, 1},
    sysLockedPolicy = 'Allowed'
}

iamIpmiCmds.SetLdapEnabled = {
    name = 'SetLdapEnabled',
    prio = types.Priority.Default,
    netfn = 0x30,
    cmd = 0x93,
    role = types.Role.Administrator,
    privilege = privilege.UserMgmt,
    sensitive = false,
    restricted_channels = {},
    filters = [=[*,*,*,05,06]=],
    decode = [=[<<ManufactureId:3/unit:8, 0x05:1/unit:8, 0x06:1/un]=] ..
        [=[it:8, Flag:1/unit:1, Reserved:7/unit:1, Offset:1/u]=] .. [=[nit:8, Length:1/unit:8, Data/string>>]=],
    encode = [=[<<CompletionCode:1/unit:8, ManufactureId:3/unit:8>]=] .. [=[>]=],
    req = msg.SetLdapEnabledReq,
    rsp = msg.SetLdapEnabledRsp,
    manufacturer = {0, 1},
    sysLockedPolicy = 'Forbidden'
}

iamIpmiCmds.GetLdapEnabled = {
    name = 'GetLdapEnabled',
    prio = types.Priority.Default,
    netfn = 0x30,
    cmd = 0x93,
    role = types.Role.User,
    privilege = privilege.ReadOnly,
    sensitive = false,
    restricted_channels = {},
    filters = [=[*,*,*,06,06]=],
    decode = [=[<<ManufactureId:3/unit:8, 0x06:1/unit:8, 0x06:1/un]=] .. [=[it:8, Offset:1/unit:8, Length:1/unit:8>>]=],
    encode = [=[<<CompletionCode:1/unit:8, ManufactureId:3/unit:8,]=] ..
        [=[ EndOfList:1/unit:1, Reserved:7/unit:1, Data/strin]=] .. [=[g>>]=],
    req = msg.GetLdapEnabledReq,
    rsp = msg.GetLdapEnabledRsp,
    manufacturer = {0, 1},
    sysLockedPolicy = 'Allowed'
}

iamIpmiCmds.GetRemoteGroupConfiguration = {
    name = 'GetRemoteGroupConfiguration',
    prio = types.Priority.Default,
    netfn = 0x30,
    cmd = 0x93,
    role = types.Role.User,
    privilege = privilege.ReadOnly,
    sensitive = false,
    restricted_channels = {},
    filters = [=[*,*,*,0C]=],
    decode = [=[<<ManufactureId:3/unit:8, 0x0C:1/unit:8, GroupId:1]=] ..
        [=[/unit:8, ConfigurationType:1/unit:8, Offset:1/unit]=] .. [=[:8, Length:1/unit:8>>]=],
    encode = [=[<<CompletionCode:1/unit:8, ManufactureId:3/unit:8,]=] ..
        [=[ EndOfList:1/unit:1, Reserved:7/unit:1, Data/strin]=] .. [=[g>>]=],
    req = msg.GetRemoteGroupConfigurationReq,
    rsp = msg.GetRemoteGroupConfigurationRsp,
    manufacturer = {0, 1},
    sysLockedPolicy = 'Allowed'
}

iamIpmiCmds.SetRemoteGroupConfiguration = {
    name = 'SetRemoteGroupConfiguration',
    prio = types.Priority.Default,
    netfn = 0x30,
    cmd = 0x93,
    role = types.Role.Administrator,
    privilege = privilege.UserMgmt,
    sensitive = false,
    restricted_channels = {},
    filters = [=[*,*,*,0D]=],
    decode = [=[<<ManufactureId:3/unit:8, 0x0D:1/unit:8, GroupId:1]=] ..
        [=[/unit:8, ConfigurationType:1/unit:8, Flag:1/unit:1]=] ..
        [=[, Reserved:7/unit:1, Offset:1/unit:8, Length:1/uni]=] .. [=[t:8, Data/string>>]=],
    encode = [=[<<CompletionCode:1/unit:8, ManufactureId:3/unit:8>]=] .. [=[>]=],
    req = msg.SetRemoteGroupConfigurationReq,
    rsp = msg.SetRemoteGroupConfigurationRsp,
    manufacturer = {0, 1},
    sysLockedPolicy = 'Forbidden'
}

iamIpmiCmds.CheckVncPassword = {
    name = 'CheckVncPassword',
    prio = types.Priority.Default,
    netfn = 0x30,
    cmd = 0x94,
    role = types.Role.User,
    privilege = privilege.KVMMgmt,
    sensitive = true,
    restricted_channels = {},
    filters = [=[*,*,*,67,00,02]=],
    decode = [=[<<ManufactureId:3/unit:8, 0x67:1/unit:8, 0x00:1/un]=] ..
        [=[it:8, 0x02:1/unit:8, Reserved:2/unit:8, Length:1/u]=] .. [=[nit:8, Password/string>>]=],
    encode = [=[<<CompletionCode:1/unit:8, ManufactureId:3/unit:8>]=] .. [=[>]=],
    req = msg.CheckVncPasswordReq,
    rsp = msg.CheckVncPasswordRsp,
    manufacturer = {0, 1},
    sysLockedPolicy = 'Forbidden'
}

iamIpmiCmds.DestorySSOToken = {
    name = 'DestorySSOToken',
    prio = types.Priority.Default,
    netfn = 0x30,
    cmd = 0x94,
    role = types.Role.Administrator,
    privilege = privilege.UserMgmt,
    sensitive = true,
    restricted_channels = {},
    filters = [=[*,*,*,3F]=],
    decode = [=[<<ManufactureId:3/unit:8, 0x3F:1/unit:8, length:1/]=] .. [=[unit:8, token/string>>]=],
    encode = [=[<<CompletionCode:1/unit:8, ManufactureId:3/unit:8>]=] .. [=[>]=],
    req = msg.DestorySSOTokenReq,
    rsp = msg.DestorySSOTokenRsp,
    manufacturer = {0, 1},
    sysLockedPolicy = 'Allowed'
}

return iamIpmiCmds
