--[[-- Copyright (c) Huawei Technologies Co., Ltd. 2024. All rights reserved.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
]] --
local validate = require 'mc.validate'
local utils = require 'mc.utils'

local TestUserPassword = {}

---@class iamIpmiCmds.TestUserPasswordReq
---@field UserId integer
---@field Reserved1 integer
---@field PasswordSize integer
---@field Reserved2 integer
---@field PasswordData string
local TTestUserPasswordReq = {}
TTestUserPasswordReq.__index = TTestUserPasswordReq
TTestUserPasswordReq.group = {}

local function TTestUserPasswordReq_from_obj(obj)
    return setmetatable(obj, TTestUserPasswordReq)
end

function TTestUserPasswordReq.new(UserId, Reserved1, PasswordSize, Reserved2, PasswordData)
    return TTestUserPasswordReq_from_obj({
        UserId = UserId,
        Reserved1 = Reserved1,
        PasswordSize = PasswordSize,
        Reserved2 = Reserved2,
        PasswordData = PasswordData
    })
end
---@param obj iamIpmiCmds.TestUserPasswordReq
function TTestUserPasswordReq:init_from_obj(obj)
    self.UserId = obj.UserId
    self.Reserved1 = obj.Reserved1
    self.PasswordSize = obj.PasswordSize
    self.Reserved2 = obj.Reserved2
    self.PasswordData = obj.PasswordData
end

function TTestUserPasswordReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TTestUserPasswordReq.group)
end

TTestUserPasswordReq.from_obj = TTestUserPasswordReq_from_obj

TTestUserPasswordReq.proto_property = {'UserId', 'Reserved1', 'PasswordSize', 'Reserved2', 'PasswordData'}

TTestUserPasswordReq.default = {0, 0, 0, 0, ''}

TTestUserPasswordReq.struct = {
    {name = 'UserId', is_array = false, struct = nil}, {name = 'Reserved1', is_array = false, struct = nil},
    {name = 'PasswordSize', is_array = false, struct = nil}, {name = 'Reserved2', is_array = false, struct = nil},
    {name = 'PasswordData', is_array = false, struct = nil}
}

function TTestUserPasswordReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'UserId', self.UserId, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'Reserved1', self.Reserved1, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'PasswordSize', self.PasswordSize, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'Reserved2', self.Reserved2, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'PasswordData', self.PasswordData, 'string', false, errs, need_convert)

    TTestUserPasswordReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TTestUserPasswordReq.proto_property, errs, need_convert)
    return self
end

function TTestUserPasswordReq:unpack(_)
    return self.UserId, self.Reserved1, self.PasswordSize, self.Reserved2, self.PasswordData
end

TestUserPassword.TestUserPasswordReq = TTestUserPasswordReq

---@class iamIpmiCmds.TestUserPasswordRsp
---@field CompletionCode integer
local TTestUserPasswordRsp = {}
TTestUserPasswordRsp.__index = TTestUserPasswordRsp
TTestUserPasswordRsp.group = {}

local function TTestUserPasswordRsp_from_obj(obj)
    return setmetatable(obj, TTestUserPasswordRsp)
end

function TTestUserPasswordRsp.new(CompletionCode)
    return TTestUserPasswordRsp_from_obj({CompletionCode = CompletionCode})
end
---@param obj iamIpmiCmds.TestUserPasswordRsp
function TTestUserPasswordRsp:init_from_obj(obj)
    self.CompletionCode = obj.CompletionCode
end

function TTestUserPasswordRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TTestUserPasswordRsp.group)
end

TTestUserPasswordRsp.from_obj = TTestUserPasswordRsp_from_obj

TTestUserPasswordRsp.proto_property = {'CompletionCode'}

TTestUserPasswordRsp.default = {0}

TTestUserPasswordRsp.struct = {{name = 'CompletionCode', is_array = false, struct = nil}}

function TTestUserPasswordRsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'CompletionCode', self.CompletionCode, 'uint32', false, errs, need_convert)

    TTestUserPasswordRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TTestUserPasswordRsp.proto_property, errs, need_convert)
    return self
end

function TTestUserPasswordRsp:unpack(_)
    return self.CompletionCode
end

TestUserPassword.TestUserPasswordRsp = TTestUserPasswordRsp

return TestUserPassword
