--[[-- Copyright (c) Huawei Technologies Co., Ltd. 2024. All rights reserved.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
]] --
local validate = require 'mc.validate'
local utils = require 'mc.utils'

local SetWebTimeOut = {}

---@class iamIpmiCmds.SetWebTimeOutReq
---@field ManufactureId integer
---@field UserId integer
---@field Reserved1 integer
---@field Reserved2 integer
---@field Length integer
---@field Data string
local TSetWebTimeOutReq = {}
TSetWebTimeOutReq.__index = TSetWebTimeOutReq
TSetWebTimeOutReq.group = {}

local function TSetWebTimeOutReq_from_obj(obj)
    return setmetatable(obj, TSetWebTimeOutReq)
end

function TSetWebTimeOutReq.new(ManufactureId, UserId, Reserved1, Reserved2, Length, Data)
    return TSetWebTimeOutReq_from_obj({
        ManufactureId = ManufactureId,
        UserId = UserId,
        Reserved1 = Reserved1,
        Reserved2 = Reserved2,
        Length = Length,
        Data = Data
    })
end
---@param obj iamIpmiCmds.SetWebTimeOutReq
function TSetWebTimeOutReq:init_from_obj(obj)
    self.ManufactureId = obj.ManufactureId
    self.UserId = obj.UserId
    self.Reserved1 = obj.Reserved1
    self.Reserved2 = obj.Reserved2
    self.Length = obj.Length
    self.Data = obj.Data
end

function TSetWebTimeOutReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSetWebTimeOutReq.group)
end

TSetWebTimeOutReq.from_obj = TSetWebTimeOutReq_from_obj

TSetWebTimeOutReq.proto_property = {'ManufactureId', 'UserId', 'Reserved1', 'Reserved2', 'Length', 'Data'}

TSetWebTimeOutReq.default = {0, 0, 0, 0, 0, ''}

TSetWebTimeOutReq.struct = {
    {name = 'ManufactureId', is_array = false, struct = nil}, {name = 'UserId', is_array = false, struct = nil},
    {name = 'Reserved1', is_array = false, struct = nil}, {name = 'Reserved2', is_array = false, struct = nil},
    {name = 'Length', is_array = false, struct = nil}, {name = 'Data', is_array = false, struct = nil}
}

function TSetWebTimeOutReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'ManufactureId', self.ManufactureId, 'uint32', false, errs, need_convert)
    validate.Optional(prefix .. 'UserId', self.UserId, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'Reserved1', self.Reserved1, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'Reserved2', self.Reserved2, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'Length', self.Length, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'Data', self.Data, 'string', false, errs, need_convert)

    TSetWebTimeOutReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSetWebTimeOutReq.proto_property, errs, need_convert)
    return self
end

function TSetWebTimeOutReq:unpack(_)
    return self.ManufactureId, self.UserId, self.Reserved1, self.Reserved2, self.Length, self.Data
end

SetWebTimeOut.SetWebTimeOutReq = TSetWebTimeOutReq

---@class iamIpmiCmds.SetWebTimeOutRsp
---@field CompletionCode integer
---@field ManufactureId integer
local TSetWebTimeOutRsp = {}
TSetWebTimeOutRsp.__index = TSetWebTimeOutRsp
TSetWebTimeOutRsp.group = {}

local function TSetWebTimeOutRsp_from_obj(obj)
    return setmetatable(obj, TSetWebTimeOutRsp)
end

function TSetWebTimeOutRsp.new(CompletionCode, ManufactureId)
    return TSetWebTimeOutRsp_from_obj({CompletionCode = CompletionCode, ManufactureId = ManufactureId})
end
---@param obj iamIpmiCmds.SetWebTimeOutRsp
function TSetWebTimeOutRsp:init_from_obj(obj)
    self.CompletionCode = obj.CompletionCode
    self.ManufactureId = obj.ManufactureId
end

function TSetWebTimeOutRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSetWebTimeOutRsp.group)
end

TSetWebTimeOutRsp.from_obj = TSetWebTimeOutRsp_from_obj

TSetWebTimeOutRsp.proto_property = {'CompletionCode', 'ManufactureId'}

TSetWebTimeOutRsp.default = {0, 0}

TSetWebTimeOutRsp.struct = {
    {name = 'CompletionCode', is_array = false, struct = nil}, {name = 'ManufactureId', is_array = false, struct = nil}
}

function TSetWebTimeOutRsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'CompletionCode', self.CompletionCode, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'ManufactureId', self.ManufactureId, 'uint32', false, errs, need_convert)

    TSetWebTimeOutRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSetWebTimeOutRsp.proto_property, errs, need_convert)
    return self
end

function TSetWebTimeOutRsp:unpack(_)
    return self.CompletionCode, self.ManufactureId
end

SetWebTimeOut.SetWebTimeOutRsp = TSetWebTimeOutRsp

return SetWebTimeOut
