--[[-- Copyright (c) Huawei Technologies Co., Ltd. 2024. All rights reserved.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
]] --
local validate = require 'mc.validate'
local utils = require 'mc.utils'

local SetRemoteGroupConfiguration = {}

---@class iamIpmiCmds.SetRemoteGroupConfigurationReq
---@field ManufactureId integer
---@field GroupId integer
---@field ConfigurationType integer
---@field Flag integer
---@field Reserved integer
---@field Offset integer
---@field Length integer
---@field Data string
local TSetRemoteGroupConfigurationReq = {}
TSetRemoteGroupConfigurationReq.__index = TSetRemoteGroupConfigurationReq
TSetRemoteGroupConfigurationReq.group = {}

local function TSetRemoteGroupConfigurationReq_from_obj(obj)
    return setmetatable(obj, TSetRemoteGroupConfigurationReq)
end

function TSetRemoteGroupConfigurationReq.new(ManufactureId, GroupId, ConfigurationType, Flag, Reserved, Offset, Length,
    Data)
    return TSetRemoteGroupConfigurationReq_from_obj({
        ManufactureId = ManufactureId,
        GroupId = GroupId,
        ConfigurationType = ConfigurationType,
        Flag = Flag,
        Reserved = Reserved,
        Offset = Offset,
        Length = Length,
        Data = Data
    })
end
---@param obj iamIpmiCmds.SetRemoteGroupConfigurationReq
function TSetRemoteGroupConfigurationReq:init_from_obj(obj)
    self.ManufactureId = obj.ManufactureId
    self.GroupId = obj.GroupId
    self.ConfigurationType = obj.ConfigurationType
    self.Flag = obj.Flag
    self.Reserved = obj.Reserved
    self.Offset = obj.Offset
    self.Length = obj.Length
    self.Data = obj.Data
end

function TSetRemoteGroupConfigurationReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSetRemoteGroupConfigurationReq.group)
end

TSetRemoteGroupConfigurationReq.from_obj = TSetRemoteGroupConfigurationReq_from_obj

TSetRemoteGroupConfigurationReq.proto_property = {
    'ManufactureId', 'GroupId', 'ConfigurationType', 'Flag', 'Reserved', 'Offset', 'Length', 'Data'
}

TSetRemoteGroupConfigurationReq.default = {0, 0, 0, 0, 0, 0, 0, ''}

TSetRemoteGroupConfigurationReq.struct = {
    {name = 'ManufactureId', is_array = false, struct = nil}, {name = 'GroupId', is_array = false, struct = nil},
    {name = 'ConfigurationType', is_array = false, struct = nil}, {name = 'Flag', is_array = false, struct = nil},
    {name = 'Reserved', is_array = false, struct = nil}, {name = 'Offset', is_array = false, struct = nil},
    {name = 'Length', is_array = false, struct = nil}, {name = 'Data', is_array = false, struct = nil}
}

function TSetRemoteGroupConfigurationReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'ManufactureId', self.ManufactureId, 'uint32', false, errs, need_convert)
    validate.Optional(prefix .. 'GroupId', self.GroupId, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'ConfigurationType', self.ConfigurationType, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'Flag', self.Flag, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'Reserved', self.Reserved, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'Offset', self.Offset, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'Length', self.Length, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'Data', self.Data, 'string', false, errs, need_convert)

    TSetRemoteGroupConfigurationReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSetRemoteGroupConfigurationReq.proto_property, errs, need_convert)
    return self
end

function TSetRemoteGroupConfigurationReq:unpack(_)
    return self.ManufactureId, self.GroupId, self.ConfigurationType, self.Flag, self.Reserved, self.Offset, self.Length,
        self.Data
end

SetRemoteGroupConfiguration.SetRemoteGroupConfigurationReq = TSetRemoteGroupConfigurationReq

---@class iamIpmiCmds.SetRemoteGroupConfigurationRsp
---@field CompletionCode integer
---@field ManufactureId integer
local TSetRemoteGroupConfigurationRsp = {}
TSetRemoteGroupConfigurationRsp.__index = TSetRemoteGroupConfigurationRsp
TSetRemoteGroupConfigurationRsp.group = {}

local function TSetRemoteGroupConfigurationRsp_from_obj(obj)
    return setmetatable(obj, TSetRemoteGroupConfigurationRsp)
end

function TSetRemoteGroupConfigurationRsp.new(CompletionCode, ManufactureId)
    return TSetRemoteGroupConfigurationRsp_from_obj({CompletionCode = CompletionCode, ManufactureId = ManufactureId})
end
---@param obj iamIpmiCmds.SetRemoteGroupConfigurationRsp
function TSetRemoteGroupConfigurationRsp:init_from_obj(obj)
    self.CompletionCode = obj.CompletionCode
    self.ManufactureId = obj.ManufactureId
end

function TSetRemoteGroupConfigurationRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSetRemoteGroupConfigurationRsp.group)
end

TSetRemoteGroupConfigurationRsp.from_obj = TSetRemoteGroupConfigurationRsp_from_obj

TSetRemoteGroupConfigurationRsp.proto_property = {'CompletionCode', 'ManufactureId'}

TSetRemoteGroupConfigurationRsp.default = {0, 0}

TSetRemoteGroupConfigurationRsp.struct = {
    {name = 'CompletionCode', is_array = false, struct = nil}, {name = 'ManufactureId', is_array = false, struct = nil}
}

function TSetRemoteGroupConfigurationRsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'CompletionCode', self.CompletionCode, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'ManufactureId', self.ManufactureId, 'uint32', false, errs, need_convert)

    TSetRemoteGroupConfigurationRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSetRemoteGroupConfigurationRsp.proto_property, errs, need_convert)
    return self
end

function TSetRemoteGroupConfigurationRsp:unpack(_)
    return self.CompletionCode, self.ManufactureId
end

SetRemoteGroupConfiguration.SetRemoteGroupConfigurationRsp = TSetRemoteGroupConfigurationRsp

return SetRemoteGroupConfiguration
