--[[-- Copyright (c) Huawei Technologies Co., Ltd. 2024. All rights reserved.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
]] --
local validate = require 'mc.validate'
local utils = require 'mc.utils'

local SetLdapHostAddr = {}

---@class iamIpmiCmds.SetLdapHostAddrReq
---@field ManufactureId integer
---@field Flag integer
---@field Reserved integer
---@field Offset integer
---@field Length integer
---@field Data string
local TSetLdapHostAddrReq = {}
TSetLdapHostAddrReq.__index = TSetLdapHostAddrReq
TSetLdapHostAddrReq.group = {}

local function TSetLdapHostAddrReq_from_obj(obj)
    return setmetatable(obj, TSetLdapHostAddrReq)
end

function TSetLdapHostAddrReq.new(ManufactureId, Flag, Reserved, Offset, Length, Data)
    return TSetLdapHostAddrReq_from_obj({
        ManufactureId = ManufactureId,
        Flag = Flag,
        Reserved = Reserved,
        Offset = Offset,
        Length = Length,
        Data = Data
    })
end
---@param obj iamIpmiCmds.SetLdapHostAddrReq
function TSetLdapHostAddrReq:init_from_obj(obj)
    self.ManufactureId = obj.ManufactureId
    self.Flag = obj.Flag
    self.Reserved = obj.Reserved
    self.Offset = obj.Offset
    self.Length = obj.Length
    self.Data = obj.Data
end

function TSetLdapHostAddrReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSetLdapHostAddrReq.group)
end

TSetLdapHostAddrReq.from_obj = TSetLdapHostAddrReq_from_obj

TSetLdapHostAddrReq.proto_property = {'ManufactureId', 'Flag', 'Reserved', 'Offset', 'Length', 'Data'}

TSetLdapHostAddrReq.default = {0, 0, 0, 0, 0, ''}

TSetLdapHostAddrReq.struct = {
    {name = 'ManufactureId', is_array = false, struct = nil}, {name = 'Flag', is_array = false, struct = nil},
    {name = 'Reserved', is_array = false, struct = nil}, {name = 'Offset', is_array = false, struct = nil},
    {name = 'Length', is_array = false, struct = nil}, {name = 'Data', is_array = false, struct = nil}
}

function TSetLdapHostAddrReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'ManufactureId', self.ManufactureId, 'uint32', false, errs, need_convert)
    validate.Optional(prefix .. 'Flag', self.Flag, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'Reserved', self.Reserved, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'Offset', self.Offset, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'Length', self.Length, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'Data', self.Data, 'string', false, errs, need_convert)

    TSetLdapHostAddrReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSetLdapHostAddrReq.proto_property, errs, need_convert)
    return self
end

function TSetLdapHostAddrReq:unpack(_)
    return self.ManufactureId, self.Flag, self.Reserved, self.Offset, self.Length, self.Data
end

SetLdapHostAddr.SetLdapHostAddrReq = TSetLdapHostAddrReq

---@class iamIpmiCmds.SetLdapHostAddrRsp
---@field CompletionCode integer
---@field ManufactureId integer
local TSetLdapHostAddrRsp = {}
TSetLdapHostAddrRsp.__index = TSetLdapHostAddrRsp
TSetLdapHostAddrRsp.group = {}

local function TSetLdapHostAddrRsp_from_obj(obj)
    return setmetatable(obj, TSetLdapHostAddrRsp)
end

function TSetLdapHostAddrRsp.new(CompletionCode, ManufactureId)
    return TSetLdapHostAddrRsp_from_obj({CompletionCode = CompletionCode, ManufactureId = ManufactureId})
end
---@param obj iamIpmiCmds.SetLdapHostAddrRsp
function TSetLdapHostAddrRsp:init_from_obj(obj)
    self.CompletionCode = obj.CompletionCode
    self.ManufactureId = obj.ManufactureId
end

function TSetLdapHostAddrRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSetLdapHostAddrRsp.group)
end

TSetLdapHostAddrRsp.from_obj = TSetLdapHostAddrRsp_from_obj

TSetLdapHostAddrRsp.proto_property = {'CompletionCode', 'ManufactureId'}

TSetLdapHostAddrRsp.default = {0, 0}

TSetLdapHostAddrRsp.struct = {
    {name = 'CompletionCode', is_array = false, struct = nil}, {name = 'ManufactureId', is_array = false, struct = nil}
}

function TSetLdapHostAddrRsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'CompletionCode', self.CompletionCode, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'ManufactureId', self.ManufactureId, 'uint32', false, errs, need_convert)

    TSetLdapHostAddrRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSetLdapHostAddrRsp.proto_property, errs, need_convert)
    return self
end

function TSetLdapHostAddrRsp:unpack(_)
    return self.CompletionCode, self.ManufactureId
end

SetLdapHostAddr.SetLdapHostAddrRsp = TSetLdapHostAddrRsp

return SetLdapHostAddr
