--[[-- Copyright (c) Huawei Technologies Co., Ltd. 2024. All rights reserved.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
]] --
local validate = require 'mc.validate'
local utils = require 'mc.utils'

local IpmiGetAuthToken = {}

---@class iamIpmiCmds.IpmiGetAuthTokenReq
---@field ManufactureId integer
---@field RoleId integer
---@field SessionType integer
---@field UserType integer
---@field Reserved integer
---@field IpMode integer
---@field IpAddress string
---@field NotEndFlag integer
---@field Reserved1 integer
---@field Offset integer
---@field Length integer
---@field Data string
local TIpmiGetAuthTokenReq = {}
TIpmiGetAuthTokenReq.__index = TIpmiGetAuthTokenReq
TIpmiGetAuthTokenReq.group = {}

local function TIpmiGetAuthTokenReq_from_obj(obj)
    return setmetatable(obj, TIpmiGetAuthTokenReq)
end

function TIpmiGetAuthTokenReq.new(ManufactureId, RoleId, SessionType, UserType, Reserved, IpMode, IpAddress, NotEndFlag,
    Reserved1, Offset, Length, Data)
    return TIpmiGetAuthTokenReq_from_obj({
        ManufactureId = ManufactureId,
        RoleId = RoleId,
        SessionType = SessionType,
        UserType = UserType,
        Reserved = Reserved,
        IpMode = IpMode,
        IpAddress = IpAddress,
        NotEndFlag = NotEndFlag,
        Reserved1 = Reserved1,
        Offset = Offset,
        Length = Length,
        Data = Data
    })
end
---@param obj iamIpmiCmds.IpmiGetAuthTokenReq
function TIpmiGetAuthTokenReq:init_from_obj(obj)
    self.ManufactureId = obj.ManufactureId
    self.RoleId = obj.RoleId
    self.SessionType = obj.SessionType
    self.UserType = obj.UserType
    self.Reserved = obj.Reserved
    self.IpMode = obj.IpMode
    self.IpAddress = obj.IpAddress
    self.NotEndFlag = obj.NotEndFlag
    self.Reserved1 = obj.Reserved1
    self.Offset = obj.Offset
    self.Length = obj.Length
    self.Data = obj.Data
end

function TIpmiGetAuthTokenReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TIpmiGetAuthTokenReq.group)
end

TIpmiGetAuthTokenReq.from_obj = TIpmiGetAuthTokenReq_from_obj

TIpmiGetAuthTokenReq.proto_property = {
    'ManufactureId', 'RoleId', 'SessionType', 'UserType', 'Reserved', 'IpMode', 'IpAddress', 'NotEndFlag', 'Reserved1',
    'Offset', 'Length', 'Data'
}

TIpmiGetAuthTokenReq.default = {0, 0, 0, 0, 0, 0, '', 0, 0, 0, 0, ''}

TIpmiGetAuthTokenReq.struct = {
    {name = 'ManufactureId', is_array = false, struct = nil}, {name = 'RoleId', is_array = false, struct = nil},
    {name = 'SessionType', is_array = false, struct = nil}, {name = 'UserType', is_array = false, struct = nil},
    {name = 'Reserved', is_array = false, struct = nil}, {name = 'IpMode', is_array = false, struct = nil},
    {name = 'IpAddress', is_array = false, struct = nil}, {name = 'NotEndFlag', is_array = false, struct = nil},
    {name = 'Reserved1', is_array = false, struct = nil}, {name = 'Offset', is_array = false, struct = nil},
    {name = 'Length', is_array = false, struct = nil}, {name = 'Data', is_array = false, struct = nil}
}

function TIpmiGetAuthTokenReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'ManufactureId', self.ManufactureId, 'uint32', false, errs, need_convert)
    validate.Optional(prefix .. 'RoleId', self.RoleId, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'SessionType', self.SessionType, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'UserType', self.UserType, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'Reserved', self.Reserved, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'IpMode', self.IpMode, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'IpAddress', self.IpAddress, 'string', false, errs, need_convert)
    validate.Optional(prefix .. 'NotEndFlag', self.NotEndFlag, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'Reserved1', self.Reserved1, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'Offset', self.Offset, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'Length', self.Length, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'Data', self.Data, 'string', false, errs, need_convert)

    TIpmiGetAuthTokenReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TIpmiGetAuthTokenReq.proto_property, errs, need_convert)
    return self
end

function TIpmiGetAuthTokenReq:unpack(_)
    return self.ManufactureId, self.RoleId, self.SessionType, self.UserType, self.Reserved, self.IpMode, self.IpAddress,
        self.NotEndFlag, self.Reserved1, self.Offset, self.Length, self.Data
end

IpmiGetAuthToken.IpmiGetAuthTokenReq = TIpmiGetAuthTokenReq

---@class iamIpmiCmds.IpmiGetAuthTokenRsp
---@field CompletionCode integer
---@field ManufactureId integer
---@field Token string
---@field End integer
local TIpmiGetAuthTokenRsp = {}
TIpmiGetAuthTokenRsp.__index = TIpmiGetAuthTokenRsp
TIpmiGetAuthTokenRsp.group = {}

local function TIpmiGetAuthTokenRsp_from_obj(obj)
    return setmetatable(obj, TIpmiGetAuthTokenRsp)
end

function TIpmiGetAuthTokenRsp.new(CompletionCode, ManufactureId, Token, End)
    return TIpmiGetAuthTokenRsp_from_obj({
        CompletionCode = CompletionCode,
        ManufactureId = ManufactureId,
        Token = Token,
        End = End
    })
end
---@param obj iamIpmiCmds.IpmiGetAuthTokenRsp
function TIpmiGetAuthTokenRsp:init_from_obj(obj)
    self.CompletionCode = obj.CompletionCode
    self.ManufactureId = obj.ManufactureId
    self.Token = obj.Token
    self.End = obj.End
end

function TIpmiGetAuthTokenRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TIpmiGetAuthTokenRsp.group)
end

TIpmiGetAuthTokenRsp.from_obj = TIpmiGetAuthTokenRsp_from_obj

TIpmiGetAuthTokenRsp.proto_property = {'CompletionCode', 'ManufactureId', 'Token', 'End'}

TIpmiGetAuthTokenRsp.default = {0, 0, '', 0}

TIpmiGetAuthTokenRsp.struct = {
    {name = 'CompletionCode', is_array = false, struct = nil}, {name = 'ManufactureId', is_array = false, struct = nil},
    {name = 'Token', is_array = false, struct = nil}, {name = 'End', is_array = false, struct = nil}
}

function TIpmiGetAuthTokenRsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'CompletionCode', self.CompletionCode, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'ManufactureId', self.ManufactureId, 'uint32', false, errs, need_convert)
    validate.Optional(prefix .. 'Token', self.Token, 'string', false, errs, need_convert)
    validate.Optional(prefix .. 'End', self.End, 'uint8', false, errs, need_convert)

    TIpmiGetAuthTokenRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TIpmiGetAuthTokenRsp.proto_property, errs, need_convert)
    return self
end

function TIpmiGetAuthTokenRsp:unpack(_)
    return self.CompletionCode, self.ManufactureId, self.Token, self.End
end

IpmiGetAuthToken.IpmiGetAuthTokenRsp = TIpmiGetAuthTokenRsp

return IpmiGetAuthToken
