--[[-- Copyright (c) Huawei Technologies Co., Ltd. 2024. All rights reserved.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
]] --
local validate = require 'mc.validate'
local utils = require 'mc.utils'

local GetWebTimeOut = {}

---@class iamIpmiCmds.GetWebTimeOutReq
---@field ManufactureId integer
---@field UserId integer
---@field Reserved1 integer
local TGetWebTimeOutReq = {}
TGetWebTimeOutReq.__index = TGetWebTimeOutReq
TGetWebTimeOutReq.group = {}

local function TGetWebTimeOutReq_from_obj(obj)
    return setmetatable(obj, TGetWebTimeOutReq)
end

function TGetWebTimeOutReq.new(ManufactureId, UserId, Reserved1)
    return TGetWebTimeOutReq_from_obj({ManufactureId = ManufactureId, UserId = UserId, Reserved1 = Reserved1})
end
---@param obj iamIpmiCmds.GetWebTimeOutReq
function TGetWebTimeOutReq:init_from_obj(obj)
    self.ManufactureId = obj.ManufactureId
    self.UserId = obj.UserId
    self.Reserved1 = obj.Reserved1
end

function TGetWebTimeOutReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TGetWebTimeOutReq.group)
end

TGetWebTimeOutReq.from_obj = TGetWebTimeOutReq_from_obj

TGetWebTimeOutReq.proto_property = {'ManufactureId', 'UserId', 'Reserved1'}

TGetWebTimeOutReq.default = {0, 0, 0}

TGetWebTimeOutReq.struct = {
    {name = 'ManufactureId', is_array = false, struct = nil}, {name = 'UserId', is_array = false, struct = nil},
    {name = 'Reserved1', is_array = false, struct = nil}
}

function TGetWebTimeOutReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'ManufactureId', self.ManufactureId, 'uint32', false, errs, need_convert)
    validate.Optional(prefix .. 'UserId', self.UserId, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'Reserved1', self.Reserved1, 'uint8', false, errs, need_convert)

    TGetWebTimeOutReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TGetWebTimeOutReq.proto_property, errs, need_convert)
    return self
end

function TGetWebTimeOutReq:unpack(_)
    return self.ManufactureId, self.UserId, self.Reserved1
end

GetWebTimeOut.GetWebTimeOutReq = TGetWebTimeOutReq

---@class iamIpmiCmds.GetWebTimeOutRsp
---@field CompletionCode integer
---@field ManufactureId integer
---@field Length integer
---@field Data string
local TGetWebTimeOutRsp = {}
TGetWebTimeOutRsp.__index = TGetWebTimeOutRsp
TGetWebTimeOutRsp.group = {}

local function TGetWebTimeOutRsp_from_obj(obj)
    return setmetatable(obj, TGetWebTimeOutRsp)
end

function TGetWebTimeOutRsp.new(CompletionCode, ManufactureId, Length, Data)
    return TGetWebTimeOutRsp_from_obj({
        CompletionCode = CompletionCode,
        ManufactureId = ManufactureId,
        Length = Length,
        Data = Data
    })
end
---@param obj iamIpmiCmds.GetWebTimeOutRsp
function TGetWebTimeOutRsp:init_from_obj(obj)
    self.CompletionCode = obj.CompletionCode
    self.ManufactureId = obj.ManufactureId
    self.Length = obj.Length
    self.Data = obj.Data
end

function TGetWebTimeOutRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TGetWebTimeOutRsp.group)
end

TGetWebTimeOutRsp.from_obj = TGetWebTimeOutRsp_from_obj

TGetWebTimeOutRsp.proto_property = {'CompletionCode', 'ManufactureId', 'Length', 'Data'}

TGetWebTimeOutRsp.default = {0, 0, 0, ''}

TGetWebTimeOutRsp.struct = {
    {name = 'CompletionCode', is_array = false, struct = nil}, {name = 'ManufactureId', is_array = false, struct = nil},
    {name = 'Length', is_array = false, struct = nil}, {name = 'Data', is_array = false, struct = nil}
}

function TGetWebTimeOutRsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'CompletionCode', self.CompletionCode, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'ManufactureId', self.ManufactureId, 'uint32', false, errs, need_convert)
    validate.Optional(prefix .. 'Length', self.Length, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'Data', self.Data, 'string', false, errs, need_convert)

    TGetWebTimeOutRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TGetWebTimeOutRsp.proto_property, errs, need_convert)
    return self
end

function TGetWebTimeOutRsp:unpack(_)
    return self.CompletionCode, self.ManufactureId, self.Length, self.Data
end

GetWebTimeOut.GetWebTimeOutRsp = TGetWebTimeOutRsp

return GetWebTimeOut
