--[[-- Copyright (c) Huawei Technologies Co., Ltd. 2024. All rights reserved.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
]] --
local validate = require 'mc.validate'
local utils = require 'mc.utils'

local GetLdapEnabled = {}

---@class iamIpmiCmds.GetLdapEnabledReq
---@field ManufactureId integer
---@field Offset integer
---@field Length integer
local TGetLdapEnabledReq = {}
TGetLdapEnabledReq.__index = TGetLdapEnabledReq
TGetLdapEnabledReq.group = {}

local function TGetLdapEnabledReq_from_obj(obj)
    return setmetatable(obj, TGetLdapEnabledReq)
end

function TGetLdapEnabledReq.new(ManufactureId, Offset, Length)
    return TGetLdapEnabledReq_from_obj({ManufactureId = ManufactureId, Offset = Offset, Length = Length})
end
---@param obj iamIpmiCmds.GetLdapEnabledReq
function TGetLdapEnabledReq:init_from_obj(obj)
    self.ManufactureId = obj.ManufactureId
    self.Offset = obj.Offset
    self.Length = obj.Length
end

function TGetLdapEnabledReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TGetLdapEnabledReq.group)
end

TGetLdapEnabledReq.from_obj = TGetLdapEnabledReq_from_obj

TGetLdapEnabledReq.proto_property = {'ManufactureId', 'Offset', 'Length'}

TGetLdapEnabledReq.default = {0, 0, 0}

TGetLdapEnabledReq.struct = {
    {name = 'ManufactureId', is_array = false, struct = nil}, {name = 'Offset', is_array = false, struct = nil},
    {name = 'Length', is_array = false, struct = nil}
}

function TGetLdapEnabledReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'ManufactureId', self.ManufactureId, 'uint32', false, errs, need_convert)
    validate.Optional(prefix .. 'Offset', self.Offset, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'Length', self.Length, 'uint8', false, errs, need_convert)

    TGetLdapEnabledReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TGetLdapEnabledReq.proto_property, errs, need_convert)
    return self
end

function TGetLdapEnabledReq:unpack(_)
    return self.ManufactureId, self.Offset, self.Length
end

GetLdapEnabled.GetLdapEnabledReq = TGetLdapEnabledReq

---@class iamIpmiCmds.GetLdapEnabledRsp
---@field CompletionCode integer
---@field ManufactureId integer
---@field EndOfList integer
---@field Reserved integer
---@field Data string
local TGetLdapEnabledRsp = {}
TGetLdapEnabledRsp.__index = TGetLdapEnabledRsp
TGetLdapEnabledRsp.group = {}

local function TGetLdapEnabledRsp_from_obj(obj)
    return setmetatable(obj, TGetLdapEnabledRsp)
end

function TGetLdapEnabledRsp.new(CompletionCode, ManufactureId, EndOfList, Reserved, Data)
    return TGetLdapEnabledRsp_from_obj({
        CompletionCode = CompletionCode,
        ManufactureId = ManufactureId,
        EndOfList = EndOfList,
        Reserved = Reserved,
        Data = Data
    })
end
---@param obj iamIpmiCmds.GetLdapEnabledRsp
function TGetLdapEnabledRsp:init_from_obj(obj)
    self.CompletionCode = obj.CompletionCode
    self.ManufactureId = obj.ManufactureId
    self.EndOfList = obj.EndOfList
    self.Reserved = obj.Reserved
    self.Data = obj.Data
end

function TGetLdapEnabledRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TGetLdapEnabledRsp.group)
end

TGetLdapEnabledRsp.from_obj = TGetLdapEnabledRsp_from_obj

TGetLdapEnabledRsp.proto_property = {'CompletionCode', 'ManufactureId', 'EndOfList', 'Reserved', 'Data'}

TGetLdapEnabledRsp.default = {0, 0, 0, 0, ''}

TGetLdapEnabledRsp.struct = {
    {name = 'CompletionCode', is_array = false, struct = nil}, {name = 'ManufactureId', is_array = false, struct = nil},
    {name = 'EndOfList', is_array = false, struct = nil}, {name = 'Reserved', is_array = false, struct = nil},
    {name = 'Data', is_array = false, struct = nil}
}

function TGetLdapEnabledRsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'CompletionCode', self.CompletionCode, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'ManufactureId', self.ManufactureId, 'uint32', false, errs, need_convert)
    validate.Optional(prefix .. 'EndOfList', self.EndOfList, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'Reserved', self.Reserved, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'Data', self.Data, 'string', false, errs, need_convert)

    TGetLdapEnabledRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TGetLdapEnabledRsp.proto_property, errs, need_convert)
    return self
end

function TGetLdapEnabledRsp:unpack(_)
    return self.CompletionCode, self.ManufactureId, self.EndOfList, self.Reserved, self.Data
end

GetLdapEnabled.GetLdapEnabledRsp = TGetLdapEnabledRsp

return GetLdapEnabled
