--[[-- Copyright (c) Huawei Technologies Co., Ltd. 2024. All rights reserved.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
]] --
local validate = require 'mc.validate'
local utils = require 'mc.utils'

local DestorySSOToken = {}

---@class iamIpmiCmds.DestorySSOTokenReq
---@field ManufactureId integer
---@field length integer
---@field token string
local TDestorySSOTokenReq = {}
TDestorySSOTokenReq.__index = TDestorySSOTokenReq
TDestorySSOTokenReq.group = {}

local function TDestorySSOTokenReq_from_obj(obj)
    return setmetatable(obj, TDestorySSOTokenReq)
end

function TDestorySSOTokenReq.new(ManufactureId, length, token)
    return TDestorySSOTokenReq_from_obj({ManufactureId = ManufactureId, length = length, token = token})
end
---@param obj iamIpmiCmds.DestorySSOTokenReq
function TDestorySSOTokenReq:init_from_obj(obj)
    self.ManufactureId = obj.ManufactureId
    self.length = obj.length
    self.token = obj.token
end

function TDestorySSOTokenReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TDestorySSOTokenReq.group)
end

TDestorySSOTokenReq.from_obj = TDestorySSOTokenReq_from_obj

TDestorySSOTokenReq.proto_property = {'ManufactureId', 'length', 'token'}

TDestorySSOTokenReq.default = {0, 0, ''}

TDestorySSOTokenReq.struct = {
    {name = 'ManufactureId', is_array = false, struct = nil}, {name = 'length', is_array = false, struct = nil},
    {name = 'token', is_array = false, struct = nil}
}

function TDestorySSOTokenReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'ManufactureId', self.ManufactureId, 'uint32', false, errs, need_convert)
    validate.Optional(prefix .. 'length', self.length, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'token', self.token, 'string', false, errs, need_convert)

    TDestorySSOTokenReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TDestorySSOTokenReq.proto_property, errs, need_convert)
    return self
end

function TDestorySSOTokenReq:unpack(_)
    return self.ManufactureId, self.length, self.token
end

DestorySSOToken.DestorySSOTokenReq = TDestorySSOTokenReq

---@class iamIpmiCmds.DestorySSOTokenRsp
---@field CompletionCode integer
---@field ManufactureId integer
local TDestorySSOTokenRsp = {}
TDestorySSOTokenRsp.__index = TDestorySSOTokenRsp
TDestorySSOTokenRsp.group = {}

local function TDestorySSOTokenRsp_from_obj(obj)
    return setmetatable(obj, TDestorySSOTokenRsp)
end

function TDestorySSOTokenRsp.new(CompletionCode, ManufactureId)
    return TDestorySSOTokenRsp_from_obj({CompletionCode = CompletionCode, ManufactureId = ManufactureId})
end
---@param obj iamIpmiCmds.DestorySSOTokenRsp
function TDestorySSOTokenRsp:init_from_obj(obj)
    self.CompletionCode = obj.CompletionCode
    self.ManufactureId = obj.ManufactureId
end

function TDestorySSOTokenRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TDestorySSOTokenRsp.group)
end

TDestorySSOTokenRsp.from_obj = TDestorySSOTokenRsp_from_obj

TDestorySSOTokenRsp.proto_property = {'CompletionCode', 'ManufactureId'}

TDestorySSOTokenRsp.default = {0, 0}

TDestorySSOTokenRsp.struct = {
    {name = 'CompletionCode', is_array = false, struct = nil}, {name = 'ManufactureId', is_array = false, struct = nil}
}

function TDestorySSOTokenRsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'CompletionCode', self.CompletionCode, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'ManufactureId', self.ManufactureId, 'uint32', false, errs, need_convert)

    TDestorySSOTokenRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TDestorySSOTokenRsp.proto_property, errs, need_convert)
    return self
end

function TDestorySSOTokenRsp:unpack(_)
    return self.CompletionCode, self.ManufactureId
end

DestorySSOToken.DestorySSOTokenRsp = TDestorySSOTokenRsp

return DestorySSOToken
