--[[-- Copyright (c) Huawei Technologies Co., Ltd. 2024. All rights reserved.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
]] --
local validate = require 'mc.validate'
local utils = require 'mc.utils'

local CheckVncPassword = {}

---@class iamIpmiCmds.CheckVncPasswordReq
---@field ManufactureId integer
---@field Reserved integer
---@field Length integer
---@field Password string
local TCheckVncPasswordReq = {}
TCheckVncPasswordReq.__index = TCheckVncPasswordReq
TCheckVncPasswordReq.group = {}

local function TCheckVncPasswordReq_from_obj(obj)
    return setmetatable(obj, TCheckVncPasswordReq)
end

function TCheckVncPasswordReq.new(ManufactureId, Reserved, Length, Password)
    return TCheckVncPasswordReq_from_obj({
        ManufactureId = ManufactureId,
        Reserved = Reserved,
        Length = Length,
        Password = Password
    })
end
---@param obj iamIpmiCmds.CheckVncPasswordReq
function TCheckVncPasswordReq:init_from_obj(obj)
    self.ManufactureId = obj.ManufactureId
    self.Reserved = obj.Reserved
    self.Length = obj.Length
    self.Password = obj.Password
end

function TCheckVncPasswordReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TCheckVncPasswordReq.group)
end

TCheckVncPasswordReq.from_obj = TCheckVncPasswordReq_from_obj

TCheckVncPasswordReq.proto_property = {'ManufactureId', 'Reserved', 'Length', 'Password'}

TCheckVncPasswordReq.default = {0, 0, 0, ''}

TCheckVncPasswordReq.struct = {
    {name = 'ManufactureId', is_array = false, struct = nil}, {name = 'Reserved', is_array = false, struct = nil},
    {name = 'Length', is_array = false, struct = nil}, {name = 'Password', is_array = false, struct = nil}
}

function TCheckVncPasswordReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'ManufactureId', self.ManufactureId, 'uint32', false, errs, need_convert)
    validate.Optional(prefix .. 'Reserved', self.Reserved, 'uint16', false, errs, need_convert)
    validate.Optional(prefix .. 'Length', self.Length, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'Password', self.Password, 'string', false, errs, need_convert)

    TCheckVncPasswordReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TCheckVncPasswordReq.proto_property, errs, need_convert)
    return self
end

function TCheckVncPasswordReq:unpack(_)
    return self.ManufactureId, self.Reserved, self.Length, self.Password
end

CheckVncPassword.CheckVncPasswordReq = TCheckVncPasswordReq

---@class iamIpmiCmds.CheckVncPasswordRsp
---@field CompletionCode integer
---@field ManufactureId integer
local TCheckVncPasswordRsp = {}
TCheckVncPasswordRsp.__index = TCheckVncPasswordRsp
TCheckVncPasswordRsp.group = {}

local function TCheckVncPasswordRsp_from_obj(obj)
    return setmetatable(obj, TCheckVncPasswordRsp)
end

function TCheckVncPasswordRsp.new(CompletionCode, ManufactureId)
    return TCheckVncPasswordRsp_from_obj({CompletionCode = CompletionCode, ManufactureId = ManufactureId})
end
---@param obj iamIpmiCmds.CheckVncPasswordRsp
function TCheckVncPasswordRsp:init_from_obj(obj)
    self.CompletionCode = obj.CompletionCode
    self.ManufactureId = obj.ManufactureId
end

function TCheckVncPasswordRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TCheckVncPasswordRsp.group)
end

TCheckVncPasswordRsp.from_obj = TCheckVncPasswordRsp_from_obj

TCheckVncPasswordRsp.proto_property = {'CompletionCode', 'ManufactureId'}

TCheckVncPasswordRsp.default = {0, 0}

TCheckVncPasswordRsp.struct = {
    {name = 'CompletionCode', is_array = false, struct = nil}, {name = 'ManufactureId', is_array = false, struct = nil}
}

function TCheckVncPasswordRsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'CompletionCode', self.CompletionCode, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'ManufactureId', self.ManufactureId, 'uint32', false, errs, need_convert)

    TCheckVncPasswordRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TCheckVncPasswordRsp.proto_property, errs, need_convert)
    return self
end

function TCheckVncPasswordRsp:unpack(_)
    return self.CompletionCode, self.ManufactureId
end

CheckVncPassword.CheckVncPasswordRsp = TCheckVncPasswordRsp

return CheckVncPassword
