-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
local validate = require 'mc.validate'
local utils = require 'mc.utils'

local MAuthentication = {}

---@class MAuthentication.Id
---@field Id integer
local TId = {}
TId.__index = TId
TId.group = {}

local function TId_from_obj(obj)
    return setmetatable(obj, TId)
end

function TId.new(Id)
    return TId_from_obj({Id = Id})
end
---@param obj MAuthentication.Id
function TId:init_from_obj(obj)
    self.Id = obj.Id
end

function TId:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TId.group)
end

TId.from_obj = TId_from_obj

TId.proto_property = {'Id'}

TId.default = {0}

TId.struct = {{name = 'Id', is_array = false, struct = nil}}

function TId:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Required(prefix .. 'Id', self.Id, 'uint8', false, errs, need_convert)

    TId:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TId.proto_property, errs, need_convert)
    return self
end

function TId:unpack(_)
    return self.Id
end

MAuthentication.Id = TId

---@class MAuthentication.CertificateAuthenticationEnable
---@field CertificateAuthenticationEnable boolean
local TCertificateAuthenticationEnable = {}
TCertificateAuthenticationEnable.__index = TCertificateAuthenticationEnable
TCertificateAuthenticationEnable.group = {}

local function TCertificateAuthenticationEnable_from_obj(obj)
    return setmetatable(obj, TCertificateAuthenticationEnable)
end

function TCertificateAuthenticationEnable.new(CertificateAuthenticationEnable)
    return TCertificateAuthenticationEnable_from_obj({
        CertificateAuthenticationEnable = CertificateAuthenticationEnable or false
    })
end
---@param obj MAuthentication.CertificateAuthenticationEnable
function TCertificateAuthenticationEnable:init_from_obj(obj)
    self.CertificateAuthenticationEnable = obj.CertificateAuthenticationEnable or false
end

function TCertificateAuthenticationEnable:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TCertificateAuthenticationEnable.group)
end

TCertificateAuthenticationEnable.from_obj = TCertificateAuthenticationEnable_from_obj

TCertificateAuthenticationEnable.proto_property = {'CertificateAuthenticationEnable'}

TCertificateAuthenticationEnable.default = {false}

TCertificateAuthenticationEnable.struct = {{name = 'CertificateAuthenticationEnable', is_array = false, struct = nil}}

function TCertificateAuthenticationEnable:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'CertificateAuthenticationEnable', self.CertificateAuthenticationEnable, 'bool', false,
        errs, need_convert)

    TCertificateAuthenticationEnable:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TCertificateAuthenticationEnable.proto_property, errs, need_convert)
    return self
end

function TCertificateAuthenticationEnable:unpack(_)
    return self.CertificateAuthenticationEnable
end

MAuthentication.CertificateAuthenticationEnable = TCertificateAuthenticationEnable

---@class MAuthentication.DoubleCertificationEnable
---@field DoubleCertificationEnable boolean
local TDoubleCertificationEnable = {}
TDoubleCertificationEnable.__index = TDoubleCertificationEnable
TDoubleCertificationEnable.group = {}

local function TDoubleCertificationEnable_from_obj(obj)
    return setmetatable(obj, TDoubleCertificationEnable)
end

function TDoubleCertificationEnable.new(DoubleCertificationEnable)
    return TDoubleCertificationEnable_from_obj({DoubleCertificationEnable = DoubleCertificationEnable or false})
end
---@param obj MAuthentication.DoubleCertificationEnable
function TDoubleCertificationEnable:init_from_obj(obj)
    self.DoubleCertificationEnable = obj.DoubleCertificationEnable or false
end

function TDoubleCertificationEnable:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TDoubleCertificationEnable.group)
end

TDoubleCertificationEnable.from_obj = TDoubleCertificationEnable_from_obj

TDoubleCertificationEnable.proto_property = {'DoubleCertificationEnable'}

TDoubleCertificationEnable.default = {false}

TDoubleCertificationEnable.struct = {{name = 'DoubleCertificationEnable', is_array = false, struct = nil}}

function TDoubleCertificationEnable:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'DoubleCertificationEnable', self.DoubleCertificationEnable, 'bool', false, errs,
        need_convert)

    TDoubleCertificationEnable:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TDoubleCertificationEnable.proto_property, errs, need_convert)
    return self
end

function TDoubleCertificationEnable:unpack(_)
    return self.DoubleCertificationEnable
end

MAuthentication.DoubleCertificationEnable = TDoubleCertificationEnable

return MAuthentication
