-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--         http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.

local lu = require 'luaunit'
local unit = require 'unit_manager.class.unit.unit'
local unit_manager = require 'unit_manager.unit_manager'
local vos = require 'utils.vos'
local c_exp_board = require 'unit_manager.class.unit.exu.exp_board'
local c_cpu_board = require 'unit_manager.class.unit.bcu.cpu_board'
local c_riser_card = require 'unit_manager.class.unit.ieu.riser_card'
local c_hdd_backplane = require 'unit_manager.class.unit.seu.hdd_backplane'
local c_fan_board = require 'unit_manager.class.unit.clu.fan_board'
local class = require 'mc.class'
local utils_core = require 'utils.core'
local utils = require 'mc.utils'

TestLogCollect = {}

function TestLogCollect:setUp()
    self.path = '/var/log'
    if not utils_core.is_dir(self.path) then
        utils.mkdir(self.path, utils.S_IRUSR | utils.S_IWUSR | utils.S_IRGRP)
    end
end

function TestLogCollect:tearDow()
    utils.remove_file(self.file_name)
end

function TestLogCollect:test_write_dfx_file()
    self.file_name = self.path .. '/dfx_info'
    local dfx_info_table = {0x00,0x01,0x02,0x03,0x04,0x05,0x06,0x07,
        0x08,0x09,0x0a,0x0b,0x0c,0x0d,0x0e,0x0f}
    local dfx_info = table.concat(dfx_info_table)
    unit:write_dfx_info(self.file_name, dfx_info, #dfx_info_table)
    lu.assertEquals(vos.get_file_accessible(self.file_name), true)
end

function TestLogCollect:test_write_card_info()
    local riser_card = class(c_riser_card)
    riser_card.mds_obj = {
        Name = 'BC83PRUI',Position = 'chassis', Manufacturer = 'Huawei',
        Slot = '1',Description = 'Riser(X8*2)', UID = '00000001040302023940',
        SerialNumber = '111',PartNumber = '0302023940', PcbVersion = '.B',
        LogicVersion = 'N/A ',SRVersion = '1.03', MultiLogicVersion = {}
    }
    local cpu_board = class(c_cpu_board)
    cpu_board.mds_obj = {
        Name = 'BC82AMDT',Position = 'BCU1', Manufacturer = 'Huawei',
        Slot = '1',Description = 'CpuBoard(1620s)', UID = '00000001020302024339',
        SerialNumber = '',PartNumber = '0302024339', PcbVersion = '.A',
        LogicVersion = '2.07',SRVersion = '1.03', MultiLogicVersion = {}
    }
    local hdd_backplane = class(c_hdd_backplane)
    hdd_backplane.mds_obj = {
        Name = 'BC83HBBA',Position = 'SEU1Front', Manufacturer = 'Huawei',
        Slot = '1',Description = '8*2.5 SAS/SATA', UID = '00000001030302023925',
        SerialNumber = '',PartNumber = '', PcbVersion = '.B',
        LogicVersion = '0.13',SRVersion = '1.03', MultiLogicVersion = {}
    }

    local header_names = {
        ['cpu_boards'] = 'CPU board Info\n',
        ['hdd_backplanes'] = 'HDD Backplane Info\n',
        ['riser_cards'] = 'Riser Card Info\n'
    }
    local obj_sets = {
        ['cpu_boards'] = {cpu_board},
        ['hdd_backplanes'] = {hdd_backplane},
        ['riser_cards'] = {riser_card}
    }

    local temp = {}
    local file = {
        write = function(_, data)
            table.insert(temp, data)
        end
    }

    for obj_set_name, header_name in pairs(header_names) do
        unit_manager:on_dump_unit_info(file, obj_sets[obj_set_name], header_name)
    end

    -- 因为pairs是无序的，所以不校验具体内容
    lu.assertEquals(#temp,  6)
end

return TestLogCollect
