-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--         http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.

local lu = require 'luaunit'
local fw_init = require 'unit_manager.class.logic_fw.fw_init'
local defs = require 'unit_manager.class.logic_fw.comm_defs'
local client = require 'general_hardware.client'
local skynet = require 'skynet'

local function get_system_id()
    return 1
end

local csr = {
    UId = "00000001030302046571",
    Name = "SEU_CPLD",
    Manufacturer = "Huawei",
    SmcChip = {},
    I2CUpgradeChip = {},
    UpgradeChip = {},
    ChipInfo = {},
    DefaultRoute = 0,
    FirmwareRoute = 4,
    SoftwareId = "CPLD-BC83NHBO",
    ComponentID = 1,
    ComponentIDEx = 0xffffffff,
    get_system_id = get_system_id,
    Version = 0
}

local obj = {Id = 'SEU_CPLD_010101'}

TestLogicalFwInit = {}

function TestLogicalFwInit:setupClass()
    self.fw_info = fw_init.new(csr, '010101', _, 'DiskBP1')
    lu.assertEquals(self.fw_info.name, 'DiskBP1 CPLD')

    client.ForeachFirmwareInfoObjects = function(_, cb)
        return cb(obj)
    end
    skynet.fork = function (cb)
        return cb()
    end
    skynet.fork_once = function (cb)
        return cb()
    end
end

-- 测试切换CPLD默认链路
function TestLogicalFwInit:test_switch_to_default_route()
    self.fw_info:switch_to_default_route()
    lu.assertEquals(self.fw_info.csr.Routes, 0)
end

-- 测试切换CPLD固件链路
function TestLogicalFwInit:test_switch_to_firmware_route()
    self.fw_info:switch_to_firmware_route()
    lu.assertEquals(self.fw_info.csr.Routes, 4)
end

-- 测试获取版本号重试
function TestLogicalFwInit:test_get_fw_version()
    -- 正常获取版本号
    fw_init.csr = {Version = 111}
    local version = fw_init:get_fw_version(defs.START_RYTRY_TIME)
    lu.assertEquals(version, '6.15')

    -- 获取版本号为0
    fw_init.csr = {Version = 0}
    version = fw_init:get_fw_version(defs.RYTRY_TIME)
    lu.assertEquals(version, '0.00')
end

function TestLogicalFwInit:test_check_update_ver()
    --正常场景
    self.fw_info.csr.Version = 1
    self.fw_info:check_update_ver()
    lu.assertEquals(self.fw_info.version, "0.01")
    lu.assertEquals(obj.Version, "0.01")

    self.fw_info.csr.Version = 2
    self.fw_info:check_update_ver()
    lu.assertEquals(self.fw_info.version, "0.02")
    lu.assertEquals(obj.Version, "0.02")
end