-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--         http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.


local lu = require 'luaunit'
local parser_cfg = require 'sr_upg_service.parser_cfg'
local utils = require 'mc.utils'

TestParserCfg = {}

local DATA_PATH <const> = './test_data/sr_upgrade/'

function TestParserCfg:test_get_cfgs()
    local cfg_path = DATA_PATH .. 'update.cfg'
    local cfgs = parser_cfg.get_cfgs(utils.realpath(cfg_path))
    lu.assertEquals(cfgs['Firmware2'], nil)
    lu.assertEquals(cfgs['Firmware1'].component_id, 17)
    lu.assertEquals(cfgs['Firmware1'].component_id_ex, 127)
    lu.assertEquals(cfgs['Firmware1'].board_id, 65535)
end