-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
--         http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.

local lu = require 'luaunit'
local retimer = require 'retimer.retimer_M88RT51632'

TestRetimer = {}

local retimer_mdb = {
    name = "retimer",
    FirmwareVersion = "",
    HealthStatus = 0,
    ChipName = "NA"
}

function TestRetimer:test_update_firmware_version()
    local obj = retimer.new(retimer_mdb, "bus_id")
    obj:update_firmware_version()
    lu.assertEquals(obj.retimer_obj.FirmwareVersion, '')
end

function TestRetimer:test_update_firmware_severity()
    local obj = retimer.new(retimer_mdb, "bus_id")
    obj:update_firmware_severity()
    lu.assertEquals(obj.retimer_obj.HealthStatus, 0)
end