-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at: http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.

local lu = require 'luaunit'
local upgrade_object = require 'mcu.upgrade.upgrade_object'
local file_sec = require 'utils.file'
local utils = require 'mc.utils'

TestUpgradeobject = {}

local mcu_obj = {
    mcu = {
        Id = 'mcu1',
        RefChip = {},
        LockChip = {},
        Protocol = {}
    },
    device_name = 'CpuBoard1',
    name = 'mcu1'
}
upgrade_object.new(mcu_obj, 1, 'OFF')

local project_dir = os.getenv('PROJECT_DIR')
local file_path = project_dir .. '/test/unit/test_data/mcu/'
local file_name = file_path .. 'mcu.bin'
-- 打桩升级文件
utils.mkdir_with_parents(file_path, utils.S_IRUSR | utils.S_IXUSR | utils.S_IRGRP | utils.S_IXGRP)
local file = file_sec.open_s(file_name, "w+")
file:write('test data')
file:close()

local old_function = {}
local function stub_upgrade_object(board_type)
    old_function.get_ref_mcu = upgrade_object.get_ref_mcu
    upgrade_object.get_ref_mcu = function ()
        return {
            get_board_type = function () return board_type end,
            interface = {
                send_upgrade_file = function () end
            }
        }
    end

    old_function.get_ref_subcomp = upgrade_object.get_ref_subcomp
    upgrade_object.get_ref_subcomp = function ()
        return {Vendor = 0, Type = 0, Delay = 10}
    end
end

-- 测试传输升级文件
function TestUpgradeobject:test_send_upgrade_file()
    stub_upgrade_object('BCU')
    local upg_prog_cb = {}
    local ok = pcall(function()
        return upgrade_object:send_upgrade_file(file_name, upg_prog_cb)
    end)

    utils.remove_file(file_name)
    lu.assertEquals(ok, true)
    upgrade_object.get_ref_mcu = old_function.get_ref_mcu
    upgrade_object.get_ref_subcomp = old_function.get_ref_subcomp
end
