-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at: http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
local lu = require 'luaunit'
local mcu_service = require 'mcu.mcu_service'

TestMcuService = {}
function TestMcuService:test_get_vrd_info()
    mcu_service.bcu_mcu_collection = {
        [1] = {
            sub_component_info_list = {
                vrd = 'test'
            },
            get_vrd_info = function(mcu_obj)
                return mcu_obj.sub_component_info_list
            end
        }
    }
    local ok, vrd_info = pcall(mcu_service.get_vrd_info, mcu_service, '010101')
    lu.assertEquals(ok, true)
    lu.assertEquals(vrd_info.vrd, 'test')
end