-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at: http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.


local lu = require 'luaunit'
local dpu_service = require 'dpu_service.dpu_service'
local client = require 'general_hardware.client'
local utils = require 'dpu_service.utils'
local g_process_res

TestDpuUpgrade = {}

local function stub_dpu_service_info(stub_name)
    client.UpdateServiceUpdateServiceProcessReply = function(_, _, _, _, result)
        g_process_res = result
    end
    client.PFileFileChown = function()
        return true
    end
    dpu_service.upgrade_task = function()
        return true
    end
    dpu_service.upgradable_cfgs = {
        name = stub_name,
        component_id = 1,
        component_id_ex = 2,
        board_id = 3
    }
end

-- 测试dpu固件升级处理成功
function TestDpuUpgrade:test_on_upgrade_process_succ()
    stub_dpu_service_info('Firmware1')
    local ok = pcall(function()
        return dpu_service:on_upgrade_process(_, _, 'Mcu', '/dev/shm/upgrade/123456/name')
    end)

    lu.assertEquals(ok, true)
    lu.assertEquals(g_process_res, utils.DBUS_CALL_CODE.RET_OK)
end

-- 测试dpu固件升级处理失败
function TestDpuUpgrade:test_on_upgrade_process_fail()
    stub_dpu_service_info(nil)
    local ok = pcall(function()
        return dpu_service:on_upgrade_process(_, _, 'Mcu', '/dev/shm/upgrade/123456/name')
    end)

    lu.assertEquals(ok, true)
    lu.assertEquals(g_process_res, utils.DBUS_CALL_CODE.RET_ERR)
end
