-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--         http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.

local skynet = require 'skynet'
local log = require 'mc.logging'
local sr_upg_service = require 'sr_upg_service.sr_upg_service'
local client = require 'general_hardware.client'
local parser_cfg = require 'sr_upg_service.parser_cfg'
local SYSTEM_ID = 1
local test_csr = {}
function test_csr.prepare_date()
    skynet.fork = function(cb)
        cb()
    end
    client.UpdateServiceUpdateServicePrepareReply = function()
        log:notice('prepare reply')
    end
    client.PFileFileChown = function()
        return true
    end
    parser_cfg.get_cfgs = function ()
        local cfgs = {}
        cfgs[1]={component_id_ex = 127}
        return cfgs
    end
end

-- 测试CSR升级prepare流程
function test_csr.test_upgrade_prepare()
    local parameters = {["ActiveMode"] = "Immediately"}
    local ok, err = pcall(sr_upg_service.on_upgrade_prepare, sr_upg_service, _, SYSTEM_ID, 'HWSR', '', _, parameters)
    assert(ok, err)
end

function test_csr.main(bus)
    log:notice('================ test csr upgrade start ================')
    test_csr.prepare_date()
    test_csr.test_upgrade_prepare()

    log:notice('================ test csr upgrade finish ================')
end

return test_csr
