-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--         http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.


local log = require 'mc.logging'
local bs = require 'mc.bitstring'
local json = require 'cjson'
local enums = require 'ipmi.enums'
local lu = require 'luaunit'
require 'skynet.manager'
local channel_type = enums.ChannelType

local test_ipmi = {}

local function ipmi_test_tool(bus, ipmi_req)
    local ipmi_package = bs.new('<<_,_:2,DestNetFn:6,_:3/unit:8,Cmd,Payload/string>>')
    local req = ipmi_package:pack(ipmi_req)
    if req then 
    end 
    local ctx = json.encode({ ChanType = channel_type.CT_ME:value(), Instance = 0 })
    local ok, rsp = pcall(bus.call, bus, 'bmc.kepler.ipmi_core', '/bmc/kepler/IpmiCore',
        'bmc.kepler.IpmiCore', 'Route', 'a{ss}ayay', require 'mc.context'.new(), req, ctx)
    return ok, rsp
end

local function test_get_cpu_power(bus)
    local GET_CPU_POWRE_RSP = '<<CompletionCode, ManuId:3/unit:8, Power:4/unit:8>>'
    local ok, rsp, data
    -- 查询CPU模组功耗
    local get_cpu_power_req = {
        DestNetFn = 0x30,
        Cmd = 0x93,
        Payload = '\xdb\x07\x00\x11\x08\x01\x00'
    }
    ok, rsp = ipmi_test_tool(bus, get_cpu_power_req)
    assert(ok, 'Call ipmi msg get cpu power failed')
    data = bs.new(GET_CPU_POWRE_RSP):unpack(rsp)
    assert(data.Power == 160) -- 打桩数据 CPU模组功耗为160
    -- 查询错误CPU模组功耗
    get_cpu_power_req = {
        DestNetFn = 0x30,
        Cmd = 0x93,
        Payload = '\xdb\x07\x00\x11\x08\x10\x00'
    }
    ok, rsp = ipmi_test_tool(bus, get_cpu_power_req)
    assert(ok, 'Call ipmi msg get cpu power failed')
    data = bs.new(GET_CPU_POWRE_RSP):unpack(rsp)
    lu.assertIsNil(data)
end

function test_ipmi.main(bus)
    log:info('================ test ipmi start ================')
    test_get_cpu_power(bus)
    log:info('================ test ipmi complete ================')
end

return test_ipmi
