-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--         http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.

local class = require 'mc.class'

local vrd_chip_object = class()

local VRD_TYPE <const> = 2

function vrd_chip_object:ctor(object, position)
    self.mds_obj = object
    self.position = position
end

local vendor_list = {'Huawei'}
function vrd_chip_object:update_vrd_info(vrd_info)
    if not vrd_info then
        return
    end
    for _, v in pairs(vrd_info) do
        local name = 'VrdChip' .. v['no']
        if self.mds_obj.Name == name and v['type'] == VRD_TYPE then
            self.mds_obj.Vendor = vendor_list[v['vendor'] + 1]
            self.mds_obj.Type = tostring(v['sku'])
            self.mds_obj.FirmwareVersion = tostring(v['major_version'])
        end
    end
end

return vrd_chip_object