-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--         http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.

local class = require 'mc.class'
local singleton = require 'mc.singleton'
local log = require 'mc.logging'
local vrd_power = require 'vrd.chip.power.vrd_power_obj'
local cmn = require 'common'

local vrd_power_service = class()

function vrd_power_service:on_add_object(class_name, object, position)
    local switch = {
        ['VrdPower'] = function()
            local power_obj = vrd_power.new(object, position)
            table.insert(self.vrd_power_table, power_obj)
        end
    }

    if switch[class_name] then
        switch[class_name]()
        log:notice('[VrdPower] Add object, class: %s, position: %s', class_name, position)
    end
end


function vrd_power_service:on_delete_object(class_name, object, position)
    local switch = {
        ['VrdPower'] = function()
            cmn.remove_ele_by_position(self.vrd_power_table, position)
        end
    }

    if switch[class_name] then
        switch[class_name]()
        log:notice('[VrdPower] Delete object, class: %s, position: %s', class_name, position)
    end
end

function vrd_power_service:get_vrd_power(system_id, cpu_id, power_type, die_id)
    for _, power_obj in pairs(self.vrd_power_table) do
        if power_obj:is_vrd_power_obj_in_cpu(system_id, cpu_id) and
            power_obj:is_vrd_power_obj_by_type(power_type, die_id) then
            return power_obj
        end
    end
    return
end

function vrd_power_service:get_vrd_powers_by_cpu(system_id, cpu_id)
    local powers = {}
    for _, power_obj in pairs(self.vrd_power_table) do
        if power_obj:is_vrd_power_obj_in_cpu(system_id, cpu_id) then
            table.insert(powers, power_obj)
        end
    end
    return powers
end

function vrd_power_service:ctor()
    self.vrd_power_table = {}
end

return singleton(vrd_power_service)