-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--         http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.


local mcu_enums = {}

mcu_enums.MCU_UPGRADE_CMD = {
    INITATE = '\x01',    -- 开始升级，命令字1
    STOP = '\x02',    -- 停止升级，命令字2
    TAKEEFFECT = '\x03',    -- 升级生效，命令字3
    SWITCH_IMAGE = '\x04',    -- 选择升级镜像，命令字4
    ROLLBACK  = '\x05',    -- 回滚，命令字5
    MCU_RESET = '\x06'    -- mcu置位，命令字6
}

mcu_enums.MCU_UPGRADE_STATUS = {
    IDLE = 0,      -- 待升级的MCU处于空闲状态,返回0
    INPROCESS = 1, -- 待升级的MCU正在升级主APP分区,返回1
    INSYNC = 2,    -- 待升级MCU暂不能升级，有可能是在同步主备分区,返回2
    FAIL = 3,       -- MCU升级失败,返回3
    INVALID_UPGRADE_STATUS = 255 -- 总线被占用，访问超时
}

mcu_enums.MCU_UPGRADE_DELAY = {
    T0 = 10,  -- 升级文件传输完到启动升级之间的等待时间10 秒
    T1 = 120  -- 启动升级到生效之间的等待时间120 秒
}

mcu_enums.SUB_COMPONENT_TYPE = {
    T_MCU = 0,  -- MCU
    T_CPLD = 1,  -- CPLD
    T_VRD = 2,  -- VRD
    T_PLL = 3,  -- PLL
    T_USBHUB = 4,  -- USBHUB
    T_VDM = 5  -- VDM
}

mcu_enums.SUB_COMPONENT_TYPE_TABLE = {
    [0] = 'MCU',
    [1] = 'CPLD',
    [2] = 'VRD',
    [3] = 'PLL',
    [4] = 'USBHUB',
    [5] = 'VDM'
}

mcu_enums.SUB_COMPONENT_BIN_SUFFIX_TABLE = {
    [0] = 'bin',
    [1] = 'vme',
    [2] = 'bin',
    [3] = 'unknown',
    [4] = 'unknown',
    [5] = 'bin'
}

mcu_enums.SUB_COMPONENT_LIB_SUFFIX_TABLE = {
    [0] = 'so',
    [1] = 'unknown',
    [2] = 'so',
    [3] = 'unknown',
    [4] = 'unknown',
    [5] = 'so'
}

mcu_enums.SMC_CALL_STATUS_CODE = {
    SUCCESS = 0,
    BUSY = 1,
    INTERNAL_ERROR = 2
}

mcu_enums.SMC_FILE_DATA_LEN = 96

-- NPU的MCU文件传输长度可以达到240btype
mcu_enums.NPU_SMC_FILE_DATA_LEN = 240

mcu_enums.SMC_CHANNEL = "SMC"
mcu_enums.SMBUS_CHANNEL = "SMBus"

mcu_enums.COMPONENT_IDEX_SDI_5_0_MCU = 16753977

mcu_enums.COMPONENT_IDEX_SDI_GD_MCU = 16754080

mcu_enums.ACTIVE_IMMEDIATELY = 0 -- 直接生效
mcu_enums.RESETAC = 1 -- 扩展板AC

return mcu_enums