-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--         http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.

local log = require 'mc.logging'
local s_pack = string.pack
local s_unpack = string.unpack

local ipmi_util = {}
ipmi_util.__index = ipmi_util

local E_OK <const> = 1
local E_FAILED <const> = -1
local MANU_ID <const> = 0xDB0700

function ipmi_util.get_manu_id()
    local bin_id = s_pack("I3", MANU_ID)
    local res = s_unpack(">I3", bin_id)
    return res
end

function ipmi_util.judge_manu_id_valid(req)
    local manu_id = ipmi_util.get_manu_id()
    if not manu_id then
        log:error("[general_hardware_app]judge_manu_id_valid:manufacture id is NULL!")
        return E_FAILED
    end

    if req.ManufactureId ~= manu_id then
        log:error("[general_hardware_app]judge_manu_id_valid:manufacture id %u(ShouldBe:%u) is invalid!",
            req.ManufactureId, manu_id)
        return E_FAILED
    end
    return E_OK
end

return ipmi_util