-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--         http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.

 
local singleton = require 'mc.singleton'
local log = require 'mc.logging'
local msg = require 'general_hardware.ipmi.ipmi_message'
local ipmi = require 'ipmi'
local cc = ipmi.types.Cc
 
local MANUFACTURE_ID<const> = 0x0007db
local LIST_END<const> = 0 -- 0表示没有后续数据
 
local dpu_ipmi = {}
dpu_ipmi.__index = dpu_ipmi
 
function dpu_ipmi:get_dpu_reset_linkage(req, ctx)
    -- 合法性检查
    if req.ManufactureId ~= MANUFACTURE_ID then
        log:error('[SDI_IPMI]request ManufactureId(%s) is invaild', req.ManufactureId)
        return msg.GetDpuResetLinkageRsp.new(cc.InvalidFieldRequest, MANUFACTURE_ID, 0, 0)
    end
    local dpu = self.dpu_service:get_dpu_obj_by_device_no(req.DeviceNo)
    if not dpu then
        log:error('[SDI_IPMI] get DPU Object by device_no(%s) fail', req.DeviceNo)
        return msg.GetDpuResetLinkageRsp.new(cc.DataNotAvailable, MANUFACTURE_ID, 0, 0)
    end
    local ok, data = dpu:get_reset_linkage()
    if not ok or data == nil then
        log:error('[SDI_IPMI]get dpu reset linkage failed, error: %s', data.linkage)
        return msg.GetDpuResetLinkageRsp.new(cc.UnspecifiedError, MANUFACTURE_ID, 0, 0)
    end
    log:notice('Get the reset linkage of PCIeCard%s(%s) successfully, reset linkage: %s',
    dpu.pciecard['SlotID'], dpu.pciecard['Name'], data.linkage)
    return msg.GetDpuResetLinkageRsp.new(cc.Success, MANUFACTURE_ID, LIST_END, data.linkage)
end
 
function dpu_ipmi.new(dpu_service)
    return setmetatable({dpu_service = dpu_service}, dpu_ipmi)
end
 
return singleton(dpu_ipmi)