-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--         http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.

local log = require 'mc.logging'
local class = require 'mc.class'
local singleton = require 'mc.singleton'
local factory = require 'factory'
local custom_msg = require 'messages.custom'
local base_messages = require 'messages.base'
local msg = require 'general_hardware.ipmi.ipmi_message'

local IPMI_SUCCESS_CODE <const> = 0x00
local MANUFACTURE_ID<const> = 0x0007db

local cpu_ipmi = class()
function cpu_ipmi:get_cpu_module_power(req, ctx)
    local rsp = msg.GetCpuModulePowerRsp.new()
    rsp.CompletionCode = IPMI_SUCCESS_CODE
    rsp.ManufactureId = MANUFACTURE_ID

    local manager = factory.get_obj("unit_manager")
    if not manager then 
        log:error("Retrieved cpu board object failed")
        error(base_messages.InternalError())
    end

    for k, v in pairs(manager.cpu_boards) do
        if req.Index == v:get_prop('Slot') then
            rsp.Power = v:get_prop('PowerWatts')
            return rsp
        end
    end
    log:error("Input index:%s can't find a matching slot number", req.Index)
    error(custom_msg.ValueOutOfRange())
end

function cpu_ipmi:ctor()
end

return singleton(cpu_ipmi)