-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
local validate = require 'mc.validate'
local utils = require 'mc.utils'
local mdb = require 'mc.mdb'

local System = {}

---@class System.SecureBootOptionEnabled
---@field SecureBootOptionEnabled boolean
local TSecureBootOptionEnabled = {}
TSecureBootOptionEnabled.__index = TSecureBootOptionEnabled
TSecureBootOptionEnabled.group = {}

local function TSecureBootOptionEnabled_from_obj(obj)
    return setmetatable(obj, TSecureBootOptionEnabled)
end

function TSecureBootOptionEnabled.new(SecureBootOptionEnabled)
    return TSecureBootOptionEnabled_from_obj({SecureBootOptionEnabled = SecureBootOptionEnabled})
end
---@param obj System.SecureBootOptionEnabled
function TSecureBootOptionEnabled:init_from_obj(obj)
    self.SecureBootOptionEnabled = obj.SecureBootOptionEnabled
end

function TSecureBootOptionEnabled:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSecureBootOptionEnabled.group)
end

TSecureBootOptionEnabled.from_obj = TSecureBootOptionEnabled_from_obj

TSecureBootOptionEnabled.proto_property = {'SecureBootOptionEnabled'}

TSecureBootOptionEnabled.default = {false}

TSecureBootOptionEnabled.struct = {{name = 'SecureBootOptionEnabled', is_array = false, struct = nil}}

function TSecureBootOptionEnabled:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'SecureBootOptionEnabled', self.SecureBootOptionEnabled, 'bool', false, errs,
        need_convert)

    TSecureBootOptionEnabled:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSecureBootOptionEnabled.proto_property, errs, need_convert)
    return self
end

function TSecureBootOptionEnabled:unpack(_)
    return self.SecureBootOptionEnabled
end

System.SecureBootOptionEnabled = TSecureBootOptionEnabled

---@class System.DiskCapacityGiB
---@field DiskCapacityGiB integer
local TDiskCapacityGiB = {}
TDiskCapacityGiB.__index = TDiskCapacityGiB
TDiskCapacityGiB.group = {}

local function TDiskCapacityGiB_from_obj(obj)
    return setmetatable(obj, TDiskCapacityGiB)
end

function TDiskCapacityGiB.new(DiskCapacityGiB)
    return TDiskCapacityGiB_from_obj({DiskCapacityGiB = DiskCapacityGiB})
end
---@param obj System.DiskCapacityGiB
function TDiskCapacityGiB:init_from_obj(obj)
    self.DiskCapacityGiB = obj.DiskCapacityGiB
end

function TDiskCapacityGiB:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TDiskCapacityGiB.group)
end

TDiskCapacityGiB.from_obj = TDiskCapacityGiB_from_obj

TDiskCapacityGiB.proto_property = {'DiskCapacityGiB'}

TDiskCapacityGiB.default = {0}

TDiskCapacityGiB.struct = {{name = 'DiskCapacityGiB', is_array = false, struct = nil}}

function TDiskCapacityGiB:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'DiskCapacityGiB', self.DiskCapacityGiB, 'uint16', true, errs, need_convert)

    TDiskCapacityGiB:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TDiskCapacityGiB.proto_property, errs, need_convert)
    return self
end

function TDiskCapacityGiB:unpack(_)
    return self.DiskCapacityGiB
end

System.DiskCapacityGiB = TDiskCapacityGiB

---@class System.MemorySizeGiB
---@field MemorySizeGiB integer
local TMemorySizeGiB = {}
TMemorySizeGiB.__index = TMemorySizeGiB
TMemorySizeGiB.group = {}

local function TMemorySizeGiB_from_obj(obj)
    return setmetatable(obj, TMemorySizeGiB)
end

function TMemorySizeGiB.new(MemorySizeGiB)
    return TMemorySizeGiB_from_obj({MemorySizeGiB = MemorySizeGiB})
end
---@param obj System.MemorySizeGiB
function TMemorySizeGiB:init_from_obj(obj)
    self.MemorySizeGiB = obj.MemorySizeGiB
end

function TMemorySizeGiB:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TMemorySizeGiB.group)
end

TMemorySizeGiB.from_obj = TMemorySizeGiB_from_obj

TMemorySizeGiB.proto_property = {'MemorySizeGiB'}

TMemorySizeGiB.default = {0}

TMemorySizeGiB.struct = {{name = 'MemorySizeGiB', is_array = false, struct = nil}}

function TMemorySizeGiB:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'MemorySizeGiB', self.MemorySizeGiB, 'uint16', true, errs, need_convert)

    TMemorySizeGiB:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TMemorySizeGiB.proto_property, errs, need_convert)
    return self
end

function TMemorySizeGiB:unpack(_)
    return self.MemorySizeGiB
end

System.MemorySizeGiB = TMemorySizeGiB

---@class System.BIOSVersion
---@field BIOSVersion string
local TBIOSVersion = {}
TBIOSVersion.__index = TBIOSVersion
TBIOSVersion.group = {}

local function TBIOSVersion_from_obj(obj)
    return setmetatable(obj, TBIOSVersion)
end

function TBIOSVersion.new(BIOSVersion)
    return TBIOSVersion_from_obj({BIOSVersion = BIOSVersion})
end
---@param obj System.BIOSVersion
function TBIOSVersion:init_from_obj(obj)
    self.BIOSVersion = obj.BIOSVersion
end

function TBIOSVersion:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TBIOSVersion.group)
end

TBIOSVersion.from_obj = TBIOSVersion_from_obj

TBIOSVersion.proto_property = {'BIOSVersion'}

TBIOSVersion.default = {''}

TBIOSVersion.struct = {{name = 'BIOSVersion', is_array = false, struct = nil}}

function TBIOSVersion:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'BIOSVersion', self.BIOSVersion, 'string', true, errs, need_convert)

    TBIOSVersion:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TBIOSVersion.proto_property, errs, need_convert)
    return self
end

function TBIOSVersion:unpack(_)
    return self.BIOSVersion
end

System.BIOSVersion = TBIOSVersion

System.interface = mdb.register_interface('bmc.kepler.Systems.DPUCard.System', {
    BIOSVersion = {'s', {}, true, nil, false},
    MemorySizeGiB = {'q', {}, true, nil, false},
    DiskCapacityGiB = {'q', {}, true, nil, false},
    SecureBootOptionEnabled = {'b', {}, false, nil, false}
}, {}, {})

return System
