-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
local validate = require 'mc.validate'
local utils = require 'mc.utils'
local mdb = require 'mc.mdb'

local Performance = {}

---@class Performance.PerformanceSamplingIntervalMinutes
---@field PerformanceSamplingIntervalMinutes integer
local TPerformanceSamplingIntervalMinutes = {}
TPerformanceSamplingIntervalMinutes.__index = TPerformanceSamplingIntervalMinutes
TPerformanceSamplingIntervalMinutes.group = {}

local function TPerformanceSamplingIntervalMinutes_from_obj(obj)
    return setmetatable(obj, TPerformanceSamplingIntervalMinutes)
end

function TPerformanceSamplingIntervalMinutes.new(PerformanceSamplingIntervalMinutes)
    return TPerformanceSamplingIntervalMinutes_from_obj({
        PerformanceSamplingIntervalMinutes = PerformanceSamplingIntervalMinutes or 1440
    })
end
---@param obj Performance.PerformanceSamplingIntervalMinutes
function TPerformanceSamplingIntervalMinutes:init_from_obj(obj)
    self.PerformanceSamplingIntervalMinutes = obj.PerformanceSamplingIntervalMinutes or 1440
end

function TPerformanceSamplingIntervalMinutes:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TPerformanceSamplingIntervalMinutes.group)
end

TPerformanceSamplingIntervalMinutes.from_obj = TPerformanceSamplingIntervalMinutes_from_obj

TPerformanceSamplingIntervalMinutes.proto_property = {'PerformanceSamplingIntervalMinutes'}

TPerformanceSamplingIntervalMinutes.default = {0}

TPerformanceSamplingIntervalMinutes.struct = {
    {name = 'PerformanceSamplingIntervalMinutes', is_array = false, struct = nil}
}

function TPerformanceSamplingIntervalMinutes:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'PerformanceSamplingIntervalMinutes', self.PerformanceSamplingIntervalMinutes, 'uint16',
        false, errs, need_convert)

    if self.PerformanceSamplingIntervalMinutes ~= nil then
        validate.ranges(prefix .. 'PerformanceSamplingIntervalMinutes', self.PerformanceSamplingIntervalMinutes, 1, nil,
            errs, need_convert)
    end

    TPerformanceSamplingIntervalMinutes:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TPerformanceSamplingIntervalMinutes.proto_property, errs, need_convert)
    return self
end

function TPerformanceSamplingIntervalMinutes:unpack(_)
    return self.PerformanceSamplingIntervalMinutes
end

Performance.PerformanceSamplingIntervalMinutes = TPerformanceSamplingIntervalMinutes

Performance.interface = mdb.register_interface('bmc.kepler.Debug.Performance', {
    PerformanceSamplingIntervalMinutes = {'q', {'EMIT_CHANGE'}, false, 1440, false}
}, {}, {})

return Performance
