-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
local validate = require 'mc.validate'
local utils = require 'mc.utils'
local mdb = require 'mc.mdb'

local JtagTarget = {}

---@class JtagTarget.BypassChannelTestRsp
---@field ResultCode boolean
local TBypassChannelTestRsp = {}
TBypassChannelTestRsp.__index = TBypassChannelTestRsp
TBypassChannelTestRsp.group = {}

local function TBypassChannelTestRsp_from_obj(obj)
    return setmetatable(obj, TBypassChannelTestRsp)
end

function TBypassChannelTestRsp.new(ResultCode)
    return TBypassChannelTestRsp_from_obj({ResultCode = ResultCode})
end
---@param obj JtagTarget.BypassChannelTestRsp
function TBypassChannelTestRsp:init_from_obj(obj)
    self.ResultCode = obj.ResultCode
end

function TBypassChannelTestRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TBypassChannelTestRsp.group)
end

TBypassChannelTestRsp.from_obj = TBypassChannelTestRsp_from_obj

TBypassChannelTestRsp.proto_property = {'ResultCode'}

TBypassChannelTestRsp.default = {false}

TBypassChannelTestRsp.struct = {{name = 'ResultCode', is_array = false, struct = nil}}

function TBypassChannelTestRsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'ResultCode', self.ResultCode, 'bool', false, errs, need_convert)

    TBypassChannelTestRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TBypassChannelTestRsp.proto_property, errs, need_convert)
    return self
end

function TBypassChannelTestRsp:unpack(_)
    return self.ResultCode
end

JtagTarget.BypassChannelTestRsp = TBypassChannelTestRsp

---@class JtagTarget.BypassChannelTestReq
---@field Id integer
---@field Channel integer
local TBypassChannelTestReq = {}
TBypassChannelTestReq.__index = TBypassChannelTestReq
TBypassChannelTestReq.group = {}

local function TBypassChannelTestReq_from_obj(obj)
    return setmetatable(obj, TBypassChannelTestReq)
end

function TBypassChannelTestReq.new(Id, Channel)
    return TBypassChannelTestReq_from_obj({Id = Id, Channel = Channel})
end
---@param obj JtagTarget.BypassChannelTestReq
function TBypassChannelTestReq:init_from_obj(obj)
    self.Id = obj.Id
    self.Channel = obj.Channel
end

function TBypassChannelTestReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TBypassChannelTestReq.group)
end

TBypassChannelTestReq.from_obj = TBypassChannelTestReq_from_obj

TBypassChannelTestReq.proto_property = {'Id', 'Channel'}

TBypassChannelTestReq.default = {0, 0}

TBypassChannelTestReq.struct = {
    {name = 'Id', is_array = false, struct = nil}, {name = 'Channel', is_array = false, struct = nil}
}

function TBypassChannelTestReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'Id', self.Id, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'Channel', self.Channel, 'uint8', false, errs, need_convert)

    TBypassChannelTestReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TBypassChannelTestReq.proto_property, errs, need_convert)
    return self
end

function TBypassChannelTestReq:unpack(_)
    return self.Id, self.Channel
end

JtagTarget.BypassChannelTestReq = TBypassChannelTestReq

---@class JtagTarget.SetBypassModeRsp
local TSetBypassModeRsp = {}
TSetBypassModeRsp.__index = TSetBypassModeRsp
TSetBypassModeRsp.group = {}

local function TSetBypassModeRsp_from_obj(obj)
    return setmetatable(obj, TSetBypassModeRsp)
end

function TSetBypassModeRsp.new()
    return TSetBypassModeRsp_from_obj({})
end
---@param obj JtagTarget.SetBypassModeRsp
function TSetBypassModeRsp:init_from_obj(obj)

end

function TSetBypassModeRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSetBypassModeRsp.group)
end

TSetBypassModeRsp.from_obj = TSetBypassModeRsp_from_obj

TSetBypassModeRsp.proto_property = {}

TSetBypassModeRsp.default = {}

TSetBypassModeRsp.struct = {}

function TSetBypassModeRsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    TSetBypassModeRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSetBypassModeRsp.proto_property, errs, need_convert)
    return self
end

function TSetBypassModeRsp:unpack(_)
end

JtagTarget.SetBypassModeRsp = TSetBypassModeRsp

---@class JtagTarget.SetBypassModeReq
---@field Enable boolean
local TSetBypassModeReq = {}
TSetBypassModeReq.__index = TSetBypassModeReq
TSetBypassModeReq.group = {}

local function TSetBypassModeReq_from_obj(obj)
    return setmetatable(obj, TSetBypassModeReq)
end

function TSetBypassModeReq.new(Enable)
    return TSetBypassModeReq_from_obj({Enable = Enable})
end
---@param obj JtagTarget.SetBypassModeReq
function TSetBypassModeReq:init_from_obj(obj)
    self.Enable = obj.Enable
end

function TSetBypassModeReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSetBypassModeReq.group)
end

TSetBypassModeReq.from_obj = TSetBypassModeReq_from_obj

TSetBypassModeReq.proto_property = {'Enable'}

TSetBypassModeReq.default = {false}

TSetBypassModeReq.struct = {{name = 'Enable', is_array = false, struct = nil}}

function TSetBypassModeReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'Enable', self.Enable, 'bool', false, errs, need_convert)

    TSetBypassModeReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSetBypassModeReq.proto_property, errs, need_convert)
    return self
end

function TSetBypassModeReq:unpack(_)
    return self.Enable
end

JtagTarget.SetBypassModeReq = TSetBypassModeReq

---@class JtagTarget.SetTargetNumberRsp
local TSetTargetNumberRsp = {}
TSetTargetNumberRsp.__index = TSetTargetNumberRsp
TSetTargetNumberRsp.group = {}

local function TSetTargetNumberRsp_from_obj(obj)
    return setmetatable(obj, TSetTargetNumberRsp)
end

function TSetTargetNumberRsp.new()
    return TSetTargetNumberRsp_from_obj({})
end
---@param obj JtagTarget.SetTargetNumberRsp
function TSetTargetNumberRsp:init_from_obj(obj)

end

function TSetTargetNumberRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSetTargetNumberRsp.group)
end

TSetTargetNumberRsp.from_obj = TSetTargetNumberRsp_from_obj

TSetTargetNumberRsp.proto_property = {}

TSetTargetNumberRsp.default = {}

TSetTargetNumberRsp.struct = {}

function TSetTargetNumberRsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    TSetTargetNumberRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSetTargetNumberRsp.proto_property, errs, need_convert)
    return self
end

function TSetTargetNumberRsp:unpack(_)
end

JtagTarget.SetTargetNumberRsp = TSetTargetNumberRsp

---@class JtagTarget.SetTargetNumberReq
---@field Num integer
local TSetTargetNumberReq = {}
TSetTargetNumberReq.__index = TSetTargetNumberReq
TSetTargetNumberReq.group = {}

local function TSetTargetNumberReq_from_obj(obj)
    return setmetatable(obj, TSetTargetNumberReq)
end

function TSetTargetNumberReq.new(Num)
    return TSetTargetNumberReq_from_obj({Num = Num})
end
---@param obj JtagTarget.SetTargetNumberReq
function TSetTargetNumberReq:init_from_obj(obj)
    self.Num = obj.Num
end

function TSetTargetNumberReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSetTargetNumberReq.group)
end

TSetTargetNumberReq.from_obj = TSetTargetNumberReq_from_obj

TSetTargetNumberReq.proto_property = {'Num'}

TSetTargetNumberReq.default = {0}

TSetTargetNumberReq.struct = {{name = 'Num', is_array = false, struct = nil}}

function TSetTargetNumberReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'Num', self.Num, 'uint32', false, errs, need_convert)

    TSetTargetNumberReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSetTargetNumberReq.proto_property, errs, need_convert)
    return self
end

function TSetTargetNumberReq:unpack(_)
    return self.Num
end

JtagTarget.SetTargetNumberReq = TSetTargetNumberReq

---@class JtagTarget.GetChipIdcodeRsp
---@field DeviceId integer[]
local TGetChipIdcodeRsp = {}
TGetChipIdcodeRsp.__index = TGetChipIdcodeRsp
TGetChipIdcodeRsp.group = {}

local function TGetChipIdcodeRsp_from_obj(obj)
    return setmetatable(obj, TGetChipIdcodeRsp)
end

function TGetChipIdcodeRsp.new(DeviceId)
    return TGetChipIdcodeRsp_from_obj({DeviceId = DeviceId})
end
---@param obj JtagTarget.GetChipIdcodeRsp
function TGetChipIdcodeRsp:init_from_obj(obj)
    self.DeviceId = obj.DeviceId
end

function TGetChipIdcodeRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TGetChipIdcodeRsp.group)
end

TGetChipIdcodeRsp.from_obj = TGetChipIdcodeRsp_from_obj

TGetChipIdcodeRsp.proto_property = {'DeviceId'}

TGetChipIdcodeRsp.default = {{}}

TGetChipIdcodeRsp.struct = {{name = 'DeviceId', is_array = true, struct = nil}}

function TGetChipIdcodeRsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.OptionalArray(prefix .. 'DeviceId', self.DeviceId, 'uint32', false, errs, need_convert)

    TGetChipIdcodeRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TGetChipIdcodeRsp.proto_property, errs, need_convert)
    return self
end

function TGetChipIdcodeRsp:unpack(_)
    return self.DeviceId
end

JtagTarget.GetChipIdcodeRsp = TGetChipIdcodeRsp

---@class JtagTarget.GetChipIdcodeReq
local TGetChipIdcodeReq = {}
TGetChipIdcodeReq.__index = TGetChipIdcodeReq
TGetChipIdcodeReq.group = {}

local function TGetChipIdcodeReq_from_obj(obj)
    return setmetatable(obj, TGetChipIdcodeReq)
end

function TGetChipIdcodeReq.new()
    return TGetChipIdcodeReq_from_obj({})
end
---@param obj JtagTarget.GetChipIdcodeReq
function TGetChipIdcodeReq:init_from_obj(obj)

end

function TGetChipIdcodeReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TGetChipIdcodeReq.group)
end

TGetChipIdcodeReq.from_obj = TGetChipIdcodeReq_from_obj

TGetChipIdcodeReq.proto_property = {}

TGetChipIdcodeReq.default = {}

TGetChipIdcodeReq.struct = {}

function TGetChipIdcodeReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    TGetChipIdcodeReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TGetChipIdcodeReq.proto_property, errs, need_convert)
    return self
end

function TGetChipIdcodeReq:unpack(_)
end

JtagTarget.GetChipIdcodeReq = TGetChipIdcodeReq

JtagTarget.interface = mdb.register_interface('bmc.kepler.Chip.JtagTarget', {}, {
    GetChipIdcode = {'a{ss}', 'au', TGetChipIdcodeReq, TGetChipIdcodeRsp},
    SetTargetNumber = {'a{ss}u', '', TSetTargetNumberReq, TSetTargetNumberRsp},
    SetBypassMode = {'a{ss}b', '', TSetBypassModeReq, TSetBypassModeRsp},
    BypassChannelTest = {'a{ss}yy', 'b', TBypassChannelTestReq, TBypassChannelTestRsp}
}, {})

return JtagTarget
