--[[-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
]] --
local validate = require 'mc.validate'
local utils = require 'mc.utils'

local SetSystemInfoParameters = {}

---@class GeneralHardwareIpmiCmds.SetSystemInfoParametersReq
---@field Data string
local TSetSystemInfoParametersReq = {}
TSetSystemInfoParametersReq.__index = TSetSystemInfoParametersReq
TSetSystemInfoParametersReq.group = {}

local function TSetSystemInfoParametersReq_from_obj(obj)
    return setmetatable(obj, TSetSystemInfoParametersReq)
end

function TSetSystemInfoParametersReq.new(Data)
    return TSetSystemInfoParametersReq_from_obj({Data = Data})
end
---@param obj GeneralHardwareIpmiCmds.SetSystemInfoParametersReq
function TSetSystemInfoParametersReq:init_from_obj(obj)
    self.Data = obj.Data
end

function TSetSystemInfoParametersReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSetSystemInfoParametersReq.group)
end

TSetSystemInfoParametersReq.from_obj = TSetSystemInfoParametersReq_from_obj

TSetSystemInfoParametersReq.proto_property = {'Data'}

TSetSystemInfoParametersReq.default = {''}

TSetSystemInfoParametersReq.struct = {{name = 'Data', is_array = false, struct = nil}}

function TSetSystemInfoParametersReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'Data', self.Data, 'string', false, errs, need_convert)

    TSetSystemInfoParametersReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSetSystemInfoParametersReq.proto_property, errs, need_convert)
    return self
end

function TSetSystemInfoParametersReq:unpack(_)
    return self.Data
end

SetSystemInfoParameters.SetSystemInfoParametersReq = TSetSystemInfoParametersReq

---@class GeneralHardwareIpmiCmds.SetSystemInfoParametersRsp
---@field CompletionCode integer
local TSetSystemInfoParametersRsp = {}
TSetSystemInfoParametersRsp.__index = TSetSystemInfoParametersRsp
TSetSystemInfoParametersRsp.group = {}

local function TSetSystemInfoParametersRsp_from_obj(obj)
    return setmetatable(obj, TSetSystemInfoParametersRsp)
end

function TSetSystemInfoParametersRsp.new(CompletionCode)
    return TSetSystemInfoParametersRsp_from_obj({CompletionCode = CompletionCode})
end
---@param obj GeneralHardwareIpmiCmds.SetSystemInfoParametersRsp
function TSetSystemInfoParametersRsp:init_from_obj(obj)
    self.CompletionCode = obj.CompletionCode
end

function TSetSystemInfoParametersRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSetSystemInfoParametersRsp.group)
end

TSetSystemInfoParametersRsp.from_obj = TSetSystemInfoParametersRsp_from_obj

TSetSystemInfoParametersRsp.proto_property = {'CompletionCode'}

TSetSystemInfoParametersRsp.default = {0}

TSetSystemInfoParametersRsp.struct = {{name = 'CompletionCode', is_array = false, struct = nil}}

function TSetSystemInfoParametersRsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'CompletionCode', self.CompletionCode, 'uint8', false, errs, need_convert)

    TSetSystemInfoParametersRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSetSystemInfoParametersRsp.proto_property, errs, need_convert)
    return self
end

function TSetSystemInfoParametersRsp:unpack(_)
    return self.CompletionCode
end

SetSystemInfoParameters.SetSystemInfoParametersRsp = TSetSystemInfoParametersRsp

return SetSystemInfoParameters
