--[[-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
]] --
local validate = require 'mc.validate'
local utils = require 'mc.utils'

local SetDpuSecureBoot = {}

---@class GeneralHardwareIpmiCmds.SetDpuSecureBootReq
---@field ManufactureId integer
---@field DeviceNo integer
---@field Offset integer
---@field SecureBoot integer
local TSetDpuSecureBootReq = {}
TSetDpuSecureBootReq.__index = TSetDpuSecureBootReq
TSetDpuSecureBootReq.group = {}

local function TSetDpuSecureBootReq_from_obj(obj)
    return setmetatable(obj, TSetDpuSecureBootReq)
end

function TSetDpuSecureBootReq.new(ManufactureId, DeviceNo, Offset, SecureBoot)
    return TSetDpuSecureBootReq_from_obj({
        ManufactureId = ManufactureId,
        DeviceNo = DeviceNo,
        Offset = Offset,
        SecureBoot = SecureBoot
    })
end
---@param obj GeneralHardwareIpmiCmds.SetDpuSecureBootReq
function TSetDpuSecureBootReq:init_from_obj(obj)
    self.ManufactureId = obj.ManufactureId
    self.DeviceNo = obj.DeviceNo
    self.Offset = obj.Offset
    self.SecureBoot = obj.SecureBoot
end

function TSetDpuSecureBootReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSetDpuSecureBootReq.group)
end

TSetDpuSecureBootReq.from_obj = TSetDpuSecureBootReq_from_obj

TSetDpuSecureBootReq.proto_property = {'ManufactureId', 'DeviceNo', 'Offset', 'SecureBoot'}

TSetDpuSecureBootReq.default = {0, 0, 0, 0}

TSetDpuSecureBootReq.struct = {
    {name = 'ManufactureId', is_array = false, struct = nil}, {name = 'DeviceNo', is_array = false, struct = nil},
    {name = 'Offset', is_array = false, struct = nil}, {name = 'SecureBoot', is_array = false, struct = nil}
}

function TSetDpuSecureBootReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'ManufactureId', self.ManufactureId, 'uint32', false, errs, need_convert)
    validate.Optional(prefix .. 'DeviceNo', self.DeviceNo, 'uint16', false, errs, need_convert)
    validate.Optional(prefix .. 'Offset', self.Offset, 'uint16', false, errs, need_convert)
    validate.Optional(prefix .. 'SecureBoot', self.SecureBoot, 'uint8', false, errs, need_convert)

    TSetDpuSecureBootReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSetDpuSecureBootReq.proto_property, errs, need_convert)
    return self
end

function TSetDpuSecureBootReq:unpack(_)
    return self.ManufactureId, self.DeviceNo, self.Offset, self.SecureBoot
end

SetDpuSecureBoot.SetDpuSecureBootReq = TSetDpuSecureBootReq

---@class GeneralHardwareIpmiCmds.SetDpuSecureBootRsp
---@field CompletionCode integer
---@field ManufactureId integer
local TSetDpuSecureBootRsp = {}
TSetDpuSecureBootRsp.__index = TSetDpuSecureBootRsp
TSetDpuSecureBootRsp.group = {}

local function TSetDpuSecureBootRsp_from_obj(obj)
    return setmetatable(obj, TSetDpuSecureBootRsp)
end

function TSetDpuSecureBootRsp.new(CompletionCode, ManufactureId)
    return TSetDpuSecureBootRsp_from_obj({CompletionCode = CompletionCode, ManufactureId = ManufactureId})
end
---@param obj GeneralHardwareIpmiCmds.SetDpuSecureBootRsp
function TSetDpuSecureBootRsp:init_from_obj(obj)
    self.CompletionCode = obj.CompletionCode
    self.ManufactureId = obj.ManufactureId
end

function TSetDpuSecureBootRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSetDpuSecureBootRsp.group)
end

TSetDpuSecureBootRsp.from_obj = TSetDpuSecureBootRsp_from_obj

TSetDpuSecureBootRsp.proto_property = {'CompletionCode', 'ManufactureId'}

TSetDpuSecureBootRsp.default = {0, 0}

TSetDpuSecureBootRsp.struct = {
    {name = 'CompletionCode', is_array = false, struct = nil}, {name = 'ManufactureId', is_array = false, struct = nil}
}

function TSetDpuSecureBootRsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'CompletionCode', self.CompletionCode, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'ManufactureId', self.ManufactureId, 'uint32', false, errs, need_convert)

    TSetDpuSecureBootRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSetDpuSecureBootRsp.proto_property, errs, need_convert)
    return self
end

function TSetDpuSecureBootRsp:unpack(_)
    return self.CompletionCode, self.ManufactureId
end

SetDpuSecureBoot.SetDpuSecureBootRsp = TSetDpuSecureBootRsp

return SetDpuSecureBoot
