--[[-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
]] --
local validate = require 'mc.validate'
local utils = require 'mc.utils'

local SetCpldChannel = {}

---@class GeneralHardwareIpmiCmds.SetCpldChannelReq
---@field ManufactureId integer
---@field ChannelType integer
---@field Tail string
local TSetCpldChannelReq = {}
TSetCpldChannelReq.__index = TSetCpldChannelReq
TSetCpldChannelReq.group = {}

local function TSetCpldChannelReq_from_obj(obj)
    return setmetatable(obj, TSetCpldChannelReq)
end

function TSetCpldChannelReq.new(ManufactureId, ChannelType, Tail)
    return TSetCpldChannelReq_from_obj({ManufactureId = ManufactureId, ChannelType = ChannelType, Tail = Tail})
end
---@param obj GeneralHardwareIpmiCmds.SetCpldChannelReq
function TSetCpldChannelReq:init_from_obj(obj)
    self.ManufactureId = obj.ManufactureId
    self.ChannelType = obj.ChannelType
    self.Tail = obj.Tail
end

function TSetCpldChannelReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSetCpldChannelReq.group)
end

TSetCpldChannelReq.from_obj = TSetCpldChannelReq_from_obj

TSetCpldChannelReq.proto_property = {'ManufactureId', 'ChannelType', 'Tail'}

TSetCpldChannelReq.default = {0, 0, ''}

TSetCpldChannelReq.struct = {
    {name = 'ManufactureId', is_array = false, struct = nil}, {name = 'ChannelType', is_array = false, struct = nil},
    {name = 'Tail', is_array = false, struct = nil}
}

function TSetCpldChannelReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'ManufactureId', self.ManufactureId, 'uint32', false, errs, need_convert)
    validate.Optional(prefix .. 'ChannelType', self.ChannelType, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'Tail', self.Tail, 'string', false, errs, need_convert)

    TSetCpldChannelReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSetCpldChannelReq.proto_property, errs, need_convert)
    return self
end

function TSetCpldChannelReq:unpack(_)
    return self.ManufactureId, self.ChannelType, self.Tail
end

SetCpldChannel.SetCpldChannelReq = TSetCpldChannelReq

---@class GeneralHardwareIpmiCmds.SetCpldChannelRsp
---@field CompletionCode integer
---@field ManufactureId integer
---@field CpldChannelValue integer
local TSetCpldChannelRsp = {}
TSetCpldChannelRsp.__index = TSetCpldChannelRsp
TSetCpldChannelRsp.group = {}

local function TSetCpldChannelRsp_from_obj(obj)
    return setmetatable(obj, TSetCpldChannelRsp)
end

function TSetCpldChannelRsp.new(CompletionCode, ManufactureId, CpldChannelValue)
    return TSetCpldChannelRsp_from_obj({
        CompletionCode = CompletionCode,
        ManufactureId = ManufactureId,
        CpldChannelValue = CpldChannelValue
    })
end
---@param obj GeneralHardwareIpmiCmds.SetCpldChannelRsp
function TSetCpldChannelRsp:init_from_obj(obj)
    self.CompletionCode = obj.CompletionCode
    self.ManufactureId = obj.ManufactureId
    self.CpldChannelValue = obj.CpldChannelValue
end

function TSetCpldChannelRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSetCpldChannelRsp.group)
end

TSetCpldChannelRsp.from_obj = TSetCpldChannelRsp_from_obj

TSetCpldChannelRsp.proto_property = {'CompletionCode', 'ManufactureId', 'CpldChannelValue'}

TSetCpldChannelRsp.default = {0, 0, 0}

TSetCpldChannelRsp.struct = {
    {name = 'CompletionCode', is_array = false, struct = nil}, {name = 'ManufactureId', is_array = false, struct = nil},
    {name = 'CpldChannelValue', is_array = false, struct = nil}
}

function TSetCpldChannelRsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'CompletionCode', self.CompletionCode, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'ManufactureId', self.ManufactureId, 'uint32', false, errs, need_convert)
    validate.Optional(prefix .. 'CpldChannelValue', self.CpldChannelValue, 'uint8', false, errs, need_convert)

    TSetCpldChannelRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSetCpldChannelRsp.proto_property, errs, need_convert)
    return self
end

function TSetCpldChannelRsp:unpack(_)
    return self.CompletionCode, self.ManufactureId, self.CpldChannelValue
end

SetCpldChannel.SetCpldChannelRsp = TSetCpldChannelRsp

return SetCpldChannel
