--[[-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
]] --
local validate = require 'mc.validate'
local utils = require 'mc.utils'

local GetDpuStorageIP = {}

---@class GeneralHardwareIpmiCmds.GetDpuStorageIPReq
---@field ManufactureId integer
---@field DeviceNo integer
---@field Offset integer
---@field Length integer
local TGetDpuStorageIPReq = {}
TGetDpuStorageIPReq.__index = TGetDpuStorageIPReq
TGetDpuStorageIPReq.group = {}

local function TGetDpuStorageIPReq_from_obj(obj)
    return setmetatable(obj, TGetDpuStorageIPReq)
end

function TGetDpuStorageIPReq.new(ManufactureId, DeviceNo, Offset, Length)
    return TGetDpuStorageIPReq_from_obj({
        ManufactureId = ManufactureId,
        DeviceNo = DeviceNo,
        Offset = Offset,
        Length = Length
    })
end
---@param obj GeneralHardwareIpmiCmds.GetDpuStorageIPReq
function TGetDpuStorageIPReq:init_from_obj(obj)
    self.ManufactureId = obj.ManufactureId
    self.DeviceNo = obj.DeviceNo
    self.Offset = obj.Offset
    self.Length = obj.Length
end

function TGetDpuStorageIPReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TGetDpuStorageIPReq.group)
end

TGetDpuStorageIPReq.from_obj = TGetDpuStorageIPReq_from_obj

TGetDpuStorageIPReq.proto_property = {'ManufactureId', 'DeviceNo', 'Offset', 'Length'}

TGetDpuStorageIPReq.default = {0, 0, 0, 0}

TGetDpuStorageIPReq.struct = {
    {name = 'ManufactureId', is_array = false, struct = nil}, {name = 'DeviceNo', is_array = false, struct = nil},
    {name = 'Offset', is_array = false, struct = nil}, {name = 'Length', is_array = false, struct = nil}
}

function TGetDpuStorageIPReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'ManufactureId', self.ManufactureId, 'uint32', false, errs, need_convert)
    validate.Optional(prefix .. 'DeviceNo', self.DeviceNo, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'Offset', self.Offset, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'Length', self.Length, 'uint8', false, errs, need_convert)

    TGetDpuStorageIPReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TGetDpuStorageIPReq.proto_property, errs, need_convert)
    return self
end

function TGetDpuStorageIPReq:unpack(_)
    return self.ManufactureId, self.DeviceNo, self.Offset, self.Length
end

GetDpuStorageIP.GetDpuStorageIPReq = TGetDpuStorageIPReq

---@class GeneralHardwareIpmiCmds.GetDpuStorageIPRsp
---@field CompletionCode integer
---@field ManufactureId integer
---@field EndOfList integer
---@field Status integer
---@field IPv4 integer
---@field VLAN integer
local TGetDpuStorageIPRsp = {}
TGetDpuStorageIPRsp.__index = TGetDpuStorageIPRsp
TGetDpuStorageIPRsp.group = {}

local function TGetDpuStorageIPRsp_from_obj(obj)
    return setmetatable(obj, TGetDpuStorageIPRsp)
end

function TGetDpuStorageIPRsp.new(CompletionCode, ManufactureId, EndOfList, Status, IPv4, VLAN)
    return TGetDpuStorageIPRsp_from_obj({
        CompletionCode = CompletionCode,
        ManufactureId = ManufactureId,
        EndOfList = EndOfList,
        Status = Status,
        IPv4 = IPv4,
        VLAN = VLAN
    })
end
---@param obj GeneralHardwareIpmiCmds.GetDpuStorageIPRsp
function TGetDpuStorageIPRsp:init_from_obj(obj)
    self.CompletionCode = obj.CompletionCode
    self.ManufactureId = obj.ManufactureId
    self.EndOfList = obj.EndOfList
    self.Status = obj.Status
    self.IPv4 = obj.IPv4
    self.VLAN = obj.VLAN
end

function TGetDpuStorageIPRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TGetDpuStorageIPRsp.group)
end

TGetDpuStorageIPRsp.from_obj = TGetDpuStorageIPRsp_from_obj

TGetDpuStorageIPRsp.proto_property = {'CompletionCode', 'ManufactureId', 'EndOfList', 'Status', 'IPv4', 'VLAN'}

TGetDpuStorageIPRsp.default = {0, 0, 0, 0, 0, 0}

TGetDpuStorageIPRsp.struct = {
    {name = 'CompletionCode', is_array = false, struct = nil}, {name = 'ManufactureId', is_array = false, struct = nil},
    {name = 'EndOfList', is_array = false, struct = nil}, {name = 'Status', is_array = false, struct = nil},
    {name = 'IPv4', is_array = false, struct = nil}, {name = 'VLAN', is_array = false, struct = nil}
}

function TGetDpuStorageIPRsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'CompletionCode', self.CompletionCode, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'ManufactureId', self.ManufactureId, 'uint32', false, errs, need_convert)
    validate.Optional(prefix .. 'EndOfList', self.EndOfList, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'Status', self.Status, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'IPv4', self.IPv4, 'uint32', false, errs, need_convert)
    validate.Optional(prefix .. 'VLAN', self.VLAN, 'uint16', false, errs, need_convert)

    TGetDpuStorageIPRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TGetDpuStorageIPRsp.proto_property, errs, need_convert)
    return self
end

function TGetDpuStorageIPRsp:unpack(_)
    return self.CompletionCode, self.ManufactureId, self.EndOfList, self.Status, self.IPv4, self.VLAN
end

GetDpuStorageIP.GetDpuStorageIPRsp = TGetDpuStorageIPRsp

return GetDpuStorageIP
