--[[-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
]] --
local validate = require 'mc.validate'
local utils = require 'mc.utils'

local GetDpuResetLinkage = {}

---@class GeneralHardwareIpmiCmds.GetDpuResetLinkageReq
---@field ManufactureId integer
---@field DeviceNo integer
---@field Offset integer
---@field Length integer
local TGetDpuResetLinkageReq = {}
TGetDpuResetLinkageReq.__index = TGetDpuResetLinkageReq
TGetDpuResetLinkageReq.group = {}

local function TGetDpuResetLinkageReq_from_obj(obj)
    return setmetatable(obj, TGetDpuResetLinkageReq)
end

function TGetDpuResetLinkageReq.new(ManufactureId, DeviceNo, Offset, Length)
    return TGetDpuResetLinkageReq_from_obj({
        ManufactureId = ManufactureId,
        DeviceNo = DeviceNo,
        Offset = Offset,
        Length = Length
    })
end
---@param obj GeneralHardwareIpmiCmds.GetDpuResetLinkageReq
function TGetDpuResetLinkageReq:init_from_obj(obj)
    self.ManufactureId = obj.ManufactureId
    self.DeviceNo = obj.DeviceNo
    self.Offset = obj.Offset
    self.Length = obj.Length
end

function TGetDpuResetLinkageReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TGetDpuResetLinkageReq.group)
end

TGetDpuResetLinkageReq.from_obj = TGetDpuResetLinkageReq_from_obj

TGetDpuResetLinkageReq.proto_property = {'ManufactureId', 'DeviceNo', 'Offset', 'Length'}

TGetDpuResetLinkageReq.default = {0, 0, 0, 0}

TGetDpuResetLinkageReq.struct = {
    {name = 'ManufactureId', is_array = false, struct = nil}, {name = 'DeviceNo', is_array = false, struct = nil},
    {name = 'Offset', is_array = false, struct = nil}, {name = 'Length', is_array = false, struct = nil}
}

function TGetDpuResetLinkageReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'ManufactureId', self.ManufactureId, 'uint32', false, errs, need_convert)
    validate.Optional(prefix .. 'DeviceNo', self.DeviceNo, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'Offset', self.Offset, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'Length', self.Length, 'uint8', false, errs, need_convert)

    TGetDpuResetLinkageReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TGetDpuResetLinkageReq.proto_property, errs, need_convert)
    return self
end

function TGetDpuResetLinkageReq:unpack(_)
    return self.ManufactureId, self.DeviceNo, self.Offset, self.Length
end

GetDpuResetLinkage.GetDpuResetLinkageReq = TGetDpuResetLinkageReq

---@class GeneralHardwareIpmiCmds.GetDpuResetLinkageRsp
---@field CompletionCode integer
---@field ManufactureId integer
---@field EndOfList integer
---@field ResetLinkage integer
local TGetDpuResetLinkageRsp = {}
TGetDpuResetLinkageRsp.__index = TGetDpuResetLinkageRsp
TGetDpuResetLinkageRsp.group = {}

local function TGetDpuResetLinkageRsp_from_obj(obj)
    return setmetatable(obj, TGetDpuResetLinkageRsp)
end

function TGetDpuResetLinkageRsp.new(CompletionCode, ManufactureId, EndOfList, ResetLinkage)
    return TGetDpuResetLinkageRsp_from_obj({
        CompletionCode = CompletionCode,
        ManufactureId = ManufactureId,
        EndOfList = EndOfList,
        ResetLinkage = ResetLinkage
    })
end
---@param obj GeneralHardwareIpmiCmds.GetDpuResetLinkageRsp
function TGetDpuResetLinkageRsp:init_from_obj(obj)
    self.CompletionCode = obj.CompletionCode
    self.ManufactureId = obj.ManufactureId
    self.EndOfList = obj.EndOfList
    self.ResetLinkage = obj.ResetLinkage
end

function TGetDpuResetLinkageRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TGetDpuResetLinkageRsp.group)
end

TGetDpuResetLinkageRsp.from_obj = TGetDpuResetLinkageRsp_from_obj

TGetDpuResetLinkageRsp.proto_property = {'CompletionCode', 'ManufactureId', 'EndOfList', 'ResetLinkage'}

TGetDpuResetLinkageRsp.default = {0, 0, 0, 0}

TGetDpuResetLinkageRsp.struct = {
    {name = 'CompletionCode', is_array = false, struct = nil}, {name = 'ManufactureId', is_array = false, struct = nil},
    {name = 'EndOfList', is_array = false, struct = nil}, {name = 'ResetLinkage', is_array = false, struct = nil}
}

function TGetDpuResetLinkageRsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'CompletionCode', self.CompletionCode, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'ManufactureId', self.ManufactureId, 'uint32', false, errs, need_convert)
    validate.Optional(prefix .. 'EndOfList', self.EndOfList, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'ResetLinkage', self.ResetLinkage, 'uint8', false, errs, need_convert)

    TGetDpuResetLinkageRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TGetDpuResetLinkageRsp.proto_property, errs, need_convert)
    return self
end

function TGetDpuResetLinkageRsp:unpack(_)
    return self.CompletionCode, self.ManufactureId, self.EndOfList, self.ResetLinkage
end

GetDpuResetLinkage.GetDpuResetLinkageRsp = TGetDpuResetLinkageRsp

return GetDpuResetLinkage
