--[[-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
]] --
local validate = require 'mc.validate'
local utils = require 'mc.utils'

local GetDpuPxeOption = {}

---@class GeneralHardwareIpmiCmds.GetDpuPxeOptionReq
---@field ManufactureId integer
---@field DeviceNo integer
---@field Offset integer
---@field Length integer
local TGetDpuPxeOptionReq = {}
TGetDpuPxeOptionReq.__index = TGetDpuPxeOptionReq
TGetDpuPxeOptionReq.group = {}

local function TGetDpuPxeOptionReq_from_obj(obj)
    return setmetatable(obj, TGetDpuPxeOptionReq)
end

function TGetDpuPxeOptionReq.new(ManufactureId, DeviceNo, Offset, Length)
    return TGetDpuPxeOptionReq_from_obj({
        ManufactureId = ManufactureId,
        DeviceNo = DeviceNo,
        Offset = Offset,
        Length = Length
    })
end
---@param obj GeneralHardwareIpmiCmds.GetDpuPxeOptionReq
function TGetDpuPxeOptionReq:init_from_obj(obj)
    self.ManufactureId = obj.ManufactureId
    self.DeviceNo = obj.DeviceNo
    self.Offset = obj.Offset
    self.Length = obj.Length
end

function TGetDpuPxeOptionReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TGetDpuPxeOptionReq.group)
end

TGetDpuPxeOptionReq.from_obj = TGetDpuPxeOptionReq_from_obj

TGetDpuPxeOptionReq.proto_property = {'ManufactureId', 'DeviceNo', 'Offset', 'Length'}

TGetDpuPxeOptionReq.default = {0, 0, 0, 0}

TGetDpuPxeOptionReq.struct = {
    {name = 'ManufactureId', is_array = false, struct = nil}, {name = 'DeviceNo', is_array = false, struct = nil},
    {name = 'Offset', is_array = false, struct = nil}, {name = 'Length', is_array = false, struct = nil}
}

function TGetDpuPxeOptionReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'ManufactureId', self.ManufactureId, 'uint32', false, errs, need_convert)
    validate.Optional(prefix .. 'DeviceNo', self.DeviceNo, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'Offset', self.Offset, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'Length', self.Length, 'uint8', false, errs, need_convert)

    TGetDpuPxeOptionReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TGetDpuPxeOptionReq.proto_property, errs, need_convert)
    return self
end

function TGetDpuPxeOptionReq:unpack(_)
    return self.ManufactureId, self.DeviceNo, self.Offset, self.Length
end

GetDpuPxeOption.GetDpuPxeOptionReq = TGetDpuPxeOptionReq

---@class GeneralHardwareIpmiCmds.GetDpuPxeOptionRsp
---@field CompletionCode integer
---@field ManufactureId integer
---@field EndOfList integer
---@field PxeOption integer
local TGetDpuPxeOptionRsp = {}
TGetDpuPxeOptionRsp.__index = TGetDpuPxeOptionRsp
TGetDpuPxeOptionRsp.group = {}

local function TGetDpuPxeOptionRsp_from_obj(obj)
    return setmetatable(obj, TGetDpuPxeOptionRsp)
end

function TGetDpuPxeOptionRsp.new(CompletionCode, ManufactureId, EndOfList, PxeOption)
    return TGetDpuPxeOptionRsp_from_obj({
        CompletionCode = CompletionCode,
        ManufactureId = ManufactureId,
        EndOfList = EndOfList,
        PxeOption = PxeOption
    })
end
---@param obj GeneralHardwareIpmiCmds.GetDpuPxeOptionRsp
function TGetDpuPxeOptionRsp:init_from_obj(obj)
    self.CompletionCode = obj.CompletionCode
    self.ManufactureId = obj.ManufactureId
    self.EndOfList = obj.EndOfList
    self.PxeOption = obj.PxeOption
end

function TGetDpuPxeOptionRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TGetDpuPxeOptionRsp.group)
end

TGetDpuPxeOptionRsp.from_obj = TGetDpuPxeOptionRsp_from_obj

TGetDpuPxeOptionRsp.proto_property = {'CompletionCode', 'ManufactureId', 'EndOfList', 'PxeOption'}

TGetDpuPxeOptionRsp.default = {0, 0, 0, 0}

TGetDpuPxeOptionRsp.struct = {
    {name = 'CompletionCode', is_array = false, struct = nil}, {name = 'ManufactureId', is_array = false, struct = nil},
    {name = 'EndOfList', is_array = false, struct = nil}, {name = 'PxeOption', is_array = false, struct = nil}
}

function TGetDpuPxeOptionRsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'CompletionCode', self.CompletionCode, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'ManufactureId', self.ManufactureId, 'uint32', false, errs, need_convert)
    validate.Optional(prefix .. 'EndOfList', self.EndOfList, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'PxeOption', self.PxeOption, 'uint8', false, errs, need_convert)

    TGetDpuPxeOptionRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TGetDpuPxeOptionRsp.proto_property, errs, need_convert)
    return self
end

function TGetDpuPxeOptionRsp:unpack(_)
    return self.CompletionCode, self.ManufactureId, self.EndOfList, self.PxeOption
end

GetDpuPxeOption.GetDpuPxeOptionRsp = TGetDpuPxeOptionRsp

return GetDpuPxeOption
