--[[-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
]] --
local validate = require 'mc.validate'
local utils = require 'mc.utils'

local GetDpuBootOption = {}

---@class GeneralHardwareIpmiCmds.GetDpuBootOptionReq
---@field ManufactureId integer
---@field DeviceNo integer
---@field Offset integer
---@field Length integer
local TGetDpuBootOptionReq = {}
TGetDpuBootOptionReq.__index = TGetDpuBootOptionReq
TGetDpuBootOptionReq.group = {}

local function TGetDpuBootOptionReq_from_obj(obj)
    return setmetatable(obj, TGetDpuBootOptionReq)
end

function TGetDpuBootOptionReq.new(ManufactureId, DeviceNo, Offset, Length)
    return TGetDpuBootOptionReq_from_obj({
        ManufactureId = ManufactureId,
        DeviceNo = DeviceNo,
        Offset = Offset,
        Length = Length
    })
end
---@param obj GeneralHardwareIpmiCmds.GetDpuBootOptionReq
function TGetDpuBootOptionReq:init_from_obj(obj)
    self.ManufactureId = obj.ManufactureId
    self.DeviceNo = obj.DeviceNo
    self.Offset = obj.Offset
    self.Length = obj.Length
end

function TGetDpuBootOptionReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TGetDpuBootOptionReq.group)
end

TGetDpuBootOptionReq.from_obj = TGetDpuBootOptionReq_from_obj

TGetDpuBootOptionReq.proto_property = {'ManufactureId', 'DeviceNo', 'Offset', 'Length'}

TGetDpuBootOptionReq.default = {0, 0, 0, 0}

TGetDpuBootOptionReq.struct = {
    {name = 'ManufactureId', is_array = false, struct = nil}, {name = 'DeviceNo', is_array = false, struct = nil},
    {name = 'Offset', is_array = false, struct = nil}, {name = 'Length', is_array = false, struct = nil}
}

function TGetDpuBootOptionReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'ManufactureId', self.ManufactureId, 'uint32', false, errs, need_convert)
    validate.Optional(prefix .. 'DeviceNo', self.DeviceNo, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'Offset', self.Offset, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'Length', self.Length, 'uint8', false, errs, need_convert)

    TGetDpuBootOptionReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TGetDpuBootOptionReq.proto_property, errs, need_convert)
    return self
end

function TGetDpuBootOptionReq:unpack(_)
    return self.ManufactureId, self.DeviceNo, self.Offset, self.Length
end

GetDpuBootOption.GetDpuBootOptionReq = TGetDpuBootOptionReq

---@class GeneralHardwareIpmiCmds.GetDpuBootOptionRsp
---@field CompletionCode integer
---@field ManufactureId integer
---@field EndOfList integer
---@field BootOrder integer
---@field BootValidType integer
local TGetDpuBootOptionRsp = {}
TGetDpuBootOptionRsp.__index = TGetDpuBootOptionRsp
TGetDpuBootOptionRsp.group = {}

local function TGetDpuBootOptionRsp_from_obj(obj)
    return setmetatable(obj, TGetDpuBootOptionRsp)
end

function TGetDpuBootOptionRsp.new(CompletionCode, ManufactureId, EndOfList, BootOrder, BootValidType)
    return TGetDpuBootOptionRsp_from_obj({
        CompletionCode = CompletionCode,
        ManufactureId = ManufactureId,
        EndOfList = EndOfList,
        BootOrder = BootOrder,
        BootValidType = BootValidType
    })
end
---@param obj GeneralHardwareIpmiCmds.GetDpuBootOptionRsp
function TGetDpuBootOptionRsp:init_from_obj(obj)
    self.CompletionCode = obj.CompletionCode
    self.ManufactureId = obj.ManufactureId
    self.EndOfList = obj.EndOfList
    self.BootOrder = obj.BootOrder
    self.BootValidType = obj.BootValidType
end

function TGetDpuBootOptionRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TGetDpuBootOptionRsp.group)
end

TGetDpuBootOptionRsp.from_obj = TGetDpuBootOptionRsp_from_obj

TGetDpuBootOptionRsp.proto_property = {'CompletionCode', 'ManufactureId', 'EndOfList', 'BootOrder', 'BootValidType'}

TGetDpuBootOptionRsp.default = {0, 0, 0, 0, 0}

TGetDpuBootOptionRsp.struct = {
    {name = 'CompletionCode', is_array = false, struct = nil}, {name = 'ManufactureId', is_array = false, struct = nil},
    {name = 'EndOfList', is_array = false, struct = nil}, {name = 'BootOrder', is_array = false, struct = nil},
    {name = 'BootValidType', is_array = false, struct = nil}
}

function TGetDpuBootOptionRsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'CompletionCode', self.CompletionCode, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'ManufactureId', self.ManufactureId, 'uint32', false, errs, need_convert)
    validate.Optional(prefix .. 'EndOfList', self.EndOfList, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'BootOrder', self.BootOrder, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'BootValidType', self.BootValidType, 'uint8', false, errs, need_convert)

    TGetDpuBootOptionRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TGetDpuBootOptionRsp.proto_property, errs, need_convert)
    return self
end

function TGetDpuBootOptionRsp:unpack(_)
    return self.CompletionCode, self.ManufactureId, self.EndOfList, self.BootOrder, self.BootValidType
end

GetDpuBootOption.GetDpuBootOptionRsp = TGetDpuBootOptionRsp

return GetDpuBootOption
