--[[-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
]] --
local validate = require 'mc.validate'
local utils = require 'mc.utils'

local GetDpuBiosLogLevel = {}

---@class GeneralHardwareIpmiCmds.GetDpuBiosLogLevelReq
---@field ManufactureId integer
---@field DeviceNo integer
local TGetDpuBiosLogLevelReq = {}
TGetDpuBiosLogLevelReq.__index = TGetDpuBiosLogLevelReq
TGetDpuBiosLogLevelReq.group = {}

local function TGetDpuBiosLogLevelReq_from_obj(obj)
    return setmetatable(obj, TGetDpuBiosLogLevelReq)
end

function TGetDpuBiosLogLevelReq.new(ManufactureId, DeviceNo)
    return TGetDpuBiosLogLevelReq_from_obj({ManufactureId = ManufactureId, DeviceNo = DeviceNo})
end
---@param obj GeneralHardwareIpmiCmds.GetDpuBiosLogLevelReq
function TGetDpuBiosLogLevelReq:init_from_obj(obj)
    self.ManufactureId = obj.ManufactureId
    self.DeviceNo = obj.DeviceNo
end

function TGetDpuBiosLogLevelReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TGetDpuBiosLogLevelReq.group)
end

TGetDpuBiosLogLevelReq.from_obj = TGetDpuBiosLogLevelReq_from_obj

TGetDpuBiosLogLevelReq.proto_property = {'ManufactureId', 'DeviceNo'}

TGetDpuBiosLogLevelReq.default = {0, 0}

TGetDpuBiosLogLevelReq.struct = {
    {name = 'ManufactureId', is_array = false, struct = nil}, {name = 'DeviceNo', is_array = false, struct = nil}
}

function TGetDpuBiosLogLevelReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'ManufactureId', self.ManufactureId, 'uint32', false, errs, need_convert)
    validate.Optional(prefix .. 'DeviceNo', self.DeviceNo, 'uint8', false, errs, need_convert)

    TGetDpuBiosLogLevelReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TGetDpuBiosLogLevelReq.proto_property, errs, need_convert)
    return self
end

function TGetDpuBiosLogLevelReq:unpack(_)
    return self.ManufactureId, self.DeviceNo
end

GetDpuBiosLogLevel.GetDpuBiosLogLevelReq = TGetDpuBiosLogLevelReq

---@class GeneralHardwareIpmiCmds.GetDpuBiosLogLevelRsp
---@field CompletionCode integer
---@field ManufactureId integer
---@field EndOfList integer
---@field MRC integer
---@field UEFI integer
local TGetDpuBiosLogLevelRsp = {}
TGetDpuBiosLogLevelRsp.__index = TGetDpuBiosLogLevelRsp
TGetDpuBiosLogLevelRsp.group = {}

local function TGetDpuBiosLogLevelRsp_from_obj(obj)
    return setmetatable(obj, TGetDpuBiosLogLevelRsp)
end

function TGetDpuBiosLogLevelRsp.new(CompletionCode, ManufactureId, EndOfList, MRC, UEFI)
    return TGetDpuBiosLogLevelRsp_from_obj({
        CompletionCode = CompletionCode,
        ManufactureId = ManufactureId,
        EndOfList = EndOfList,
        MRC = MRC,
        UEFI = UEFI
    })
end
---@param obj GeneralHardwareIpmiCmds.GetDpuBiosLogLevelRsp
function TGetDpuBiosLogLevelRsp:init_from_obj(obj)
    self.CompletionCode = obj.CompletionCode
    self.ManufactureId = obj.ManufactureId
    self.EndOfList = obj.EndOfList
    self.MRC = obj.MRC
    self.UEFI = obj.UEFI
end

function TGetDpuBiosLogLevelRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TGetDpuBiosLogLevelRsp.group)
end

TGetDpuBiosLogLevelRsp.from_obj = TGetDpuBiosLogLevelRsp_from_obj

TGetDpuBiosLogLevelRsp.proto_property = {'CompletionCode', 'ManufactureId', 'EndOfList', 'MRC', 'UEFI'}

TGetDpuBiosLogLevelRsp.default = {0, 0, 0, 0, 0}

TGetDpuBiosLogLevelRsp.struct = {
    {name = 'CompletionCode', is_array = false, struct = nil}, {name = 'ManufactureId', is_array = false, struct = nil},
    {name = 'EndOfList', is_array = false, struct = nil}, {name = 'MRC', is_array = false, struct = nil},
    {name = 'UEFI', is_array = false, struct = nil}
}

function TGetDpuBiosLogLevelRsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'CompletionCode', self.CompletionCode, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'ManufactureId', self.ManufactureId, 'uint32', false, errs, need_convert)
    validate.Optional(prefix .. 'EndOfList', self.EndOfList, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'MRC', self.MRC, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'UEFI', self.UEFI, 'uint8', false, errs, need_convert)

    TGetDpuBiosLogLevelRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TGetDpuBiosLogLevelRsp.proto_property, errs, need_convert)
    return self
end

function TGetDpuBiosLogLevelRsp:unpack(_)
    return self.CompletionCode, self.ManufactureId, self.EndOfList, self.MRC, self.UEFI
end

GetDpuBiosLogLevel.GetDpuBiosLogLevelRsp = TGetDpuBiosLogLevelRsp

return GetDpuBiosLogLevel
