-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
local validate = require 'mc.validate'
local utils = require 'mc.utils'

local MDftHwChannel = {}

---@class MDftHwChannel.Operator
---@field Operator integer
local TOperator = {}
TOperator.__index = TOperator
TOperator.group = {}

local function TOperator_from_obj(obj)
    return setmetatable(obj, TOperator)
end

function TOperator.new(Operator)
    return TOperator_from_obj({Operator = Operator})
end
---@param obj MDftHwChannel.Operator
function TOperator:init_from_obj(obj)
    self.Operator = obj.Operator
end

function TOperator:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TOperator.group)
end

TOperator.from_obj = TOperator_from_obj

TOperator.proto_property = {'Operator'}

TOperator.default = {0}

TOperator.struct = {{name = 'Operator', is_array = false, struct = nil}}

function TOperator:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'Operator', self.Operator, 'uint8', false, errs, need_convert)

    TOperator:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TOperator.proto_property, errs, need_convert)
    return self
end

function TOperator:unpack(_)
    return self.Operator
end

MDftHwChannel.Operator = TOperator

---@class MDftHwChannel.SleepTime
---@field SleepTime integer
local TSleepTime = {}
TSleepTime.__index = TSleepTime
TSleepTime.group = {}

local function TSleepTime_from_obj(obj)
    return setmetatable(obj, TSleepTime)
end

function TSleepTime.new(SleepTime)
    return TSleepTime_from_obj({SleepTime = SleepTime or 10})
end
---@param obj MDftHwChannel.SleepTime
function TSleepTime:init_from_obj(obj)
    self.SleepTime = obj.SleepTime or 10
end

function TSleepTime:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSleepTime.group)
end

TSleepTime.from_obj = TSleepTime_from_obj

TSleepTime.proto_property = {'SleepTime'}

TSleepTime.default = {0}

TSleepTime.struct = {{name = 'SleepTime', is_array = false, struct = nil}}

function TSleepTime:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'SleepTime', self.SleepTime, 'uint16', false, errs, need_convert)

    TSleepTime:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSleepTime.proto_property, errs, need_convert)
    return self
end

function TSleepTime:unpack(_)
    return self.SleepTime
end

MDftHwChannel.SleepTime = TSleepTime

---@class MDftHwChannel.InputMask
---@field InputMask integer[]
local TInputMask = {}
TInputMask.__index = TInputMask
TInputMask.group = {}

local function TInputMask_from_obj(obj)
    return setmetatable(obj, TInputMask)
end

function TInputMask.new(InputMask)
    return TInputMask_from_obj({InputMask = InputMask})
end
---@param obj MDftHwChannel.InputMask
function TInputMask:init_from_obj(obj)
    self.InputMask = obj.InputMask
end

function TInputMask:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TInputMask.group)
end

TInputMask.from_obj = TInputMask_from_obj

TInputMask.proto_property = {'InputMask'}

TInputMask.default = {{}}

TInputMask.struct = {{name = 'InputMask', is_array = true, struct = nil}}

function TInputMask:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.OptionalArray(prefix .. 'InputMask', self.InputMask, 'uint8', false, errs, need_convert)

    TInputMask:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TInputMask.proto_property, errs, need_convert)
    return self
end

function TInputMask:unpack(_)
    return self.InputMask
end

MDftHwChannel.InputMask = TInputMask

---@class MDftHwChannel.OutputOffset
---@field OutputOffset integer
local TOutputOffset = {}
TOutputOffset.__index = TOutputOffset
TOutputOffset.group = {}

local function TOutputOffset_from_obj(obj)
    return setmetatable(obj, TOutputOffset)
end

function TOutputOffset.new(OutputOffset)
    return TOutputOffset_from_obj({OutputOffset = OutputOffset})
end
---@param obj MDftHwChannel.OutputOffset
function TOutputOffset:init_from_obj(obj)
    self.OutputOffset = obj.OutputOffset
end

function TOutputOffset:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TOutputOffset.group)
end

TOutputOffset.from_obj = TOutputOffset_from_obj

TOutputOffset.proto_property = {'OutputOffset'}

TOutputOffset.default = {0}

TOutputOffset.struct = {{name = 'OutputOffset', is_array = false, struct = nil}}

function TOutputOffset:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'OutputOffset', self.OutputOffset, 'uint32', false, errs, need_convert)

    TOutputOffset:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TOutputOffset.proto_property, errs, need_convert)
    return self
end

function TOutputOffset:unpack(_)
    return self.OutputOffset
end

MDftHwChannel.OutputOffset = TOutputOffset

---@class MDftHwChannel.InputOffset
---@field InputOffset integer
local TInputOffset = {}
TInputOffset.__index = TInputOffset
TInputOffset.group = {}

local function TInputOffset_from_obj(obj)
    return setmetatable(obj, TInputOffset)
end

function TInputOffset.new(InputOffset)
    return TInputOffset_from_obj({InputOffset = InputOffset})
end
---@param obj MDftHwChannel.InputOffset
function TInputOffset:init_from_obj(obj)
    self.InputOffset = obj.InputOffset
end

function TInputOffset:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TInputOffset.group)
end

TInputOffset.from_obj = TInputOffset_from_obj

TInputOffset.proto_property = {'InputOffset'}

TInputOffset.default = {0}

TInputOffset.struct = {{name = 'InputOffset', is_array = false, struct = nil}}

function TInputOffset:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'InputOffset', self.InputOffset, 'uint32', false, errs, need_convert)

    TInputOffset:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TInputOffset.proto_property, errs, need_convert)
    return self
end

function TInputOffset:unpack(_)
    return self.InputOffset
end

MDftHwChannel.InputOffset = TInputOffset

---@class MDftHwChannel.OutputSize
---@field OutputSize integer
local TOutputSize = {}
TOutputSize.__index = TOutputSize
TOutputSize.group = {}

local function TOutputSize_from_obj(obj)
    return setmetatable(obj, TOutputSize)
end

function TOutputSize.new(OutputSize)
    return TOutputSize_from_obj({OutputSize = OutputSize})
end
---@param obj MDftHwChannel.OutputSize
function TOutputSize:init_from_obj(obj)
    self.OutputSize = obj.OutputSize
end

function TOutputSize:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TOutputSize.group)
end

TOutputSize.from_obj = TOutputSize_from_obj

TOutputSize.proto_property = {'OutputSize'}

TOutputSize.default = {0}

TOutputSize.struct = {{name = 'OutputSize', is_array = false, struct = nil}}

function TOutputSize:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'OutputSize', self.OutputSize, 'uint8', false, errs, need_convert)

    TOutputSize:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TOutputSize.proto_property, errs, need_convert)
    return self
end

function TOutputSize:unpack(_)
    return self.OutputSize
end

MDftHwChannel.OutputSize = TOutputSize

---@class MDftHwChannel.InputSize
---@field InputSize integer
local TInputSize = {}
TInputSize.__index = TInputSize
TInputSize.group = {}

local function TInputSize_from_obj(obj)
    return setmetatable(obj, TInputSize)
end

function TInputSize.new(InputSize)
    return TInputSize_from_obj({InputSize = InputSize})
end
---@param obj MDftHwChannel.InputSize
function TInputSize:init_from_obj(obj)
    self.InputSize = obj.InputSize
end

function TInputSize:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TInputSize.group)
end

TInputSize.from_obj = TInputSize_from_obj

TInputSize.proto_property = {'InputSize'}

TInputSize.default = {0}

TInputSize.struct = {{name = 'InputSize', is_array = false, struct = nil}}

function TInputSize:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'InputSize', self.InputSize, 'uint8', false, errs, need_convert)

    TInputSize:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TInputSize.proto_property, errs, need_convert)
    return self
end

function TInputSize:unpack(_)
    return self.InputSize
end

MDftHwChannel.InputSize = TInputSize

---@class MDftHwChannel.OutputChip
---@field OutputChip integer[]
local TOutputChip = {}
TOutputChip.__index = TOutputChip
TOutputChip.group = {}

local function TOutputChip_from_obj(obj)
    return setmetatable(obj, TOutputChip)
end

function TOutputChip.new(OutputChip)
    return TOutputChip_from_obj({OutputChip = OutputChip})
end
---@param obj MDftHwChannel.OutputChip
function TOutputChip:init_from_obj(obj)
    self.OutputChip = obj.OutputChip
end

function TOutputChip:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TOutputChip.group)
end

TOutputChip.from_obj = TOutputChip_from_obj

TOutputChip.proto_property = {'OutputChip'}

TOutputChip.default = {{}}

TOutputChip.struct = {{name = 'OutputChip', is_array = true, struct = nil}}

function TOutputChip:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.OptionalArray(prefix .. 'OutputChip', self.OutputChip, 'uint8', false, errs, need_convert)

    TOutputChip:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TOutputChip.proto_property, errs, need_convert)
    return self
end

function TOutputChip:unpack(_)
    return self.OutputChip
end

MDftHwChannel.OutputChip = TOutputChip

---@class MDftHwChannel.InputChip
---@field InputChip integer[]
local TInputChip = {}
TInputChip.__index = TInputChip
TInputChip.group = {}

local function TInputChip_from_obj(obj)
    return setmetatable(obj, TInputChip)
end

function TInputChip.new(InputChip)
    return TInputChip_from_obj({InputChip = InputChip})
end
---@param obj MDftHwChannel.InputChip
function TInputChip:init_from_obj(obj)
    self.InputChip = obj.InputChip
end

function TInputChip:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TInputChip.group)
end

TInputChip.from_obj = TInputChip_from_obj

TInputChip.proto_property = {'InputChip'}

TInputChip.default = {{}}

TInputChip.struct = {{name = 'InputChip', is_array = true, struct = nil}}

function TInputChip:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.OptionalArray(prefix .. 'InputChip', self.InputChip, 'uint8', false, errs, need_convert)

    TInputChip:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TInputChip.proto_property, errs, need_convert)
    return self
end

function TInputChip:unpack(_)
    return self.InputChip
end

MDftHwChannel.InputChip = TInputChip

---@class MDftHwChannel.OutputValue
---@field OutputValue integer[]
local TOutputValue = {}
TOutputValue.__index = TOutputValue
TOutputValue.group = {}

local function TOutputValue_from_obj(obj)
    return setmetatable(obj, TOutputValue)
end

function TOutputValue.new(OutputValue)
    return TOutputValue_from_obj({OutputValue = OutputValue})
end
---@param obj MDftHwChannel.OutputValue
function TOutputValue:init_from_obj(obj)
    self.OutputValue = obj.OutputValue
end

function TOutputValue:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TOutputValue.group)
end

TOutputValue.from_obj = TOutputValue_from_obj

TOutputValue.proto_property = {'OutputValue'}

TOutputValue.default = {{}}

TOutputValue.struct = {{name = 'OutputValue', is_array = true, struct = nil}}

function TOutputValue:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.OptionalArray(prefix .. 'OutputValue', self.OutputValue, 'uint8', false, errs, need_convert)

    TOutputValue:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TOutputValue.proto_property, errs, need_convert)
    return self
end

function TOutputValue:unpack(_)
    return self.OutputValue
end

MDftHwChannel.OutputValue = TOutputValue

---@class MDftHwChannel.InputValue
---@field InputValue integer[]
local TInputValue = {}
TInputValue.__index = TInputValue
TInputValue.group = {}

local function TInputValue_from_obj(obj)
    return setmetatable(obj, TInputValue)
end

function TInputValue.new(InputValue)
    return TInputValue_from_obj({InputValue = InputValue})
end
---@param obj MDftHwChannel.InputValue
function TInputValue:init_from_obj(obj)
    self.InputValue = obj.InputValue
end

function TInputValue:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TInputValue.group)
end

TInputValue.from_obj = TInputValue_from_obj

TInputValue.proto_property = {'InputValue'}

TInputValue.default = {{}}

TInputValue.struct = {{name = 'InputValue', is_array = true, struct = nil}}

function TInputValue:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.OptionalArray(prefix .. 'InputValue', self.InputValue, 'uint8', false, errs, need_convert)

    TInputValue:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TInputValue.proto_property, errs, need_convert)
    return self
end

function TInputValue:unpack(_)
    return self.InputValue
end

MDftHwChannel.InputValue = TInputValue

---@class MDftHwChannel.Output
---@field Output integer
local TOutput = {}
TOutput.__index = TOutput
TOutput.group = {}

local function TOutput_from_obj(obj)
    return setmetatable(obj, TOutput)
end

function TOutput.new(Output)
    return TOutput_from_obj({Output = Output})
end
---@param obj MDftHwChannel.Output
function TOutput:init_from_obj(obj)
    self.Output = obj.Output
end

function TOutput:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TOutput.group)
end

TOutput.from_obj = TOutput_from_obj

TOutput.proto_property = {'Output'}

TOutput.default = {0}

TOutput.struct = {{name = 'Output', is_array = false, struct = nil}}

function TOutput:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'Output', self.Output, 'uint8', false, errs, need_convert)

    TOutput:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TOutput.proto_property, errs, need_convert)
    return self
end

function TOutput:unpack(_)
    return self.Output
end

MDftHwChannel.Output = TOutput

---@class MDftHwChannel.Input
---@field Input integer
local TInput = {}
TInput.__index = TInput
TInput.group = {}

local function TInput_from_obj(obj)
    return setmetatable(obj, TInput)
end

function TInput.new(Input)
    return TInput_from_obj({Input = Input})
end
---@param obj MDftHwChannel.Input
function TInput:init_from_obj(obj)
    self.Input = obj.Input
end

function TInput:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TInput.group)
end

TInput.from_obj = TInput_from_obj

TInput.proto_property = {'Input'}

TInput.default = {0}

TInput.struct = {{name = 'Input', is_array = false, struct = nil}}

function TInput:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'Input', self.Input, 'uint8', false, errs, need_convert)

    TInput:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TInput.proto_property, errs, need_convert)
    return self
end

function TInput:unpack(_)
    return self.Input
end

MDftHwChannel.Input = TInput

---@class MDftHwChannel.TestType
---@field TestType integer
local TTestType = {}
TTestType.__index = TTestType
TTestType.group = {}

local function TTestType_from_obj(obj)
    return setmetatable(obj, TTestType)
end

function TTestType.new(TestType)
    return TTestType_from_obj({TestType = TestType})
end
---@param obj MDftHwChannel.TestType
function TTestType:init_from_obj(obj)
    self.TestType = obj.TestType
end

function TTestType:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TTestType.group)
end

TTestType.from_obj = TTestType_from_obj

TTestType.proto_property = {'TestType'}

TTestType.default = {0}

TTestType.struct = {{name = 'TestType', is_array = false, struct = nil}}

function TTestType:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'TestType', self.TestType, 'uint8', false, errs, need_convert)

    TTestType:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TTestType.proto_property, errs, need_convert)
    return self
end

function TTestType:unpack(_)
    return self.TestType
end

MDftHwChannel.TestType = TTestType

---@class MDftHwChannel.IFType
---@field IFType integer
local TIFType = {}
TIFType.__index = TIFType
TIFType.group = {}

local function TIFType_from_obj(obj)
    return setmetatable(obj, TIFType)
end

function TIFType.new(IFType)
    return TIFType_from_obj({IFType = IFType})
end
---@param obj MDftHwChannel.IFType
function TIFType:init_from_obj(obj)
    self.IFType = obj.IFType
end

function TIFType:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TIFType.group)
end

TIFType.from_obj = TIFType_from_obj

TIFType.proto_property = {'IFType'}

TIFType.default = {0}

TIFType.struct = {{name = 'IFType', is_array = false, struct = nil}}

function TIFType:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'IFType', self.IFType, 'uint8', false, errs, need_convert)

    TIFType:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TIFType.proto_property, errs, need_convert)
    return self
end

function TIFType:unpack(_)
    return self.IFType
end

MDftHwChannel.IFType = TIFType

return MDftHwChannel
