-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
local validate = require 'mc.validate'
local utils = require 'mc.utils'

local def_types = require 'class.types.types'

local MDPUCard = {}

---@class MDPUCard.IgnoreSerialCableAlarm
---@field IgnoreSerialCableAlarm boolean
local TIgnoreSerialCableAlarm = {}
TIgnoreSerialCableAlarm.__index = TIgnoreSerialCableAlarm
TIgnoreSerialCableAlarm.group = {}

local function TIgnoreSerialCableAlarm_from_obj(obj)
    return setmetatable(obj, TIgnoreSerialCableAlarm)
end

function TIgnoreSerialCableAlarm.new(IgnoreSerialCableAlarm)
    return TIgnoreSerialCableAlarm_from_obj({IgnoreSerialCableAlarm = IgnoreSerialCableAlarm or false})
end
---@param obj MDPUCard.IgnoreSerialCableAlarm
function TIgnoreSerialCableAlarm:init_from_obj(obj)
    self.IgnoreSerialCableAlarm = obj.IgnoreSerialCableAlarm or false
end

function TIgnoreSerialCableAlarm:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TIgnoreSerialCableAlarm.group)
end

TIgnoreSerialCableAlarm.from_obj = TIgnoreSerialCableAlarm_from_obj

TIgnoreSerialCableAlarm.proto_property = {'IgnoreSerialCableAlarm'}

TIgnoreSerialCableAlarm.default = {false}

TIgnoreSerialCableAlarm.struct = {{name = 'IgnoreSerialCableAlarm', is_array = false, struct = nil}}

function TIgnoreSerialCableAlarm:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'IgnoreSerialCableAlarm', self.IgnoreSerialCableAlarm, 'bool', false, errs, need_convert)

    TIgnoreSerialCableAlarm:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TIgnoreSerialCableAlarm.proto_property, errs, need_convert)
    return self
end

function TIgnoreSerialCableAlarm:unpack(_)
    return self.IgnoreSerialCableAlarm
end

MDPUCard.IgnoreSerialCableAlarm = TIgnoreSerialCableAlarm

---@class MDPUCard.RefFrudata
---@field RefFrudata integer[]
local TRefFrudata = {}
TRefFrudata.__index = TRefFrudata
TRefFrudata.group = {}

local function TRefFrudata_from_obj(obj)
    return setmetatable(obj, TRefFrudata)
end

function TRefFrudata.new(RefFrudata)
    return TRefFrudata_from_obj({RefFrudata = RefFrudata})
end
---@param obj MDPUCard.RefFrudata
function TRefFrudata:init_from_obj(obj)
    self.RefFrudata = obj.RefFrudata
end

function TRefFrudata:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TRefFrudata.group)
end

TRefFrudata.from_obj = TRefFrudata_from_obj

TRefFrudata.proto_property = {'RefFrudata'}

TRefFrudata.default = {{}}

TRefFrudata.struct = {{name = 'RefFrudata', is_array = true, struct = nil}}

function TRefFrudata:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.OptionalArray(prefix .. 'RefFrudata', self.RefFrudata, 'uint8', false, errs, need_convert)

    TRefFrudata:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TRefFrudata.proto_property, errs, need_convert)
    return self
end

function TRefFrudata:unpack(_)
    return self.RefFrudata
end

MDPUCard.RefFrudata = TRefFrudata

---@class MDPUCard.SerialRecordConnect
---@field SerialRecordConnect def_types.Connection[]
local TSerialRecordConnect = {}
TSerialRecordConnect.__index = TSerialRecordConnect
TSerialRecordConnect.group = {}

local function TSerialRecordConnect_from_obj(obj)
    obj.SerialRecordConnect = utils.from_obj(def_types.Connection, obj.SerialRecordConnect, true)
    return setmetatable(obj, TSerialRecordConnect)
end

function TSerialRecordConnect.new(SerialRecordConnect)
    return TSerialRecordConnect_from_obj({SerialRecordConnect = SerialRecordConnect})
end
---@param obj MDPUCard.SerialRecordConnect
function TSerialRecordConnect:init_from_obj(obj)
    self.SerialRecordConnect = obj.SerialRecordConnect
end

function TSerialRecordConnect:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSerialRecordConnect.group)
end

TSerialRecordConnect.from_obj = TSerialRecordConnect_from_obj

TSerialRecordConnect.proto_property = {'SerialRecordConnect'}

TSerialRecordConnect.default = {{}}

TSerialRecordConnect.struct = {{name = 'SerialRecordConnect', is_array = true, struct = def_types.Connection.struct}}

function TSerialRecordConnect:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    for _, v in pairs(self.SerialRecordConnect) do
        def_types.Connection.new(v.Source, v.Destination):validate(prefix, errs, need_convert)
    end

    TSerialRecordConnect:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSerialRecordConnect.proto_property, errs, need_convert)
    return self
end

function TSerialRecordConnect:unpack(raw)
    return utils.unpack(raw, self.SerialRecordConnect, true)
end

MDPUCard.SerialRecordConnect = TSerialRecordConnect

---@class MDPUCard.RefWPChip
---@field RefWPChip integer[]
local TRefWPChip = {}
TRefWPChip.__index = TRefWPChip
TRefWPChip.group = {}

local function TRefWPChip_from_obj(obj)
    return setmetatable(obj, TRefWPChip)
end

function TRefWPChip.new(RefWPChip)
    return TRefWPChip_from_obj({RefWPChip = RefWPChip})
end
---@param obj MDPUCard.RefWPChip
function TRefWPChip:init_from_obj(obj)
    self.RefWPChip = obj.RefWPChip
end

function TRefWPChip:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TRefWPChip.group)
end

TRefWPChip.from_obj = TRefWPChip_from_obj

TRefWPChip.proto_property = {'RefWPChip'}

TRefWPChip.default = {{}}

TRefWPChip.struct = {{name = 'RefWPChip', is_array = true, struct = nil}}

function TRefWPChip:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.OptionalArray(prefix .. 'RefWPChip', self.RefWPChip, 'uint8', false, errs, need_convert)

    TRefWPChip:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TRefWPChip.proto_property, errs, need_convert)
    return self
end

function TRefWPChip:unpack(_)
    return self.RefWPChip
end

MDPUCard.RefWPChip = TRefWPChip

---@class MDPUCard.RefIdChip
---@field RefIdChip integer[]
local TRefIdChip = {}
TRefIdChip.__index = TRefIdChip
TRefIdChip.group = {}

local function TRefIdChip_from_obj(obj)
    return setmetatable(obj, TRefIdChip)
end

function TRefIdChip.new(RefIdChip)
    return TRefIdChip_from_obj({RefIdChip = RefIdChip})
end
---@param obj MDPUCard.RefIdChip
function TRefIdChip:init_from_obj(obj)
    self.RefIdChip = obj.RefIdChip
end

function TRefIdChip:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TRefIdChip.group)
end

TRefIdChip.from_obj = TRefIdChip_from_obj

TRefIdChip.proto_property = {'RefIdChip'}

TRefIdChip.default = {{}}

TRefIdChip.struct = {{name = 'RefIdChip', is_array = true, struct = nil}}

function TRefIdChip:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.OptionalArray(prefix .. 'RefIdChip', self.RefIdChip, 'uint8', false, errs, need_convert)

    TRefIdChip:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TRefIdChip.proto_property, errs, need_convert)
    return self
end

function TRefIdChip:unpack(_)
    return self.RefIdChip
end

MDPUCard.RefIdChip = TRefIdChip

---@class MDPUCard.LockChip
---@field LockChip integer[]
local TLockChip = {}
TLockChip.__index = TLockChip
TLockChip.group = {}

local function TLockChip_from_obj(obj)
    return setmetatable(obj, TLockChip)
end

function TLockChip.new(LockChip)
    return TLockChip_from_obj({LockChip = LockChip})
end
---@param obj MDPUCard.LockChip
function TLockChip:init_from_obj(obj)
    self.LockChip = obj.LockChip
end

function TLockChip:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TLockChip.group)
end

TLockChip.from_obj = TLockChip_from_obj

TLockChip.proto_property = {'LockChip'}

TLockChip.default = {{}}

TLockChip.struct = {{name = 'LockChip', is_array = true, struct = nil}}

function TLockChip:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.OptionalArray(prefix .. 'LockChip', self.LockChip, 'uint8', false, errs, need_convert)

    TLockChip:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TLockChip.proto_property, errs, need_convert)
    return self
end

function TLockChip:unpack(_)
    return self.LockChip
end

MDPUCard.LockChip = TLockChip

---@class MDPUCard.RefChip
---@field RefChip integer[]
local TRefChip = {}
TRefChip.__index = TRefChip
TRefChip.group = {}

local function TRefChip_from_obj(obj)
    return setmetatable(obj, TRefChip)
end

function TRefChip.new(RefChip)
    return TRefChip_from_obj({RefChip = RefChip})
end
---@param obj MDPUCard.RefChip
function TRefChip:init_from_obj(obj)
    self.RefChip = obj.RefChip
end

function TRefChip:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TRefChip.group)
end

TRefChip.from_obj = TRefChip_from_obj

TRefChip.proto_property = {'RefChip'}

TRefChip.default = {{}}

TRefChip.struct = {{name = 'RefChip', is_array = true, struct = nil}}

function TRefChip:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.OptionalArray(prefix .. 'RefChip', self.RefChip, 'uint8', false, errs, need_convert)

    TRefChip:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TRefChip.proto_property, errs, need_convert)
    return self
end

function TRefChip:unpack(_)
    return self.RefChip
end

MDPUCard.RefChip = TRefChip

return MDPUCard
