-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
local validate = require 'mc.validate'
local utils = require 'mc.utils'

local def_types = require 'class.types.types'

local MCustomizeSign = {}

---@class MCustomizeSign.ActiveCondition
---@field ActiveCondition string
local TActiveCondition = {}
TActiveCondition.__index = TActiveCondition
TActiveCondition.group = {}

local function TActiveCondition_from_obj(obj)
    return setmetatable(obj, TActiveCondition)
end

function TActiveCondition.new(ActiveCondition)
    return TActiveCondition_from_obj({ActiveCondition = ActiveCondition or [=[PowerOff]=]})
end
---@param obj MCustomizeSign.ActiveCondition
function TActiveCondition:init_from_obj(obj)
    self.ActiveCondition = obj.ActiveCondition or [=[PowerOff]=]
end

function TActiveCondition:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TActiveCondition.group)
end

TActiveCondition.from_obj = TActiveCondition_from_obj

TActiveCondition.proto_property = {'ActiveCondition'}

TActiveCondition.default = {''}

TActiveCondition.struct = {{name = 'ActiveCondition', is_array = false, struct = nil}}

function TActiveCondition:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'ActiveCondition', self.ActiveCondition, 'string', false, errs, need_convert)

    TActiveCondition:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TActiveCondition.proto_property, errs, need_convert)
    return self
end

function TActiveCondition:unpack(_)
    return self.ActiveCondition
end

MCustomizeSign.ActiveCondition = TActiveCondition

---@class MCustomizeSign.StartSlotItems
---@field StartSlotItems def_types.StartSlotItem[]
local TStartSlotItems = {}
TStartSlotItems.__index = TStartSlotItems
TStartSlotItems.group = {}

local function TStartSlotItems_from_obj(obj)
    obj.StartSlotItems = utils.from_obj(def_types.StartSlotItem, obj.StartSlotItems, true)
    return setmetatable(obj, TStartSlotItems)
end

function TStartSlotItems.new(StartSlotItems)
    return TStartSlotItems_from_obj({StartSlotItems = StartSlotItems})
end
---@param obj MCustomizeSign.StartSlotItems
function TStartSlotItems:init_from_obj(obj)
    self.StartSlotItems = obj.StartSlotItems
end

function TStartSlotItems:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TStartSlotItems.group)
end

TStartSlotItems.from_obj = TStartSlotItems_from_obj

TStartSlotItems.proto_property = {'StartSlotItems'}

TStartSlotItems.default = {{}}

TStartSlotItems.struct = {{name = 'StartSlotItems', is_array = true, struct = def_types.StartSlotItem.struct}}

function TStartSlotItems:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    for _, v in pairs(self.StartSlotItems) do
        def_types.StartSlotItem.new(v.HddBackPlaneSlot, v.DriveStartSlot):validate(prefix, errs, need_convert)
    end

    TStartSlotItems:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TStartSlotItems.proto_property, errs, need_convert)
    return self
end

function TStartSlotItems:unpack(raw)
    return utils.unpack(raw, self.StartSlotItems, true)
end

MCustomizeSign.StartSlotItems = TStartSlotItems

---@class MCustomizeSign.StartSlot
---@field StartSlot boolean
local TStartSlot = {}
TStartSlot.__index = TStartSlot
TStartSlot.group = {}

local function TStartSlot_from_obj(obj)
    return setmetatable(obj, TStartSlot)
end

function TStartSlot.new(StartSlot)
    return TStartSlot_from_obj({StartSlot = StartSlot or false})
end
---@param obj MCustomizeSign.StartSlot
function TStartSlot:init_from_obj(obj)
    self.StartSlot = obj.StartSlot or false
end

function TStartSlot:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TStartSlot.group)
end

TStartSlot.from_obj = TStartSlot_from_obj

TStartSlot.proto_property = {'StartSlot'}

TStartSlot.default = {false}

TStartSlot.struct = {{name = 'StartSlot', is_array = false, struct = nil}}

function TStartSlot:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'StartSlot', self.StartSlot, 'bool', false, errs, need_convert)

    TStartSlot:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TStartSlot.proto_property, errs, need_convert)
    return self
end

function TStartSlot:unpack(_)
    return self.StartSlot
end

MCustomizeSign.StartSlot = TStartSlot

---@class MCustomizeSign.Id
---@field Id string
local TId = {}
TId.__index = TId
TId.group = {}

local function TId_from_obj(obj)
    return setmetatable(obj, TId)
end

function TId.new(Id)
    return TId_from_obj({Id = Id})
end
---@param obj MCustomizeSign.Id
function TId:init_from_obj(obj)
    self.Id = obj.Id
end

function TId:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TId.group)
end

TId.from_obj = TId_from_obj

TId.proto_property = {'Id'}

TId.default = {''}

TId.struct = {{name = 'Id', is_array = false, struct = nil}}

function TId:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Required(prefix .. 'Id', self.Id, 'string', false, errs, need_convert)

    TId:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TId.proto_property, errs, need_convert)
    return self
end

function TId:unpack(_)
    return self.Id
end

MCustomizeSign.Id = TId

return MCustomizeSign
