--[[-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
]] --
local validate = require 'mc.validate'
local utils = require 'mc.utils'

local WriteElabelData = {}

---@class FrudataIpmiCmds.WriteElabelDataReq
---@field FruId integer
---@field Area integer
---@field Field integer
---@field Offset integer
---@field Len integer
---@field Datas string
local TWriteElabelDataReq = {}
TWriteElabelDataReq.__index = TWriteElabelDataReq
TWriteElabelDataReq.group = {}

local function TWriteElabelDataReq_from_obj(obj)
    return setmetatable(obj, TWriteElabelDataReq)
end

function TWriteElabelDataReq.new(FruId, Area, Field, Offset, Len, Datas)
    return TWriteElabelDataReq_from_obj({
        FruId = FruId,
        Area = Area,
        Field = Field,
        Offset = Offset,
        Len = Len,
        Datas = Datas
    })
end
---@param obj FrudataIpmiCmds.WriteElabelDataReq
function TWriteElabelDataReq:init_from_obj(obj)
    self.FruId = obj.FruId
    self.Area = obj.Area
    self.Field = obj.Field
    self.Offset = obj.Offset
    self.Len = obj.Len
    self.Datas = obj.Datas
end

function TWriteElabelDataReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TWriteElabelDataReq.group)
end

TWriteElabelDataReq.from_obj = TWriteElabelDataReq_from_obj

TWriteElabelDataReq.proto_property = {'FruId', 'Area', 'Field', 'Offset', 'Len', 'Datas'}

TWriteElabelDataReq.default = {0, 0, 0, 0, 0, ''}

TWriteElabelDataReq.struct = {
    {name = 'FruId', is_array = false, struct = nil}, {name = 'Area', is_array = false, struct = nil},
    {name = 'Field', is_array = false, struct = nil}, {name = 'Offset', is_array = false, struct = nil},
    {name = 'Len', is_array = false, struct = nil}, {name = 'Datas', is_array = false, struct = nil}
}

function TWriteElabelDataReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'FruId', self.FruId, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'Area', self.Area, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'Field', self.Field, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'Offset', self.Offset, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'Len', self.Len, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'Datas', self.Datas, 'string', false, errs, need_convert)

    TWriteElabelDataReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TWriteElabelDataReq.proto_property, errs, need_convert)
    return self
end

function TWriteElabelDataReq:unpack(_)
    return self.FruId, self.Area, self.Field, self.Offset, self.Len, self.Datas
end

WriteElabelData.WriteElabelDataReq = TWriteElabelDataReq

---@class FrudataIpmiCmds.WriteElabelDataRsp
---@field CompletionCode integer
local TWriteElabelDataRsp = {}
TWriteElabelDataRsp.__index = TWriteElabelDataRsp
TWriteElabelDataRsp.group = {}

local function TWriteElabelDataRsp_from_obj(obj)
    return setmetatable(obj, TWriteElabelDataRsp)
end

function TWriteElabelDataRsp.new(CompletionCode)
    return TWriteElabelDataRsp_from_obj({CompletionCode = CompletionCode})
end
---@param obj FrudataIpmiCmds.WriteElabelDataRsp
function TWriteElabelDataRsp:init_from_obj(obj)
    self.CompletionCode = obj.CompletionCode
end

function TWriteElabelDataRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TWriteElabelDataRsp.group)
end

TWriteElabelDataRsp.from_obj = TWriteElabelDataRsp_from_obj

TWriteElabelDataRsp.proto_property = {'CompletionCode'}

TWriteElabelDataRsp.default = {0}

TWriteElabelDataRsp.struct = {{name = 'CompletionCode', is_array = false, struct = nil}}

function TWriteElabelDataRsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'CompletionCode', self.CompletionCode, 'uint8', false, errs, need_convert)

    TWriteElabelDataRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TWriteElabelDataRsp.proto_property, errs, need_convert)
    return self
end

function TWriteElabelDataRsp:unpack(_)
    return self.CompletionCode
end

WriteElabelData.WriteElabelDataRsp = TWriteElabelDataRsp

return WriteElabelData
