--[[-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
]] --
local validate = require 'mc.validate'
local utils = require 'mc.utils'

local UpdateElabelData = {}

---@class FrudataIpmiCmds.UpdateElabelDataReq
---@field FruId integer
---@field Option integer
local TUpdateElabelDataReq = {}
TUpdateElabelDataReq.__index = TUpdateElabelDataReq
TUpdateElabelDataReq.group = {}

local function TUpdateElabelDataReq_from_obj(obj)
    return setmetatable(obj, TUpdateElabelDataReq)
end

function TUpdateElabelDataReq.new(FruId, Option)
    return TUpdateElabelDataReq_from_obj({FruId = FruId, Option = Option})
end
---@param obj FrudataIpmiCmds.UpdateElabelDataReq
function TUpdateElabelDataReq:init_from_obj(obj)
    self.FruId = obj.FruId
    self.Option = obj.Option
end

function TUpdateElabelDataReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TUpdateElabelDataReq.group)
end

TUpdateElabelDataReq.from_obj = TUpdateElabelDataReq_from_obj

TUpdateElabelDataReq.proto_property = {'FruId', 'Option'}

TUpdateElabelDataReq.default = {0, 0}

TUpdateElabelDataReq.struct = {
    {name = 'FruId', is_array = false, struct = nil}, {name = 'Option', is_array = false, struct = nil}
}

function TUpdateElabelDataReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'FruId', self.FruId, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'Option', self.Option, 'uint8', false, errs, need_convert)

    TUpdateElabelDataReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TUpdateElabelDataReq.proto_property, errs, need_convert)
    return self
end

function TUpdateElabelDataReq:unpack(_)
    return self.FruId, self.Option
end

UpdateElabelData.UpdateElabelDataReq = TUpdateElabelDataReq

---@class FrudataIpmiCmds.UpdateElabelDataRsp
---@field CompletionCode integer
---@field UpdateProgress string
local TUpdateElabelDataRsp = {}
TUpdateElabelDataRsp.__index = TUpdateElabelDataRsp
TUpdateElabelDataRsp.group = {}

local function TUpdateElabelDataRsp_from_obj(obj)
    return setmetatable(obj, TUpdateElabelDataRsp)
end

function TUpdateElabelDataRsp.new(CompletionCode, UpdateProgress)
    return TUpdateElabelDataRsp_from_obj({CompletionCode = CompletionCode, UpdateProgress = UpdateProgress})
end
---@param obj FrudataIpmiCmds.UpdateElabelDataRsp
function TUpdateElabelDataRsp:init_from_obj(obj)
    self.CompletionCode = obj.CompletionCode
    self.UpdateProgress = obj.UpdateProgress
end

function TUpdateElabelDataRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TUpdateElabelDataRsp.group)
end

TUpdateElabelDataRsp.from_obj = TUpdateElabelDataRsp_from_obj

TUpdateElabelDataRsp.proto_property = {'CompletionCode', 'UpdateProgress'}

TUpdateElabelDataRsp.default = {0, ''}

TUpdateElabelDataRsp.struct = {
    {name = 'CompletionCode', is_array = false, struct = nil}, {name = 'UpdateProgress', is_array = false, struct = nil}
}

function TUpdateElabelDataRsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'CompletionCode', self.CompletionCode, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'UpdateProgress', self.UpdateProgress, 'string', false, errs, need_convert)

    TUpdateElabelDataRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TUpdateElabelDataRsp.proto_property, errs, need_convert)
    return self
end

function TUpdateElabelDataRsp:unpack(_)
    return self.CompletionCode, self.UpdateProgress
end

UpdateElabelData.UpdateElabelDataRsp = TUpdateElabelDataRsp

return UpdateElabelData
